.386p

        .xlist
        include vmm.inc
        include debug.inc
        include shell.inc
        include vpicd.inc
        include vdmad.inc
        include vkd.inc
 ;       include mssndsys.inc

        include msgmacro.inc
        include messages.inc

        include equates.inc
		
		include dreamvxd.inc
        include dsnd.inc
        .list

extrn _WriteP16:NEAR

extrn	_gbModAnsByte:BYTE		; dreamvxd.asm  
extrn	_gwModAnsNb:WORD		; dreamvxd.asm  
extrn	_gbModAnsLong:DWORD		; dreamvxd.asm  

extrn DREAM_Acquire:NEAR


;==============================================================================
;                   N O N P A G E A B L E   D A T A
;==============================================================================

VxD_LOCKED_DATA_SEG

public	_fInX
public	_fInY
public	_fOut
_fInX	dd  0
_fInY	dd  0
_fOut	dd  0

wTwo	dd	40000000h
CWord	dw	0

VxD_LOCKED_DATA_ENDS


VxD_PAGEABLE_CODE_SEG
           

;; Get the driver description string from the string resource.
;; Uses only the eax register.

BeginProc _GetDsDesc, PUBLIC

        GET_MESSAGE_PTR <gszDsDesc>, eax
        ret

EndProc _GetDsDesc


BeginProc _ReleaseDS, PUBLIC
DevNode equ     [ebp + 8]
        push    ebp
        mov     ebp, esp
        push    edi
		push	esi
        push    ebx

        ;; get the sndsys pointer
        mov     eax, DevNode
        cCall   _DREAM_Get_pMSMI_From_XXX, <eax, pMSMI_FromDevNode>

        ;; clear our flag
        mov     [edi.msmi_DsRunning], 0

        pop     ebx
		pop		esi
        pop     edi
        pop     ebp
        ret
EndProc _ReleaseDS

BeginProc _AcquireDS, PUBLIC
DevNode equ     [ebp + 8]

        push    ebp
        mov     ebp, esp
        push    edi
		push	esi
        push    edx
        push    ebx

        mov     edx, 0ffffh     ;; set the exit value


        ;; get a pointer to the snssys context data
        mov     eax, DevNode
        cCall   _DREAM_Get_pMSMI_From_XXX, <eax, pMSMI_FromDevNode>

        ;; is there a current owner?
        mov     eax, [edi.msmi_dwMPU401OwnerCur]
        VMMcall Get_Sys_VM_Handle
        cmp     eax, ebx
        je      we_own_it

        ;; there is a non-sysvm owner, bail
        jmp     acquire_done
we_own_it:

        ;; set our flag for the interrupt handler
        mov     [edi.msmi_DsRunning], 1
        mov     edx, 0          ;; return a good value

acquire_done:
        mov     eax, edx        ;; set our return value

        pop     ebx
        pop     edx
		pop		esi
        pop     edi
        pop     ebp
        ret
EndProc _AcquireDS

BeginProc _FillInDsBufferStruct, PUBLIC

DsBufferStruct  equ     [ebp + 8]
DevNode         equ     [ebp + 12]

        push    ebp
        mov     ebp, esp
        push    edi
        push    esi
		push	ebx

        ;; get a pointer to the struct to fill in
        mov     esi, DsBufferStruct
        ;; get a pointer to sndsys's data
        mov     eax, DevNode
        cCall   _DREAM_Get_pMSMI_From_XXX, <eax, pMSMI_FromDevNode>

        ;; pull out all the values we need      

        mov     ax, [edi.msmi_wIOAddressMPU401]
        mov     [esi.dsd_BaseAddress], ax

		mov     eax, [edi.msmi_dwIRQHandle]
        mov     [esi.dsd_dwIRQHandle], eax

        mov     ax, [edi.msmi_wHardwareOptions]
        mov     [esi.dsd_HardwareOptions], ax

		pop		ebx
        pop     esi
        pop     edi
        pop     ebp
        ret

EndProc _FillInDsBufferStruct



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	DREAM Direct Sound Functions
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	bufCommand
;
;	Send a command (open, start, stop , close) to a mod voice
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;			BYTE Command
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufCommand, PUBLIC

pBufCtx			equ     [ebp + 8]
Command			equ		[ebp+12]

        push    ebp
        mov     ebp, esp
		push	esi
		push	ebx
		push	ecx
		push	edi
		pushad	
		
        mov		esi, pBufCtx				; pointer on buffer context structure
		              
		movzx		edx, [esi.dsd_BaseAddress]        
		movzx			eax, [esi.dsd_wBufferNb] 
		movzx			ecx, [esi.dsd_wBufferNb2] 
		mov			ebx, Command

		cli
		cCall	_WriteP16, <edx, ebx,1>
			
		cmp		ebx, 52h			; is it an OPEN
		jne		SendNb
		cmp		[esi.dsd_BufferSize], 1024*256		; is the buffer size > 1 page
		ja		CrossB
		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		je		SendNb
CrossB:
		add		eax, 80h
		add		ecx, 80h
SendNb:
		cCall	_WriteP16, <edx, eax,0>


		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		jne		bcExit
		
		; send command for 2nd channel buffer (stereo)
		cCall	_WriteP16, <edx, ebx,1>
		cCall	_WriteP16, <edx, ecx,0>


bcExit:
		sti

			
		popad
		pop		edi
		pop		ecx
		pop		ebx
		pop		esi	
        pop     ebp
        ret

EndProc _bufCommand

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_bufGetPos
;
;	Get the current position for a voice
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufGetPos, PUBLIC

pBufCtx			equ     [ebp + 8]

        push    ebp
        mov     ebp, esp

		push	esi
		push	edi
		push	ebx
		
        mov		esi, pBufCtx				; pointer on buffer context structure
		              
		movzx	edx, [esi.dsd_BaseAddress]                         
		mov		cx, [esi.dsd_wBufferNb]
		
		;mov		eax, [esi.dsd_dwIRQHandle]
		;VxDcall VPICD_Physically_Mask
		cli
		mov		[_gwModAnsNb], 4
		cCall	_WriteP16, <edx, GET_POS,1>
		cCall	_WriteP16, <edx, ecx,0>
		sti
		;mov		eax, [esi.dsd_dwIRQHandle]
		;VxDcall VPICD_Physically_UnMask

		inc		dx							; status port
		mov		ecx, 100000h
Wait4It:
		cmp		[_gwModAnsNb],0
		jz		gpSuccess
		in		al, dx						; 1.5 us tempo
		loop	Wait4It

		mov		eax, 0ffffffffh				; error returned value
		jmp		gpExit
gpSuccess:
		mov		eax, [_gbModAnsLong]			; value returned
gpExit:
		pop		ebx
		pop		edi
		pop		esi
        pop     ebp
        ret

EndProc _bufGetPos


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 
;	bufSetFreq
;
;	Change the pitch for  a mod voice
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;			BYTE Command
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufSetFreq, PUBLIC

pBufCtx			equ     [ebp + 8]
freq			equ		[ebp + 12]

        push    ebp
        mov     ebp, esp
	
		push	esi
		push	edi
		push	ebx

	    mov		esi, pBufCtx				; pointer on buffer context structure

		cli
		movzx		edx, [esi.dsd_BaseAddress]
		cCall	_WriteP16, <edx, VOI_PITCH,1>
		mov		cx, [esi.dsd_wBufferNb]
		cCall	_WriteP16, <edx, ecx,0 >
		mov		eax, freq	
		cCall	_WriteP16, <edx, eax, 0>
		shr		ax, 8
		cCall	_WriteP16, <edx, eax, 0>

		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		jne		sfExit
		; set pitch for 2nd channel buffer (stereo)

		cCall	_WriteP16, <edx, VOI_PITCH,1>
		mov		cx, [esi.dsd_wBufferNb2]
		cCall	_WriteP16, <edx, ecx,0 >
		mov		eax, freq		
		cCall	_WriteP16, <edx, eax, 0>
		shr		ax, 8
		cCall	_WriteP16, <edx, eax, 0>

sfExit:
		sti

		pop		ebx
		pop		edi
		pop		esi
        pop     ebp
        ret

EndProc _bufSetFreq


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	bufSetVol
;
;	Change the volume and pan for  a mod voice
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;			BYTE Vol
;			BYTE VolR
;			BYTE VolL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufSetVol, PUBLIC

pBufCtx			equ     [ebp + 8]
MasterVol		equ		[ebp + 12]

        push    ebp
        mov     ebp, esp

		push	ebx
		push	esi
		push	edi
		
		 mov		esi, pBufCtx				; pointer on buffer context structure

		mov		bx, [esi.dsd_wBufferNb]
		cli
		movzx		edx, [esi.dsd_BaseAddress]

		cCall	_WriteP16, <edx, VOI_VOL,1>
		cCall	_WriteP16, <edx, ebx,0 >
		cCall	_WriteP16, <edx, MasterVol, 0>

		cCall	_WriteP16, <edx, VOI_MAIN,1>
		cCall	_WriteP16, <edx, ebx, 0 >

		mov		eax, 0
		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		je		SendVol
		; mono buffer (set Right Volume)
		mov		eax, [esi.dsd_RVol]

SendVol:
		cCall	_WriteP16, <edx,eax ,0>
		cCall	_WriteP16, <edx, [esi.dsd_LVol],0>
		

		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		jne		svExit
		; send volume for Right buffer
		mov		bx, [esi.dsd_wBufferNb2]
		cCall	_WriteP16, <edx, VOI_VOL,1>
		cCall	_WriteP16, <edx, ebx,0 >
		cCall	_WriteP16, <edx, MasterVol, 0>

		cCall	_WriteP16, <edx, VOI_MAIN,1>
		cCall	_WriteP16, <edx, ebx, 0 >
		cCall	_WriteP16, <edx,[esi.dsd_RVol] ,0>
		cCall	_WriteP16, <edx, 0,0>

svExit:
		sti

		pop		edi
		pop		esi
		pop		ebx
        pop     ebp
        ret

EndProc _bufSetVol



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	bufDefineMem
;
;	Define the looping features for a buffer
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;			BYTE Vol
;			BYTE VolR
;			BYTE VolL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufDefineMem, PUBLIC

pBufCtx			equ     [ebp + 8]
Format			equ		[ebp+12]
Start			equ		[ebp+16]
PLoop			equ		[ebp+20]
PEnd			equ		[ebp+24]


        push    ebp
        mov     ebp, esp

		push	esi
		push	ebx
		push	edi

		Trace_Out <"Define memory">

        mov		esi, pBufCtx				; pointer on buffer context structure


		; Define memory buffer
		mov		eax, Start		; relative start
		add		eax, [esi.dsd_BoardAddr]		; absolute address
		mov		ebx, eax
		shr		ebx, 18				;Start Page
		and		eax, 3ffffh			;Start offset
		movzx		ecx, [esi.dsd_wBufferNb]
		cli 
		movzx		edx, [esi.dsd_BaseAddress]

		cCall	_WriteP16, <edx, VOI_MEM,1>
		cCall	_WriteP16, <edx, ecx,0 >
		mov		ecx, Format
		cmp		ecx, 0
		jz		SendFmt
		add		ecx, 40h			;Left Sample in high byte
SendFmt:
		cCall	_WriteP16, <edx, ecx,0>

		cCall	_WriteP16, <edx, ebx, 0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>

		mov		eax, PLoop		; relative loop
		add		eax, [esi.dsd_BoardAddr]		; absolute loop
		mov		ebx, eax
		shr		ebx, 18				;loop Page
		and		eax, 3ffffh			;loop offset
		cCall	_WriteP16, <edx, ebx,0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>


		mov		eax, PEnd		; relative end
		add		eax, [esi.dsd_BoardAddr]		; absolute end
		mov		ebx, eax
		shr		ebx, 18				;Start Page
		and		eax, 3ffffh			;Start offset

		cCall	_WriteP16, <edx, ebx,0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>

		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		jne		dmExit

		; Define memory for 2nd channel buffer (stereo)
		mov		eax, Start		; relative start
		add		eax, [esi.dsd_BoardAddr2]		; absolute address
		mov		ebx, eax
		shr		ebx, 18				;Start Page
		and		eax, 3ffffh			;Start offset
		movzx		ecx, [esi.dsd_wBufferNb2]
		movzx		edx, [esi.dsd_BaseAddress]

		cCall	_WriteP16, <edx, VOI_MEM,1>
		cCall	_WriteP16, <edx, ecx,0 >
		cCall	_WriteP16, <edx, Format,0>

		cCall	_WriteP16, <edx, ebx, 0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>

		mov		eax, PLoop		; relative loop
		add		eax, [esi.dsd_BoardAddr2]		; absolute loop
		mov		ebx, eax
		shr		ebx, 18				;loop Page
		and		eax, 3ffffh			;loop offset
		cCall	_WriteP16, <edx, ebx,0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>


		mov		eax, PEnd		; relative end
		add		eax, [esi.dsd_BoardAddr2]		; absolute end
		mov		ebx, eax
		shr		ebx, 18				;Start Page
		and		eax, 3ffffh			;Start offset

		cCall	_WriteP16, <edx, ebx,0>
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax, 0>


dmExit:
		sti

		pop		edi
		pop		ebx
		pop		esi
        pop     ebp
        ret

EndProc _bufDefineMem

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_bufGetVoicesNb
;
;	return the number of voice (mod device)
;	Param :
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufGetVoicesNb, PUBLIC

BaseAdd			equ     [ebp + 8]

        push    ebp
        mov     ebp, esp

		push	edi
		push	esi
		push	ebx


		;mov     eax, DevNode
        ;cCall   _DREAM_Get_pMSMI_From_XXX, <eax, pMSMI_FromDevNode>
		              
		;movzx		edx, [edi.msmi_wIOAddressMPU401]    
		mov			edx, BaseAdd    

		cli
		mov		[_gwModAnsNb], 1
		mov		eax, GET_VOI
		cCall	_WriteP16, <edx, eax,0001h>
		cCall	_WriteP16, <edx, 0000h,0000h>
		sti

		inc		dx							; status port
		mov		ecx, 100000h
Wait4It2:
		cmp		[_gwModAnsNb],0
		jz		gvSuccess
		in		al, dx						; 1.5 us tempo
		loop	Wait4It2

		mov		eax, 0		; error returned value
		jmp		gvExit
gvSuccess:
		xor		eax, eax
		mov		al, [_gbModAnsByte]			; value returned
gvExit:
		pop		ebx
		pop		esi
		pop		edi	
        pop     ebp
        ret

EndProc _bufGetVoicesNb

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_bufSetPos
;
;	Add an offset to the current position for a voice
;	Param : DWORD PBufCtx ->pointer on buffer context structure
;	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _bufSetPos, PUBLIC

pBufCtx			equ     [ebp + 8]
sPage			equ		[ebp + 12]
sOffset			equ		[ebp + 16]

        push    ebp
        mov     ebp, esp

		push	esi
		push	edi
		push	ebx
		
        mov		esi, pBufCtx				; pointer on buffer context structure
		              
		movzx	edx, [esi.dsd_BaseAddress]                         
		mov		cx, [esi.dsd_wBufferNb]
		mov		eax, sPage
		
		cli
		cCall	_WriteP16, <edx, ADD_POS,1>
		cCall	_WriteP16, <edx, ecx,0>
		cCall	_WriteP16, <edx, eax,0>
		mov		eax, sOffset
		cCall	_WriteP16, <edx, eax,0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax,0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax,0>

		cmp		[esi.dsd_nChannels], 2		;Is it a stereo buffer
		jne		spExit
		
		mov		cx, [esi.dsd_wBufferNb2]
		mov		eax, sPage
		cCall	_WriteP16, <edx, ADD_POS,1>
		cCall	_WriteP16, <edx, ecx,0>
		cCall	_WriteP16, <edx, eax,0>
		mov		eax, sOffset
		cCall	_WriteP16, <edx, eax,0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax,0>
		shr		eax, 8
		cCall	_WriteP16, <edx, eax,0>
		
spExit:
		sti
		
		pop		ebx
		pop		edi
		pop		esi
        pop     ebp
        ret

EndProc _bufSetPos



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_modChangeParam
;
;	modify one parameter (volume, pitch, filter) for a voice
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _modChangeParam, PUBLIC

pBufCtx			equ     [ebp + 8]
Command			equ		[ebp + 12]
Param			equ		[ebp + 16]

        push    ebp
        mov     ebp, esp
		push	esi
		push	ebx
		push	edi
		pushad	
		
        mov		esi, pBufCtx				; pointer on buffer context structure
		              
		movzx		edx, [esi.dsd_BaseAddress]        
		movzx			eax, [esi.dsd_wBufferNb] 
		mov			ebx, Command

		cli
		cCall	_WriteP16, <edx, ebx,1>			; Command
		cCall	_WriteP16, <edx, eax,0>			; buffer nb
		mov		eax, Param
		cCall	_WriteP16, <edx, eax,0>			; first parameter byte

		cmp		ebx, 56h						; Is it a VOI_VOL?
		je		mcpExit							; Y : exit

		shr		eax, 8							; N : send second Param
		cCall	_WriteP16, <edx, eax,0>			; first parameter byte


mcpExit:
		sti

			
		popad
		pop		edi
		pop		ebx
		pop		esi	
        pop     ebp
        ret

EndProc _modChangeParam



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_dsPow
;
;	Compute pow(x,y)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _dsPow, PUBLIC


		fld		_fInY		; move data onto the FPU stack (32b?)
		fld		_fInX		; move data onto the FPU stack (32b?)
		fyl2x				; y*log2(x)
		

		; change the controle word for rounding in truncating
		fstcw	CWord

		push	CWord		; save it

		or		CWord, 0c00h	; RC=11-->round in truncating
		fldcw	CWord

		; let's round y*log2(x)
		fst		ST(1)				;y*log2(x)
		frndint					;int(y*log2(x))
		fxch	ST(1)
		fsub	ST, ST(1)		; y*log2(x)-int(y*log2(x))=X-int(X)

		pop		CWord			; restore Controle Word
		fldcw	CWord
				
		f2xm1					; 2^(X-int(X))-1				
		
		fld1
		faddp	ST(1), ST		; 2^(X-int(X))
		
		fscale					; 2^(X-int(X))*2^(int(X))=2^X=pow(x,y)

		fstp		_fOut	
		fstp	ST				; just for popping

        ret

EndProc _dsPow


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_dsSqrt
;
;	Compute the Square Root.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _dsSqrt, PUBLIC

		fld		_fInX			; move data onto the FPU stack (32b?)
		fsqrt					; square root
		fstp		_fOut	

        ret

EndProc _dsSqrt



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_dsACos
;
;	Compute ArcCos.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _dsACos, PUBLIC
		

		fld		_fInX			; move data onto the FPU stack (32b?)
		; if it is 0, return pi/2
		ftst
		fstsw	ax					; status word in ax
		sahf					; move ah into flags
		jnz		notzero
		fstp	ST(1)		; just for popping
		fldpi
		fdiv	wTwo
		jmp		acosExit
notzero:
		fmul	ST, ST		; x2
		fld1
		fsubrp	ST(1), ST	; 1-x2	

		fsqrt				; V(1-x2)

		fld		_fInX		; x

		fpatan				; atan(sqrt(1-x2)/x))=acos(x)
acosExit:
		fstp		_fOut	

		ret

EndProc _dsACos


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;	_SetConfig
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BeginProc _SetConfig, PUBLIC
	wBaseMpu		equ     [ebp + 8]
	Device			equ		[ebp+12]
	Config			equ		[ebp+16]

	    push    ebp
        mov     ebp, esp

		mov		dx, wBaseMpu
		mov		al, Device
		inc		dx
		out		dx, al
		dec		dx
		mov		al, Config

		cli
		out		dx, al
		
		; Wait for answer
		mov		ecx, 0100000h
		inc		dx				; status port
WaitConfig:
		in		al, dx	
		test	al, 80h
		jnz		WaitConfig	
		
		cmp		ecx, 0
		jz		scExitError

		; Read answer
		dec		dx
		in		al, dx

		; Let's go in uart mode
		inc		dx
		mov		al, 3fh
		out		dx, al
		 
		 ; Wait for acknowledge
		mov		ecx, 0100000h
WaitUart:
		in		al, dx	
		test	al, 80h
		jnz		WaitUart	
		
		cmp		ecx, 0
		jz		scExitError
		
		; read answer
		dec		dx
		in		al, dx
scExitSuccess:
		mov		eax, 1
		sti
        pop     ebp
        ret

scExitError:

		mov		eax, 0
		sti
        pop     ebp
        ret


EndProc _SetConfig

VxD_PAGEABLE_CODE_ENDS

end
