//
//
//
//
#define  WANTVXDWRAPS

#include <windows.h>
#include "vmm.h"
#include <vmmreg.h>
#include <vxdldr.h>
#include <vxdwraps.h>

#include <configmg.h>
#include <dsound.h>
#include "dsdriver.h"
#include <debug.h>

#include <stdio.h>
#include "dsnd.h"
#include "Dos_xfer.h"
#include "Dream3_D.h"

#include <string.h>


extern WORD gwBaseMPU401;		// Base Address 9407

extern char FirmName[256];
extern char SoundName[256];



/***************************************************************************************
*
*  BOOL ResetMemory()
*	
*	reset all the memory card. Delete every sound banks, wave buffers...
*   
*	Return FALSE if failed 
* 
*	Call :    	GetMemoryMapping
*               DownLoad
*
*****************************************************************************************/    
BOOL ResetMemory()
{                          
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8];
WORD n;

	//Get Memory Mapping from card 

	if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
		return FALSE;     
	
	// find the number of the bank to delete
	n=0;
	while (n<8)
	{
		if (SndBkDef[n].Nam[0]!=0)
			DelSoundBank(n);
		n++;
	}

	return TRUE;

}



/***************************************************************************************
*
*  BOOL RestoreMidi()
*	
*	restore sound bank and config (reverb, chorus,...)
*   
*	Return FALSE if failed 
*
*****************************************************************************************/    
BOOL RestoreMidi()
{       
	/*if (vxdLoadFW((DWORD) FirmName,0))
		return FALSE;*/

	// Remove slots
	SetConfig(gwBaseMPU401, C_REVERB,C_ON);
	SetConfig(gwBaseMPU401, C_CHORUS,C_ON);
	SetConfig(gwBaseMPU401, C_EQUA,0);
	SetConfig(gwBaseMPU401, C_ECHO,C_ON);		// go in uart;
	SetConfig(gwBaseMPU401, C_SURROUND,C_ON);		// go in uart

	// restart the wave 0
		RestartDSWave();

	vxdLoadSB((DWORD) SoundName,0);
	return TRUE;		// ok
}


/***************************************************************************************
*
*  BOOL DeleteSoundBank(char *BankName)
*	
*   
*	Return FALSE if failed 
*
*****************************************************************************************/    
BOOL DeleteSoundBank(char *BankName)
{                          
	MemBlDefTyp MemoryBlock[64];
	SndBkDefTyp SndBkDef[8];
	WORD n=0;
	BOOL Found=FALSE;

	//Get Memory Mapping from card 
	if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
		return FALSE;     
	
	// find the number of the bank to delete
	while ((n<8) && (!Found))
	{
		SndBkDef[n].Nam[9]=0;
		if (strcmp(SndBkDef[n].Nam,BankName)==0)
			Found=TRUE;
		n++;
	}

	if (!Found)
	{
		Trace_Out("Bank not found!!");
		return FALSE;
	}

	if (DelSoundBank(n-1))
		return FALSE;

	return TRUE;
}


//
//
//
//
//
BOOL RestartDSWave()
{
	__asm
	{
		mov	dx, gwBaseMPU401
		inc	dx				; command	(W_OPEN)
		mov	al, 0x40 
		out	dx, al
		dec	dx				; param
		mov	al, 00 
		out	dx, al
		mov	al, 01
		out	dx, al
		mov	al, 0x11 
		out	dx, al
		mov	al, 0x2b
		out	dx, al

	}

	return TRUE;

}


