/*
 *        DDDDDD          RRRRRR         EEEEEE         AAA            MM     M
 *       D     D         R     R        E             A    A          M M  M  M
 *      D     D         RRRRRR         EEEEEE        AAAAAAA         M   M   M
 *     D     D         R   R          E             A     A         M       M
 *    DDDDDD          R     R        EEEEEE        A     A         M       M
 *
 *  Digital         Research  in  Electronics    Acoustics        &     Music
 *______________________________________________________________________________
 *
 * SAM9407-9503 based product
 *-------------------------------------------
 * COPYRIGHT (c) DREAM S.A. 1993-1996
 *-------------------------------------------                              
 ***************************************************************************/

	// MODIF NO LIMIT 08-98
	// Data for chunk SIZE
	#define IN_PAGE_SAMPLE	0		// There are only in Page Samples
	#define LARGE_SAMPLE	1		// There are only Cross Page Samples
	#define MIXTYPE_SAMPLE	2		// There are Cross Page Samples and In Page Samples
	
	
typedef struct sRellocTyp {
	long pointer;
	char type;
	char bank;
	} RellocTyp;
	 
struct multyp {
		char name[13];
		int position;
		int page;
		};
// Structures assign : memorise assignement for making instrument mapping table 
typedef struct sAssigne{        // structure to memorize assignement for Instrument and drumset
		unsigned char mprog;
		unsigned char mbank;
		unsigned char page;
		WORD pointer;
		} assigne; 

#define DSR           0x80       // data set ready 0 = ready
#define DRR           0x40      // data receive ready 0 = ready
#define GET_MMT		3			// Get Memory mapping table address   
#define SET_MMT		4			// Set Memory mapping table address 
#define GEN_INT		0x48			// Set Memory mapping table address 
#define HOT_RESET	0x70			// Read memory command  
#define UART_MOD	0x3f
#define ACQ_DMA		0xac		// 
#define WRT_MEM		1			// Write memory command 
#define READ_MEM	2			// Read memory command
#define DMA_REG		2			// dma register
#define MemBlockSize	3*64         // size of memory block definition
#define MemSBSize		40            // size of Sound Bank definition
#define MidiMapExtSize  512       // Midi Mapping extension size

typedef struct sMemBlDefTyp {
	WORD Type;
	long Address;
	} MemBlDefTyp;
	
typedef struct sSndBkDefTyp { 
	BYTE Nam[8];
	WORD Prio;
	} SndBkDefTyp;
		
typedef struct sMemBlockTyp {
	long 	Address;
	long	Size;
	BOOL	FillBefStart;
	BOOL	FillAftStop;
	} MemBlockTyp;     
	
typedef struct sNewBloc {
	long 	Address;       // address in card memory
	long	PosInSndBk; 
	long	Size;          //in bytes
	WORD	Type;          
	} NewBloc; 

typedef int (*compfn)(const void*,const void*);
									

// functions prototypes

// vxd API
int vxdAlloc(long vSize, WORD vType,long *vAddress);
int vxdFree(long);
int vxdLoadSB(DWORD SbName, WORD NameO7);

void InitCrystal(WORD wBaseMPU401,WORD wIRQ);
void TempoInit(WORD wBaseMPU401);
BOOL GetMemoryMapping(WORD wBaseMpu,MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[]);
DWORD  GetMemMapAddress(WORD wBaseMpu);
WORD  UpLoad(WORD wBaseMpu,void * lpDst,WORD wSrcPage,WORD wSrcOffset,WORD wCount);
WORD  DownLoad(WORD wBaseMpu,void * lpSrc,WORD wDestPage,WORD wDestOffset,WORD wCount);
BOOL MemCopyDst(WORD wBaseMpu,WORD PageSrc, WORD OffSrc, void *lpDst,WORD wCount);
BOOL MemCopySrc(WORD wBaseMpu,WORD PageDst, WORD OffDst, void *lpSrc,WORD wCount);
int memorAlloc(MemBlDefTyp MemoryBlock[],long vSize, WORD vType,long *vAddress);  
int memorFree(MemBlDefTyp MemoryBlock[],long Address);
MemBlockTyp *AddBlock(MemBlockTyp *MemMap,long Address, long Size,long StartBigBlock,long StopBigBlock);

MemBlockTyp* CreateMiniBlockMapping(MemBlDefTyp MemoryBlock[], MemBlockTyp *MemMap);
BOOL PutNewBlockInMemory(NewBloc *BlockToAdd,MemBlockTyp* MemMap);
BOOL PutSoundBank(NewBloc *BinToAdd, DWORD BinFile,DWORD PcmAlloc[],DWORD ParAlloc[],
		MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[],int SndBkNb) ;
BOOL UpdateMemBlock(MemBlDefTyp MemoryBlock[],NewBloc ToAdd);
void DeleteMBlock(int pos,MemBlDefTyp MemoryBlock[]);
BOOL InsertMBlock(int pos,NewBloc ToAdd,MemBlDefTyp MemoryBlock[]);
void smbSort(MemBlockTyp *Tab, int Nb);
BOOL SendNewSoundBank(DWORD BinFile, WORD wBaseMPU);
int LoadRelloc(RellocTyp RLocBuf[],long *InRelloc,long *LocLength,DWORD stream);
BOOL AddAssign(assigne Tab[],assigne BkUpTab[],BYTE MidiPr,BYTE var,WORD Pointer,WORD offset,
					BYTE SndBknb,SndBkDefTyp SndBkDef[],WORD prio,int *nTab,int *nTabBk);
BOOL CreateInsMap(WORD *MidiMapping,assigne InstTab[],assigne InstBkUpTab[],assigne DrumTab[],
			assigne DrumBkUpTab[],int nInst,int nInstBk,int nDrm,int nDrmBk,WORD);
BOOL DoRellocation(NewBloc Cur,WORD *buffer,long lenpar,DWORD PcmAlloc[],
		DWORD BinFile,WORD st_address);  
BOOL SplitInsMap(WORD MidiMapping[],WORD MidiMapAdd,assigne InsTab[],assigne InstBkUpTab[],
			assigne DrumTab[],assigne DrumBkUpTab[],int *nInst,int *nInstBk, int *nDrm, 
			int *nDrmBk);
long ReallocMemoryMap(MemBlDefTyp MemoryBlock[],long MidiMapSize);
long GetChunkPos(DWORD stream,const char ChunkName[],BOOL ErrMsg);
void saSort(assigne *Tab, int Nb);  
WORD SetMemMapAddress(DWORD address, WORD wBaseMPU401);
int mstrcmp(char *str1,char *str2);

void registryDebug(CHAR cType[], CHAR cMes[]);
void loadBoot(WORD wBaseMPU401);
BOOL soundbankMMT(WORD wBaseMPU401);
BOOL LoadFirmware(DWORD hFirm, WORD wBaseMPU401);
BOOL switchUART(WORD wBaseMPU401);
BOOL genINT(WORD wBaseMPU401);
BOOL ressource(DEVNODE dn,WORD *wBaseMPU401,WORD *wIRQ);
void registryRead();
void TimeDebug();
BOOL MemWrFmt(WORD wBaseMpu,DWORD BoardAddress, void * lpSrc,WORD SizeBuff, 
			  BOOL Stereo, BOOL s8Bits, DWORD BoardAddress2);
int vxdLoadSB(DWORD SbName,WORD NameOffset);
WORD DelSoundBank(WORD SoundBkNb);
int vxdLoadFW(DWORD FwName,WORD NameOffset);




	