//---------------------------------------------------------------------------
//
//   MIXER.H
//
//---------------------------------------------------------------------------
/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (c) 1993 - 1995  Microsoft Corporation.  All Rights Reserved.
 *
 **************************************************************************/
#include <mmsystem.h>

//
//
//
//
#ifndef FIELD_OFFSET
    #define FIELD_OFFSET(type, field)    ((LONG)&(((type *)0)->field))
#endif

//***************************************************************************
//***************************************************************************

    #define MAXSOURCES      5
    #define MAXDESTINATIONS 2
    #define MAXCONTROLS     11

typedef struct tagMXDCLIENT NEAR *PMXDCLIENT ;

typedef struct tagMIXERINSTANCE
{
     PMXDCLIENT        pMxdClients ;

     MIXERLINE         mxlSources[ MAXSOURCES ] ;
     MIXERLINE         mxlDests[ MAXDESTINATIONS ] ;
     MIXERCONTROL      mxc[ MAXCONTROLS ] ;

     //
     // control mapping
     //
     // The control map describes the controls, their
     // # of channels and locations.
     //

     UINT              auControlMap[ MAXCONTROLS ][ 3 ] ;

     //
     // source mapping
     //
     // The source map describes the connections for each
     // destination.  This maps a relative source number at a
     // destination to an actual source number in the mixer
     // source list.
     //

     UINT              auSourceMap[ MAXDESTINATIONS ][ MAXSOURCES ] ;

     //
     // source controls maps
     //
     // This array describes the number of controls for a given
     // source at a destination.
     //

     UINT              auSourceControlsMap[ MAXDESTINATIONS ][ MAXSOURCES ] ;

     //
     // active/disconnect map
     //
     // This array describes the connection status for a given
     // source at a destination.  This allows a source to become
     // disconnected or active dynamically.
     //      

     DWORD             adwActiveMap[ MAXDESTINATIONS ][ MAXSOURCES ] ;

     //
     // Control value storage arrays...
     //

     union
     {
       DWORD           dwValue[ MAXCONTROLS ][ 2 ] ;
       LONG            lValue[ MAXCONTROLS ][ 2 ] ;
     };

} MIXERINSTANCE, FAR *PMIXERINSTANCE ;

typedef struct tagMXDCLIENT
{
    DWORD              fdwOpen ; 
    HMIXER             hmx ;           // handle that will be used
    DWORD              dwCallback ;    // callback
    UINT               fuCallback ;    // callback
    DWORD              dwInstance ;    // app's private instance information
    PHARDWAREINSTANCE  phwi ;
    PMXDCLIENT         pNext ;         // for list of clients

} MXDCLIENT ;

// driver internal defintion for line mute status

#define IMIXERLINE_LINEF_MUTED   0x08000000L

typedef MMRESULT FAR PASCAL CONTROLFUNCTION( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
extern CONTROLFUNCTION* BCODE ControlFunctionTable[ MAXCONTROLS ] ;

extern UINT BCODE         gauControlMap[ MAXCONTROLS ][ 3 ] ;
extern UINT BCODE         gauSourceMap[ MAXDESTINATIONS ][ MAXSOURCES ] ;
extern UINT BCODE         gauSourceControlsMap[ MAXDESTINATIONS ][ MAXSOURCES ] ; 
extern MIXERLINE BCODE    gmxlSources[ MAXSOURCES ] ;
extern MIXERLINE BCODE    gmxlDests[ MAXDESTINATIONS ] ;
extern MIXERCONTROL BCODE gmxc[ MAXCONTROLS ] ;


//***************************************************************************
//***************************************************************************
//***************************************************************************

//Mixer.c

MMRESULT FAR PASCAL MxdInit( PHARDWAREINSTANCE ) ;
VOID FAR PASCAL MxdEnd( PHARDWAREINSTANCE ) ;
MMRESULT FAR PASCAL MxdGetControlDetails( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS, DWORD ) ;
MMRESULT FAR PASCAL MxdSetControlDetails( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS, DWORD ) ;

VOID FAR PASCAL MxdUpdateLine( PHARDWAREINSTANCE, UINT, UINT, BOOL, UINT ) ;

#define MXDUPDATELINE_ACTIONF_LINESTATUS  0x0000
#define MXDUPDATELINE_ACTIONF_MUTESTATUS  0x0001

#define MXDUPDATELINE_ACTIONF_DESTINATION 0x0000
#define MXDUPDATELINE_ACTIONF_SOURCE      0x0010


/* Controls.C */

MMRESULT FAR PASCAL MixSetMasterVolume( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
MMRESULT FAR PASCAL MixSetMidiVolume( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
MMRESULT FAR PASCAL MixSetVolume( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
#ifdef AZTECH
MMRESULT FAR PASCAL MixSetMonoVolume( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
#endif
MMRESULT FAR PASCAL MixSetMute( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;
MMRESULT FAR PASCAL MixSetADCHardware
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
) ;

MMRESULT FAR PASCAL MixSetFails( PHARDWAREINSTANCE, LPMIXERCONTROLDETAILS ) ;

MMRESULT     PASCAL MixUpdateGlobalLevels( PHARDWAREINSTANCE ) ;

/* removed by r-y to avoid re definition
#ifdef DEBUG
 #define AssertT(x) {  if(!(x)) {DPF( 1, "AssertT failed (" __FILE__ "):\r\n  "#x "\r\n"); DebugBreak();};};
 #define AssertF(x) {  if(!(x)) {DPF( 1, "AssertF failed (" __FILE__ "):\r\n  "#x "\r\n"); DebugBreak();};};
#else
 #define AssertT(x)
 #define AssertF(x)
#endif
*/

//***************************************************************************
//***************************************************************************
// Defines for the uControlMap "columns"
#define CM_CHANNELS 2

//***************************************************************************
//***************************************************************************
// Define some stuff for the muxes
// NOTE: These are NOT the physical settings for the chip, they will get
//       translated to that later.
    #define MUXINPUT_AUX1       0
    #define MUXINPUT_MIX        1

//***************************************************************************
//***************************************************************************
// Define some stuff for sources...
    #define SOURCE_AUX1     0
    #define SOURCE_WAVEOUT  1
    #define SOURCE_MIDIOUT  2
    #define SOURCE_MIX      3
    #define SOURCE_AUDIO    4
    #define SOURCE_INVALID           (UINT_MAX)   /// for source mapping

//***************************************************************************
//***************************************************************************
// Define some stuff for destinations...
#define DEST_LINEOUT      0
#define DEST_WAVEIN       1

//***************************************************************************
//***************************************************************************
// Define some stuff for controls...

//
//Define Control numbers
//
    #define MUX_WAVEIN                0
    
    #define VOL_OUTAUX1               1
    #define VOL_OUTDAC                2
    #define VOL_OUTMIDI               3
    #define VOL_OUTLINE               4
    #define VOL_W_INAUX1              5
    #define VOL_W_INMIX               6
    
    #define MUTE_OUTAUX1              7
    #define MUTE_OUTDAC               8
    #define MUTE_OUTMIDI              9
    #define MUTE_OUTLINE             10
    

#define CONTROL_ATDEST           (UINT_MAX)
BOOL bRecVol; //shows if record vol control is implemented 
//( otherwise Record volume will be controlled thrue Aux vol and Main Vol )

