//---------------------------------------------------------------------------
//
//  Module: controls.c
//
//  Purpose: Mixer control interface for SNDSYS.DRV
//
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
// PURPOSE.
//
// Copyright (c) 1991 - 1995  Microsoft Corporation.  All Rights Reserved.
//
//---------------------------------------------------------------------------

#include <windows.h>

// stop compiler from griping about in-line

#pragma warning (disable:4704)

#define Not_VxD
#include <vmm.h>
#include <configmg.h>

#include <mmsystem.h>
#include <mmddk.h>
#include <mmreg.h>
#include <ctype.h>
#include "mixstrng.h"
#include "dream94.h"
#include "dream.h"
//#include "mixer.h" //already included in dream94.h

#define SILENCE                 (192)

extern gwPort;		//inita.asm

BYTE GetMidiVol(unsigned int left,unsigned int right);
BYTE GetMidiPan(unsigned int left,unsigned int right);
MMRESULT FAR PASCAL MixSetLineRecVol(PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd);
MMRESULT FAR PASCAL MixSetMixRecVol(PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd);

//***********

//
// The following table of functions determines what functions will get
// called to set the hardware setting for that control.
//


CONTROLFUNCTION* BCODE ControlFunctionTable[MAXCONTROLS] = 
{
   MixSetADCHardware,  // Control  0
   MixSetVolume,       // Control  1
   MixSetVolume,       // Control  2
   MixSetMidiVolume,   // Control  3
   MixSetMasterVolume, // Control  4
   MixSetLineRecVol,   // Control  5
   MixSetMixRecVol,    // Control  6
   MixSetMute,         // Control  7
   MixSetMute,         // Control  8
   MixSetMute,         // Control  9
   MixSetMute,         // Control 10
} ;

//------------------------------------------------------------------------
//  MMRESULT MixSetMidiVolume
//
//  Description:
//     Sets the midi output device volume.
//
//  Parameters:
//     PMIXERHARDWAREINSTANCE phwi
//        pointer to hardware instance
//
//     LPMIXERCONTROLDETAILS pmcd
//        pointer to mixer control details structure
//
//  Return Value:
//     MMRESULT
//        MMSYSERR_NOERROR if everything A-OK.
//
//
//------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetMidiVolume
(
    PHARDWAREINSTANCE       phwi, 
    LPMIXERCONTROLDETAILS   pmcd
)
{
   WORD            wLeftVol, wRightVol;
   PMIXERINSTANCE  pmi;
   BYTE MidiVol,MidiPan;
   char szDebug[ 80 ] ;
   DPF( 1, "MixSetMidiVolume" ) ;
      pmi = phwi -> pmi ;

      wLeftVol = (WORD) pmi -> dwValue[ VOL_OUTMIDI ][ 0 ] ;
      wRightVol = (WORD) pmi -> dwValue[ VOL_OUTMIDI ][ 1 ] ;

      //
      // If the master mute or the midi mute is set, mute
      // the line.
      //

      if ((pmi -> dwValue[ MUTE_OUTMIDI ][ 0 ]) ||
         (pmi -> dwValue[ MUTE_OUTLINE ][ 0 ]))
      {
         wLeftVol = 0 ;
         wRightVol = 0 ;
      }

      MidiVol=GetMidiVol(wLeftVol,wRightVol);
         wsprintf( szDebug, "MidiVol = %d", MidiVol);
         DPF( 1, szDebug ) ;
//      SendCommand(GM_VOL,0,COM_OFFSET);
//      SendParam(MidiVol,1,COM_OFFSET);
	mpuMessage(GM_VOL,&MidiVol,1);
      MidiPan=GetMidiPan(wLeftVol,wRightVol);
      if(MidiPan!=255)
        {
        //SendCommand(GM_PAN,0,COM_OFFSET);
        //SendParam(MidiPan,1,COM_OFFSET);
	mpuMessage(GM_PAN,&MidiPan,1);
         wsprintf( szDebug, "MidiPan = %d", MidiPan);
         DPF( 1, szDebug ) ;
        }
      else
      	{
      	DPF( 1, "no pan change" ) ;
      	}

   return ( MMSYSERR_NOERROR ) ;

} // end of MixSetMidiVolume()

//------------------------------------------------------------------------
//  MMRESULT MixSetVolume
//
//  Description:
//     Sets the volume for a control.
//
//  Parameters:
//     PMIXERHARDWAREINSTANCE phwi
//        pointer to hardware instance
//
//     LPMIXERCONTROLDETAILS pmcd
//        pointer to mixer control detailss structure
//
//  Return Value:
//     Nothing.
//
//
//------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetVolume
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
   BYTE            bLeftVol, bRightVol ;
   unsigned int wLeftVol,wRightVol;
   DWORD           dwControlID, dwMuteControlID ;
   PMIXERINSTANCE  pmi;
   int i;

   DPF( 1, "MixSetVolume" ) ;

   pmi = phwi -> pmi ;
   dwControlID = pmcd -> dwControlID ;
   dwMuteControlID = (dwControlID - VOL_OUTAUX1) + MUTE_OUTAUX1 ;


wLeftVol=  (WORD) pmi -> dwValue[ dwControlID ][ 0 ] ;
wRightVol= (WORD) pmi -> dwValue[ dwControlID ][ 1 ] ;

   //    mute is on, mute it.
   //

   if ((pmi -> dwValue[ dwMuteControlID ][ 0 ]) ||
       (pmi -> dwValue[ MUTE_OUTLINE ][ 0 ]))
   {
   wLeftVol= 0;
   wRightVol= 0;
   }

   //
   // Note that we perform this compare after setting the mute
   // bit and will reset the mute - the number of cycles wasted
   // vs. the compare of special casing the 0x80 is a wash.
   //

   switch (dwControlID)
   {
      case VOL_OUTAUX1:
         wLeftVol=(wLeftVol>>8)& 0x00ff;
         bLeftVol=(BYTE)wLeftVol;

         wRightVol=(wRightVol>>8)& 0x00ff;
         bRightVol=(BYTE)wRightVol;
D(
   char szDebug[ 80 ] ;

   wsprintf( szDebug, "LineIn L = %d, R = %d",bLeftVol,bRightVol);
   DPF( 1, szDebug ) ;
)
         
         //SendCommand(AUDL_VOL,0,COM_OFFSET);
         //SendParam(bLeftVol,1,COM_OFFSET);

         //SendCommand(AUDR_VOL,0,COM_OFFSET);
         //SendParam(bRightVol,1,COM_OFFSET);
	mpuMessage(AUDL_VOL,&bLeftVol,1);
	mpuMessage(AUDR_VOL,&bRightVol,1);

         break ;

      case VOL_OUTDAC:
D(
   char szDebug[ 80 ] ;

   wsprintf( szDebug, "WaveVol L= %d, R = %d",wLeftVol,wRightVol);
   DPF( 1, szDebug ) ;
)

	DirectSoundVolumeCheck(wLeftVol/2+wRightVol/2, gwPort);	
	for(i=0;i<8;i++)
	{
	waveSetMainVolume(i,wLeftVol,wRightVol);
	//SetAuxVolume(i,wLeftVol,wRightVol);
	}
   }

   return ( MMSYSERR_NOERROR ) ;

} // end of MixSetVolume()


//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetADCHardware
//  
//  Description:
//      Sets the ADC hardware...
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//         pointer to control details
//
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetADCHardware
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
   BYTE             bRecMode;
   BYTE             bSource;
   WORD             wLeftVol, wRightVol;
   BYTE             bLeftVol,bRightVol;
   BYTE             bMainVol;
   PMIXERINSTANCE   pmi ;
   char szDebug[ 80 ] ;

   DPF( 1, "MixSetADCHardware" ) ;
   // Determine if we should be changing the hardware
   pmi = phwi -> pmi ;

bSource=(BYTE)pmi->dwValue[MUX_WAVEIN][0];
if(bSource==0)
{
//wsprintf(szDebug,"MuxIn= %d \r\n",bSource);
//OutputDebugStr(szDebug);
bRecMode=0;
phwi->wRecordSource=0;
        wLeftVol = (WORD) pmi -> dwValue[ VOL_W_INAUX1 ][ 0 ] ;
        wLeftVol=(wLeftVol>>8)&0x00ff;
        bLeftVol=(BYTE)wLeftVol;
        if(bRecVol)
	   mpuMessage(RECVOL,&bLeftVol,1);
	else
	  {
	  mpuMessage(AUDL_VOL,&bLeftVol,1);
	  mpuMessage(AUDR_VOL,&bLeftVol,1);
	  }
}
else
{
//wsprintf(szDebug,"muxIn= %d \r\n",bSource);
//OutputDebugStr(szDebug);
bRecMode=0x7f;
phwi->wRecordSource=0x7f;
        wLeftVol = (WORD) pmi -> dwValue[ VOL_W_INMIX ][ 0 ] ;
        wLeftVol=(wLeftVol>>8)&0x00ff;
        bMainVol=(BYTE)wLeftVol;
        if(bRecVol)
           mpuMessage(RECVOL,&bMainVol,1);
        else
           mpuMessage(MAINVOL,&bMainVol,1);
}
mpuMessage(REC_MODE,&bRecMode,1);
   return(MMSYSERR_NOERROR );

} // MixSetADCHardware()
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetMasterVolume
//  
//  Description:
//      Sets the master volume
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//         pointer to control details
//  
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetMasterVolume
(   
    PHARDWAREINSTANCE       phwi, 
    LPMIXERCONTROLDETAILS   pmcd
)
{
   WORD            wLeftVol, wRightVol;
   PMIXERINSTANCE  pmi;
   BYTE bMainVol;

   DPF( 1, "MixSetMasterVolume" ) ;

      pmi = phwi -> pmi ;

      wLeftVol = (WORD) pmi -> dwValue[ VOL_OUTLINE ][ 0 ] ;

      //
      // If the master mute or the midi mute is set, mute
      // the line.
      //

      if (pmi -> dwValue[ MUTE_OUTLINE ][ 0 ])
      {
         wLeftVol = 0 ;
      }
//SendCommand(MAINVOL,0,COM_OFFSET); 
//SendParam((BYTE) wLeftVol,0,COM_OFFSET);
        wLeftVol=(wLeftVol>>8)&0x00ff;
        bMainVol=(BYTE)wLeftVol;
D(
   char szDebug[ 80 ] ;

   wsprintf( szDebug, "MainVol = %d",bMainVol);
   DPF( 1, szDebug ) ;
)

	mpuMessage(MAINVOL,&bMainVol,1);

   return MMSYSERR_NOERROR ;

} // MixSetMasterVolume()

//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetMute
//  
//  Description:
//      Turns the mute on and off
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//         pointer to control details
//
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetMute
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
   DWORD           dwControlID ;
   PMIXERINSTANCE  pmi ;

   pmi = phwi -> pmi ;
   dwControlID = pmcd -> dwControlID ;

   //
   // The value in the dwValue field has already been updated.
   // Nothing to do now, but update all the actual levels.
   //

   switch (pmcd -> dwControlID)
   {
      case MUTE_OUTLINE:
         MxdUpdateLine( phwi, 
                        DEST_LINEOUT, (UINT) -1,
                        (BOOL) pmi -> dwValue[ dwControlID ][ 0 ],
                        MXDUPDATELINE_ACTIONF_MUTESTATUS |
                           MXDUPDATELINE_ACTIONF_DESTINATION ) ;
         break ;

      default:
      {
         DWORD  dwRelSource ;

         // NOTE!  Mute controls map 1:1 to relative sources on
         // the DEST_LINEOUT destination...

         dwRelSource = pmcd -> dwControlID - MUTE_OUTAUX1 ;
         MxdUpdateLine( phwi,
                        DEST_LINEOUT,
                        pmi -> auSourceMap[ DEST_LINEOUT ][ dwRelSource ],
                        (BOOL) pmi -> dwValue[ dwControlID ][ 0 ],
                        MXDUPDATELINE_ACTIONF_MUTESTATUS |
                           MXDUPDATELINE_ACTIONF_SOURCE ) ;
      }
   }

   MixUpdateGlobalLevels( phwi ) ;

   return MMSYSERR_NOERROR ;

} // MixSetMute()

//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetFails
//  
//  Description:
//      Fails the {set/get} control details.
//  
//  Parameters:
//      PHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//  
//  Return (MMRESULT):
//      MIXERR_INVALCONTROL
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetFails
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
 //
 // This routine is called when a caller attempted to set something that
 // cannot/should not be set (VUMeter, etc.)
 //
 return MIXERR_INVALCONTROL ;

} // MixSetFails()

//--------------------------------------------------------------------------
//  
//  MMRESULT MixUpdateGlobalLevels
//  
//  Description:
//      Updates all controls.
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT PASCAL MixUpdateGlobalLevels
(
    PHARDWAREINSTANCE   phwi
)
{    
   MMRESULT                      Result ;
   MMRESULT                      Return = MMSYSERR_NOERROR ;
   MIXERCONTROLDETAILS           mcd ;
   MIXERCONTROLDETAILS_UNSIGNED  mcd_u[ 2 ] ;
   PMIXERINSTANCE                pmi ;

   pmi = phwi -> pmi ;

   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.paDetails = &mcd_u ;
   mcd.cbDetails = sizeof( MIXERCONTROLDETAILS_SIGNED ) ;
    
   //
   // Adjust MIDI out volume.
   //

      mcd.dwControlID = VOL_OUTMIDI ;
      mcd.cChannels = pmi -> auControlMap[ VOL_OUTMIDI ][ CM_CHANNELS ] ;
      mcd.cMultipleItems = 0 ;
      mcd_u[ 0 ].dwValue =
         pmi -> dwValue[ VOL_OUTMIDI ][ 0 ] ;
      mcd_u[ 1 ].dwValue =
         pmi -> dwValue[ VOL_OUTMIDI ][ 1 ] ;

      Result = MixSetMidiVolume( phwi, &mcd ) ;
      if ( Result != MMSYSERR_NOERROR )
         Return = Result;

   //
   // Adjust AUX1 volume.
   //

   mcd.dwControlID = VOL_OUTAUX1 ;
   mcd.cChannels = pmi -> auControlMap[ VOL_OUTAUX1 ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0 ;
   mcd_u[ 0 ].dwValue =
      pmi -> dwValue[ VOL_OUTAUX1 ][ 0 ] ;
   mcd_u[ 1 ].dwValue =
      pmi -> dwValue[ VOL_OUTAUX1 ][ 1 ] ;

   Result = MixSetVolume( phwi, &mcd ) ;

   if ( Result != MMSYSERR_NOERROR )
      Return = Result ;

   //
   // Adjust DAC volume.
   //

   mcd.dwControlID = VOL_OUTDAC ;
   mcd.cChannels = pmi -> auControlMap[ VOL_OUTDAC ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd_u[ 0 ].dwValue =
      pmi -> dwValue[ VOL_OUTDAC ][ 0 ] ;
   mcd_u[ 1 ].dwValue =
      pmi -> dwValue[ VOL_OUTDAC ][ 1 ] ;

   Result = MixSetVolume( phwi, &mcd ) ;

   if ( Result != MMSYSERR_NOERROR )
      Return = Result;


   return Return;

} // MixUpdateGlobalLevels()

//**************************************
BYTE GetMidiVol(unsigned int left,unsigned int right)
{
unsigned int vol,mvol;
vol=max(left,right);
mvol=(vol>>8)&0x00ff;
return((BYTE)mvol);
}
//*********************************************
BYTE GetMidiPan(unsigned int left,unsigned int right)
{
double pan;
if(right-left!=0)
	pan=(double)63-(double)63*(((double)left-(double)right)/(double)max(right,left)) + (double)0.5;
else
{
	if(right==0)
		pan=255;
	else
		pan=63;
}
	
return((BYTE)pan);
}
//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetLineRecVol
//  
//  Description:
//      Sets the ADC hardware...
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//         pointer to control details
//
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetLineRecVol
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
   WORD            wLeftVol, wRightVol;
   PMIXERINSTANCE  pmi;
   BYTE bLeftVol,bRightVol;

   DPF( 1, "MixSetLineRecVol" ) ;
      pmi = phwi -> pmi ;
if(phwi->wRecordSource==0x7f)
{
//OutputDebugStr("Line is not active for Record \r\n");

   return(MMSYSERR_NOERROR );
}
      wLeftVol = (WORD) pmi -> dwValue[ VOL_W_INAUX1 ][ 0 ] ;

        wLeftVol=(wLeftVol>>8)&0x00ff;
        bLeftVol=(BYTE)wLeftVol;
D(
   char szDebug[ 80 ] ;

   wsprintf( szDebug, "LineInRecVol = %d ,%d",bLeftVol,bRightVol);
   DPF( 1, szDebug ) ;
)

        if(bRecVol)
	   mpuMessage(RECVOL,&bLeftVol,1);
	else
	  {
	  mpuMessage(AUDL_VOL,&bLeftVol,1);
	  mpuMessage(AUDR_VOL,&bLeftVol,1);
	  }

   return(MMSYSERR_NOERROR );
} //MixSetLineRecVol
//--------------------------------------------------------------------------
//  
//  MMRESULT MixSetMixRecVol
//  
//  Description:
//      Sets the ADC hardware...
//  
//  Parameters:
//      PMIXERHARDWAREINSTANCE phwi
//         pointer to hardware instance
//
//      LPMIXERCONTROLDETAILS pmcd
//         pointer to control details
//
//  Return (MMRESULT):
//      MMSYSERR_NOERROR if no problem
//  
//  
//--------------------------------------------------------------------------

MMRESULT FAR PASCAL MixSetMixRecVol
(
    PHARDWAREINSTANCE       phwi,
    LPMIXERCONTROLDETAILS   pmcd
)
{
   WORD            wLeftVol, wRightVol;
   PMIXERINSTANCE  pmi;
   BYTE bMainVol;

   DPF( 1, "MixSetMixRecVol" ) ;
      pmi = phwi -> pmi ;
if(phwi->wRecordSource==0)
{
//OutputDebugStr("Mix is not active for Record \r\n");

   return(MMSYSERR_NOERROR );
}

      wLeftVol = (WORD) pmi -> dwValue[ VOL_W_INMIX ][ 0 ] ;

        wLeftVol=(wLeftVol>>8)&0x00ff;
        bMainVol=(BYTE)wLeftVol;
D(
   char szDebug[ 80 ] ;

   wsprintf( szDebug, "MixRecVol = %d",bMainVol);
   DPF( 1, szDebug ) ;
)
        if(bRecVol)
           mpuMessage(RECVOL,&bMainVol,1);
        else
           mpuMessage(MAINVOL,&bMainVol,1);
return(MMSYSERR_NOERROR );
} //MixSetMixRecVol



//---------------------------------------------------------------------------
//  End of File: controls.c
//---------------------------------------------------------------------------
