#ifndef  TARGETAVR_H
#define  TARGETAVR_H


/*
 *  History
 *
 *  Version 0.1
 *  Baseline release.  (Hooray!)
 *
 *  Version 0.2   (01 Sep 2008  KEL)
 *  Added support for either ATmega1284P or AT90CAN128, selected by
 *  the project's configuration option.  The 'can128 uses a 16 MHz
 *  crystal (on a Leviton RevA keypad), while the 'mega1284p uses
 *  a 20 MHz crystal on a custom board.
 *
 *  Version 0.3   (01 Sep 2008  KEL)
 *  Added support for ports E, F, and G for 'can128 MCU.
 *
 *  Version 0.4   (22 Sep 2008  KEL)
 *  Extensive additions, including support for flash files 0-2,
 *  autostart from EE or FL0-FL2, single-dimension arrays.  I
 *  posted version 0.3 to the AVR Freaks website, but it had
 *  all of the above changes in it already.  I need to get more
 *  disciplined about my version comments and sequencing.
 *
 *  Fixed error in warning message in ceload(); was EEPROM, now
 *  RAM.  Added I/O ports for SPI.
 *
 *  Added #if blocks to support compilation for 'mega128, 'can128,
 *  and 'mega1284p targets; have tested results for 'mega128 and
 *  'can128 only.
 *
 *  Version 0.5   (28 Sep 2008   KEL)
 *  Fixed bug in targetgets() that accepted a LF as a char.
 *  Added #define specific to the atmega1284p to redefine
 *  SPM_PAGESIZE; this value is incorrect in the current WinAVR
 *  compiler suite (it is 128, it should be 256).  Changed the
 *  info printed out after saving to flash to match that following
 *  the save to EEPROM.
 *
 *  Version 0.6   (26 Mar 2010   KEL)
 *  Start of support for ATxmega128a1.
 *
 *  Version 0.7   (14 Apr 2012   KEL)
 *  Extensive updates since last version, including ability to
 *  list the first line of each file in flash (not EEPROM); see
 *  LIST FILES in clist().
 *
 *  Version 0.8   (30 Apr 2012   KEL)
 *  Now reads F_CPU and console baud rate from the first 12 bytes
 *  of EEPROM; this allows customization of the KLBasic target without
 *  having to rebuild the KLBasic executable.  F_CPU is now a "port",
 *  rather than a constant.  Note that trying to get the addr() of
 *  F_CPU returns 0; DO NOT write to the address returned for
 *  F_CPU!
 */



/*
 *  Define strings for the target name and target version information.
 *  These will be displayed in the outheader() function in the core
 *  routines.
 */
#ifdef  __AVR_ATmega1284P__
#define  TARGET_MCU  "ATmega1284p"
#endif

#ifdef  __AVR_AT90CAN128__
#define  TARGET_MCU  "AT90CAN128"
#endif

#ifdef  __AVR_ATmega128__
#define  TARGET_MCU  "ATmega128"
#endif

//#ifdef  __AVR_ATxmega128A1__
//#define  TARGET_MCU  "ATxmega128a1"
//#endif

#ifndef  TARGET_MCU
#define  TARGET_MCU  "MCUs"
#endif

#define  TARGET_VERSION		"0.8"
#define  TARGET_INFO		"KLBasic for Atmel AVR " TARGET_MCU



/*
 *  The following #defines describe the target hardware.  XTAL_FREQ must be
 *  the crystal frequency in Hz.  RTC_PRESCALER and RTC_PRESCALER_MASK
 *  define the prescaler used to divide the system clock for use by the
 *  selected output-compare timer to generate a 1 msec tic.
 */

#ifdef  __AVR_ATmega1284P__								// if building for 'mega1284p...
#define  XTAL_FREQ				F_CPU
#define  RTC_SOURCE_FREQ		XTAL_FREQ				/* defines the clock used by the RTC */
#define  RTC_PRESCALER			256L					/* must match RTC_PRESCALER_MASK! */
#define  RTC_PRESCALER_MASK		(1<<CS02)				/* must match RTC_PRESCALER! */
#define  OC_COUNTS_PER_MSEC		((RTC_SOURCE_FREQ/(1000L*RTC_PRESCALER))-1)		/* CTC frequency is 1001.6 Hz */
#endif

#ifdef  __AVR_AT90CAN128__								// if building for 'can128...
#define  XTAL_FREQ				F_CPU
#define  RTC_SOURCE_FREQ		XTAL_FREQ				/* defines the clock used by the RTC */
#define  RTC_PRESCALER			256L					/* must match RTC_PRESCALER_MASK! */
#define  RTC_PRESCALER_MASK		(1<<CS02)				/* must match RTC_PRESCALER! */
#define  OC_COUNTS_PER_MSEC		((RTC_SOURCE_FREQ/(1000L*RTC_PRESCALER))-1)		/* CTC frequency is 1001.6 Hz */
#endif

#ifdef  __AVR_ATmega128__								// if building for 'mega128
#define  XTAL_FREQ				F_CPU
#define  RTC_SOURCE_FREQ		XTAL_FREQ				/* defines the clock used by the RTC */
#define  RTC_PRESCALER			256L					/* must match RTC_PRESCALER_MASK! */
#define  RTC_PRESCALER_MASK		((1<<CS02)|(1<<CS01))	/* must match RTC_PRESCALER! */
#define  OC_COUNTS_PER_MSEC		((RTC_SOURCE_FREQ/(1000L*RTC_PRESCALER))-1)		/* CTC frequency is 1001.6 Hz */
#endif




#ifndef  XTAL_FREQ						// if chip was not specified
#error  XTAL_FREQ not set for desired MCU in targetavr.h.
#endif





/*
 *  Define named literals for setting the UART baud rate.
 *
 *  The following defines assume the U2X0 bit is set, which divides
 *  the USART clock by 2.
 *
 *  The following defines assume a 8.00 MHZ crystal.
 */

#define  BAUDREG_115200            	((XTAL_FREQ/(115200*8))-1)
#define  BAUDREG_57600             	((XTAL_FREQ/(57600*8))-1)
#define  BAUDREG_38400             	((XTAL_FREQ/(38400*8))-1)
#define  BAUDREG_19200             	((XTAL_FREQ/(19200*8))-1)
#define  BAUDREG_9600				((XTAL_FREQ/(9600*8))-1)

#define  BAUDRATE_DEFAULT			38400
#define  BAUDREG_DEFAULT			BAUDREG_38400


/*
 *  Define the structure for holding information on the I/O ports.
 *  See targetavr.c for details on how this table is used.
 */
typedef struct
{
	char					name[MAX_NAME_LEN+1];		// name of I/O port
	U16						addr;						// address of I/O port
	char					size;						// number of bytes in port
}  IOPORT;


/*
 *  Define the structure for holding target-specific constants.
 *  See basicmbed.c for details on how this table is used.
 */
typedef struct
{
	char					name[MAX_NAME_LEN+1];		// name of the constant
	I32						value;						// value of the constant
}  CONST;




/*
 *  Declare arrays that act as RAM and EEPROM on the 68hc11.
 */

#ifdef  __AVR_ATmega1284P__				// if building for 'mega1284p...
#define  MAX_VARRAM			 400
#define  MAX_PRGRAM		   10000
#define  MAX_DYN_MEM		1000
#define  MAX_EEPROM       	4096		/* total amount of EEPROM on device */
#else
#define  MAX_VARRAM			 200
#define  MAX_PRGRAM			1500
#define  MAX_DYN_MEM		 400
#define  MAX_EEPROM       	4096		/* total amount of EEPROM on device */
#endif


unsigned char				varram[MAX_VARRAM];
unsigned char				prgram[MAX_PRGRAM];
EXTERN  U8					dynmem[MAX_DYN_MEM];	// dynamic storage for arrays, see strastg








/*
 *  Declare offsets from the start of EEPROM area for accessing various
 *  non-volatile parameters.
 */
#define  EEOFF_FCPU			0											/* offset to NV MCU core frequency */
#define  EEOFF_BAUDRATE		(EEOFF_FCPU+sizeof(U32))					/* offset to NV baud rate for console */
#define  EEOFF_CHKSUM		(EEOFF_BAUDRATE+sizeof(U32))				/* offset to 32-bit checksum of prior NV system parameters */


#define  EEOFF_BASBEG		(EEOFF_CHKSUM+sizeof(U32))					/* offset to NV basbeg pointer */
#define  EEOFF_BASEND		(EEOFF_BASBEG+sizeof(unsigned char *))		/* offset to NV basend pointer */
#define  EEOFF_VARBEGIN		(EEOFF_BASEND+sizeof(unsigned char *))		/* offset to NV varbegin pointer */
#define  EEOFF_VAREND		(EEOFF_VARBEGIN+sizeof(unsigned char *))	/* offset to NV varend pointer */
#define  EEOFF_DYNBEG		(EEOFF_VAREND+sizeof(unsigned char *))		/* offset to NV dynmem start pointer */
#define  EEOFF_DYNEND		(EEOFF_DYNBEG+sizeof(unsigned char *))		/* offset to NV dynmem end pointer */
#define  EEOFF_AUTOST		(EEOFF_DYNEND+sizeof(unsigned char *))		/* offset to NV autost flag */
#define  EEOFF_AUTOFILE		(EEOFF_AUTOST+sizeof(unsigned char))		/* offset to NV auto-start file number */
#define  EEOFF_EEPROG		(EEOFF_AUTOFILE+sizeof(unsigned char))		/* offset to NV start of prog area */
#define  EESIZE				(MAX_EEPROM-EEOFF_EEPROG)					/* number of bytes of EE saved for program */







#endif
