/* Adapted for CortexM3 LPC1768, originally based on LPC21xx and LPC22xx User 
 * Manual UM10144, pg. 15. */

OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(arm)


/*
 *  The ECM module uses a small section of flash in the upper range of the
 *  mbed's memory space.
 *
 *  The ECM module uses the static RAM reserved for APB1 peripherals (16K).
 */
MEMORY
{
	flash (rx)  : ORIGIN = 0x00070000, LENGTH = 32K
	sram (rwx) : ORIGIN = 0x20080000, LENGTH =  16K
}

/*
 *  Define the top our stack at the end of SRAM
 *
 *  Note that ECMs usually use the stack pointer that is passed to them
 *  when a function is invoked from outside; there isn't really any need for
 *  a stack for ECMs.  However, if you decide you want to have an ECM-
 *  specific stack, this linker script includes support for it.  Note that
 *  your ECM program will have to modify the stack pointer itself; there
 *  are no provisions for setting up the stack as part of an ECM's make.
 */
TOTAL_RESERVED_STACK = 8196;		/* note that printf() and other stdio routines use 4K+ from stack! */
_end_stack = 0x20084000;

EXTERN(__jump_vector_table);

SECTIONS
{
	.text :
	{
		CREATE_OBJECT_SYMBOLS
		/* Insert the jump vector table first */
		__jump_vector_table = .;
		*(.jump_vector_table)

		/* Rest of the code (C) */
		*(.text)
		*(.text.*)
		*(.glue_7)
		*(.glue_7t)

/* Added following section for holding initializers for variables   */
/* found in RAM.
/*
  The _data_size value will be used in the startup code to step through
  the image of data in flash and copy it to RAM.
*/
		. = ALIGN(4);
/*		_start_data_flash = .;  */
		*(.rodata)
		*(.rodata*)
		*(.init)					/* added */
		*(.fini)					/* added */
		. = ALIGN(4);
		_end_data_flash = .;
	} >flash

  /*  From generic.ld, supplied by CodeSourcery  */
  /* .ARM.exidx is sorted, so has to go in its own output section.  */
	PROVIDE_HIDDEN (__exidx_start = .);
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} >sram  
	PROVIDE_HIDDEN (__exidx_end = .);

	
/*	.data : AT (_end_data_flash)   */
	.data :
	{
		_start_data_flash = LOADADDR(.data);
		_start_data = .;
		*(.data)
		*(.data.*)
		*(.shdata)
		_end_data = .;
	} >sram  AT>flash
	. = ALIGN(4);
	_data_size = _end_data - _start_data;

	.noinit :
	{
		*(.noinit)
		*(.noinit.*)
	}
	
	_start_bss = .;
	.bss :
	{
		*(.bss)
		*(.bss.*)
		*(COMMON)
	} >sram
	. = ALIGN(4);
	_end_bss = .;

	bss_size = _end_bss - _start_bss;


	/* Stack can grow down to here, right after data and bss sections in 
	 * SRAM */
	_start_stack = _end_stack - TOTAL_RESERVED_STACK;
	_end_stack = _end_stack;			/* just to make the map file easier to read */

	/* Linker wants .eh_frame section defined because of gcc 4.4.X bug,
	 * just discard it here. */
	/DISCARD/ :
	{
		*(.eh_*)
	}
}

_end = .;
PROVIDE(end = .);

