#include  <stdio.h>

#include  "LPC17xx.h"


static  uint8_t				*breakflag;


/*
 *  Initialize      low-level module initialization
 *
 *  Note that you MUST call this routine before invoking any other
 *  elements of the module!  Even though there is no code in this
 *  function, calling this routine (the first entry in the module's
 *  jump table) forces the initialization of the module's .data sections.
 *  If you don't invoke this function, variables won't be zeroed or
 *  initialized!
 */
void  Initialize(uint32_t  *args, uint32_t  nargs)
{
}


/*
 *  GetBreakflag      register a pointer to the breakflag
 *
 *  This routine takes a single argument.  args[0] must hold
 *  a pointer to the KLBasic break flag.  This module will
 *  later test the contents of this break flag to determine
 *  if the user has entered a ctrl-C at the console to halt
 *  the program.
 */
void  GetBreakflag(uint32_t  *args, uint32_t  nargs)
{
	if (nargs == 1)  breakflag = (uint8_t *)args[0];
}





/*
 *  Blinky      blink an LED the convoluted way
 *
 *  Upon entry, nargs must be 3.
 *  args[0] must hold the address of a down-counting timer
 *  for use by this routine.
 *  args[1] must hold a mask of LEDs to blink; bit 0 set
 *  means blink LED1, etc.
 *  args[2] holds the delay, in msecs, for each LED state
 *  change.
 *
 *  This routine does not return until the user hits a ctrl-C
 *  on the console.
 *
 *  If you didn't invoke GetBreakflag() to register the address
 *  of the break flag, this routine exits immediately.
 */
void  Blinky(uint32_t  *args, uint32_t  nargs)
{
	uint32_t					delay;
	uint32_t					mask;
	uint32_t					*timer;

/*
 *  If the breakflag pointer is empty, the user has no way
 *  to break out, short of a reset.  Let's be nice and just
 *  refuse to run until the breakflag pointer is at least
 *  not NULL.
 */
	if (breakflag == 0)  return;

/*
 *  Turn off all mbed LEDs so we know we got this far.
 */
	LPC_GPIO1->FIODIR = ((1<<18) | (1<<20) | (1<<21) | (1<<23));
	LPC_GPIO1->FIOCLR = ((1<<18) | (1<<20) | (1<<21) | (1<<23));
	if (nargs != 3)  return;

/*
 *  Record the timer we get to use.
 */
	timer = (uint32_t *)args[0];

/*
 *  Translate the mask arg into a mask suitable for controlling
 *  the mbed LEDs.
 */
	mask = 0;
	if (args[1] & (1<<0))  mask = mask | (1<<18);
	if (args[1] & (1<<1))  mask = mask | (1<<20);
	if (args[1] & (1<<2))  mask = mask | (1<<21);
	if (args[1] & (1<<3))  mask = mask | (1<<23);

/*
 *  Record the delay.
 */
	delay = args[2];

/*
 *  Start the loop that blinks the LEDs.  Use the timer
 *  to pace the LED changes.
 */
	while (1)
	{
		LPC_GPIO1->FIOSET = mask;
		*timer = delay;
		while (*timer)  ;
		LPC_GPIO1->FIOCLR = mask;
		*timer = delay;
		while (*timer)  ;

/* 
 *  If the break flag is not zero, the user wants to quit
 *  the blinky program.
 */
		if (*breakflag)  return;
	}
}


