 <?php

// Include auth file
include ("auth.php");

// Include the file to process the login form
include ("login.php");

// Include the header
include ("header.php");

// Make sure the user's valid if there's cookies
if ($LoggedIn == "YES") {

    // Greet the user by name based on time of day
    echo "<b>Good ";
    if (date("A") == "AM") {
        echo "morning";
    } elseif ((date("H") >= "12") && (date("H") < 18)) {
        echo "afternoon";
    } else {
        echo " evening";
    }
    echo ", " . $Name . ".</b></b><br><br>\n";

    // Tell user when last login was and from who
    echo "Last Login: $xLastLogin (<i>$xLastIP</i>)<br><br>\n";

} else {

    // Tell purpose if not logged in
    echo "<strong>Purpose</strong><br>\n";
    echo "The goal of RANTS is to give users a place to store personal notes about anything they want from anywhere they want.<br><br>\n";

    // Show join message if not logged in
    echo "<strong>Register</strong><br>\n";
    echo "You can <a href=\"register.php\">register here</a> for free to start using RANTS today.<br><br>\n";
//	  echo "Private system, registration on owner's demand<br><br>\n";
	  
    // Show login form if not logged in
    echo "<strong>Login</strong><br>\n";
    echo "<form method=\"POST\" action=\"index.php\">\n";
    echo "<table>\n";
    echo "<tr>\n";
    echo "<td><b>E-Mail Address</b></td>\n";
    echo "<td><input type=\"text\" name=\"Email\" maxlength=\"64\"></td>\n";
    echo "</tr>\n";
    echo "<tr>\n";
    echo "<td><b>Password</b></td>\n";
    echo "<td><input type=\"password\" name=\"Password\" maxlength=\"20\"></td>\n";
    echo "</tr>\n";
    echo "<tr>\n";
    echo "<td align=\"center\" colspan=\"2\"><input type=\"submit\" value=\"Login\"></td>\n";
    echo "</tr>\n";
    echo "</table>\n";
    echo "</form><br>\n";
}

// Show any errors encountered
if (isset($error)) {
    echo "<font color=\"red\"><b>" . $error . "</b></font><br><br>";
//    include ("footer.php");
//    exit;
}

// Show some links to functions if logged in
if ($LoggedIn == "YES") {

    // Include file to manage notes
    include ("notes.php");

    // Give link to add note
    echo "<a href=\"?do=add\">Add Note</a>";

    // Give link to change password
    echo " | <a href=\"?do=changepass\">Change Password</a>";

    // Give administration link if status
    if ($Status == "Administrator") {
        echo " | <a href=\"admin.php\">Administration</a>";
    }

    // Give link to logout
    echo " | <a href=\"logout.php\">Logout</a><br><br>\n";

// Show note about project initiation if not logged in
} else {
    echo "<hr>\n";
    echo "<br><br>\n";
    echo "<i>This system was created by <a href=\"http://rants.eric1207.com\">Eric O'Callaghan</a>. Picked up and modified by <a href=\"http://mcbx.netne.net\">MCbx</a>.</i><br><br>\n";
	echo "The source code of this version can be downloaded <a href=\"rants_src.tar.gz\">HERE</a>.<br><br>\n";
	echo "This site uses cookies.<br><br>\n";

}

// Include the footer
include ("footer.php");
?> 
