#!/usr/bin/perl
# XSPELLING.PL  -  GUI utility for ASPell
# 2019 MCbx    GNU GPL
#
# Launches a nice GUI for checking of spelling.
# Usage: xspelling -f file.txt  - overwrites file!
#        xspelling -c           - read from clipboard and accept to clipboard
# REQUIRES: Tk, aspell.


##################
#
# This file was automatically generated by ZooZ.pl v1.2
# on Thu Aug  1 15:52:20 2019.
# Project: Project 1
# File:    /home/mcbx/Pobrane/ZooZ-1.2/aspellgui.zooz
#
##################

use strict;
use warnings;
use utf8;
use Tk 804;
use Tk::Clipboard;
use Tk::ROText;
use Tk::MsgBox;
use Text::Aspell;
my $speller = Text::Aspell->new;

# Global variables
my (
     $MW,
     %ZWIDGETS,
    );

my $curr_language = "eng"; #this is mostly to punch the ASpell engine out of the definition error, it's replaced by actual language
my $curr_word = ''; #Currently corrected word - text entry field in the bottom
my @suggestions=();
my @dicts = $speller->list_dictionaries;

my $mode="";
my $CONF_FILE=$ENV{"HOME"}."/.config/xspellingrc"; #config file 


my $buf="";
my $bad_word="";
my $pos=0;
my $txt="";

#Very bad undo mechanism by "previous entire state"
my $Ppos=0;
my $Ptxt="";
######################
#
# Create the MainWindow
#
######################

$MW = MainWindow->new;

ZloadImages();
ZloadFonts ();

############################
#  INTERFACE CONSTRUCTION  #
############################

# Main text window
$ZWIDGETS{'Text1'} = $MW->Scrolled('ROText',
   -scrollbars      => 'e',
   -exportselection => 1,
   -font            => 'DejaVu_Serif_10_normal_roman_',
   -setgrid         => 1,
   -takefocus       => 0,
   -width           => 100,
   -wrap => 'word',
  )->grid(
   -row        => 0,
   -column     => 0,
   -rowspan    => 5,
   -columnspan => 13,
   -sticky     => 'nsew',
  );

# List of suggestions
$ZWIDGETS{'Listbox1'} = $MW->Scrolled("Listbox",
   -exportselection => 1,
   -height          => 5,
   -setgrid         => 0,
   -width           => 80,
   -scrollbars => "e",
   -listvariable => \@suggestions,
   -selectmode => "single",
  )->grid(
   -row        => 5,
   -column     => 0,
   -rowspan    => 3,
   -columnspan => 12,
   -sticky     => 'new',
  );
  #Add procedures when contents are changed
  $ZWIDGETS{'Listbox1'}->bind('<<ListboxSelect>>' => sub {$curr_word=$ZWIDGETS{'Listbox1'}->get($ZWIDGETS{'Listbox1'}->curselection)});
  $ZWIDGETS{'Listbox1'}->bind('<Double-1>', \&ChangeCurrent);

# "Language:"
$ZWIDGETS{'Label1'} = $MW->Label(
   -text => 'Language:',
  )->grid(
   -row    => 8,
   -column => 0,
  );

# Language selection combo box
$ZWIDGETS{'Optionmenu1'} = $MW->Optionmenu(
   -command      => 'main::LanguageChanged',
   -indicatoron  => 1,
   -takefocus    => 1,
   -text         => '',
   -width => 20,
   -textvariable => \$curr_language,
  )->grid(
   -row        => 8,
   -column     => 1,
   -columnspan => 2,
  );
  
  #########################################
  # PROCEDURE: FILL THE DICTIONARIES MENU #
  #########################################
  
for (my $i=0;$i<=$#dicts;$i++)
{
    my @qq=split(':',$dicts[$i]);
    $dicts[$i]=$qq[0];
}
for (my $i=0;$i<=$#dicts;$i++) #TODO: Do we need to separate these?
{
    my @qq=split('-',$dicts[$i]);
    $dicts[$i]=$qq[0];
}
@dicts = uniq(@dicts);
sub uniq {
    my %h;
    return grep { !$h{$_}++ } @_
}
$ZWIDGETS{'Optionmenu1'}->addOptions(@dicts);
$ZWIDGETS{'Optionmenu1'}->configure(-width=>20,);

# "Save settings" button
$ZWIDGETS{'Button7'} = $MW->Button(
   -command => 'main::SaveSettings',
   -text    => 'Save settings',
  )->grid(
   -row    => 8,
   -column => 3,
   -sticky => 'w',
  );

# Undo button
$ZWIDGETS{'Button6'} = $MW->Button(
   -command => 'main::UndoChange',
   -text    => 'Undo change',
  )->grid(
   -row    => 8,
   -column => 5,
   -sticky => 'new',
  );

# Corrected word entry
$ZWIDGETS{'Entry1'} = $MW->Entry(
   -exportselection => 1,
   -textvariable    => \$curr_word,
  )->grid(
   -row    => 8,
   -column => 7,
  );

# "Add to dictionary" button
$ZWIDGETS{'Button1'} = $MW->Button(
   -command => 'main::AddToDict',
   -text    => 'Add to dictionary',
  )->grid(
   -row        => 8,
   -column     => 8,
   -columnspan => 2,
   -sticky     => 'ew',
  );

# Cancel button
$ZWIDGETS{'Button5'} = $MW->Button(
   -command => 'main::CancelEverything',
   -text    => 'Cancel all',
  )->grid(
   -row    => 8,
   -column => 11,
   -sticky => 'new',
  );

# Replace button
$ZWIDGETS{'Button2'} = $MW->Button(
   -command => 'main::ChangeCurrent',
   -text    => 'Change',
  )->grid(
   -row    => 5,
   -column => 12,
   -sticky => 'nsew',
  );

# Next word button
$ZWIDGETS{'Button3'} = $MW->Button(
   -command => 'main::IgnoreCurrent',
   -text    => 'Ignore',
  )->grid(
   -row    => 6,
   -column => 12,
   -sticky => 'ew',
  );

# Apply all text button
$ZWIDGETS{'Button4'} = $MW->Button(
   -command => 'main::ConfirmEverything',
   -text    => 'Confirm all',
  )->grid(
   -row    => 8,
   -column => 12,
   -sticky => 'nsew',
  );
  
# "Ignore entire word" button by adding it to temporary dict
$ZWIDGETS{'Button3a'} = $MW->Button(
   -command => 'main::IgnoreAll',
   -text    => 'Ignore word',
  )->grid(
   -row    => 7,
   -column => 12,
   -sticky => 'ew',
  );

#Grid configuration
$MW->gridColumnconfigure(0,
   -minsize => 10,
   -weight=>0,
  );

$MW->gridColumnconfigure(1,
   -minsize => 10,
   -weight=>2,
  );

$MW->gridColumnconfigure(2,
   -minsize => 10,
   -weight=>2,
  );

$MW->gridColumnconfigure(3,
   -minsize => 30,
  );

$MW->gridColumnconfigure(4,
   -minsize => 30,
  );

$MW->gridColumnconfigure(5,
   -pad     => 10,
   -minsize => 40,
   -weight=>2,
  );

$MW->gridColumnconfigure(6,
   -minsize => 40,
  );

$MW->gridColumnconfigure(7,
   -minsize => 40,
  );

$MW->gridColumnconfigure(8,
   -minsize => 40,
  );

$MW->gridColumnconfigure(9,
   -minsize => 40,
  );

$MW->gridColumnconfigure(10,
   -minsize => 40,
  );

$MW->gridColumnconfigure(11,
   -minsize => 40,
  );

$MW->gridColumnconfigure(12,
   -minsize => 40,
  );

$MW->gridRowconfigure(0, -weight=>2,);

##################
# INITIALIZATION #
##################

if ($#ARGV == -1 )
{
    print "Error! \n";
    print "Use xspelling -c            for clipboard checking.\n";
    print "Or  xspelling -f filename   for analysis of text file\n";
    print "The last argument if specified, is the language, overriding saved settings.\n";
    exit;
}

if ( -e $CONF_FILE ) #Read selected language from file
	{
		open (my $FH,'<',$CONF_FILE);
		my @configu=();
		while (<$FH>)
		{
			$_=~s/\n//g;
			push (@configu,$_);
		}
		close $FH;
		
		$curr_language = $configu[0]; #0 - currently selected language
        if ($#configu>1)
        {
            my $width=$configu[1];    #1 - window width
            my $height=$configu[2];   #2 - window height
            #$MW->configure(-width=>$width, -height=>$height);
            #TODO: resize
        }
	}

if ($ARGV[0] eq "-c") #We are from clipboard
{
    print "Getting from clipboard\n";
    $ZWIDGETS{'Text1'}->clipboardPaste();
    $mode="CLIPBOARD";
    if ($#ARGV>0)
    {
        $curr_language=$ARGV[1];
    }
    initializeTest();
    find_next();
}
if ($ARGV[0] eq "-f") #We are from file
{
    $mode="FILE";
    print "Getting from file: $ARGV[1]\n";
    open (my $FH,'<',$ARGV[1]);
	while (<$FH>)
	{
        utf8::decode($_);
        $ZWIDGETS{"Text1"}->insert('end',$_);
#		$_=~s/\n//g;
	}
	close $FH;
    if ($#ARGV>1)
    {
        $curr_language=$ARGV[2];
    }
    initializeTest();
    find_next();
}

# MainLoop
MainLoop;

#################
#  SUBROUTINES  #
#################

sub ZloadImages {
}

sub ZloadFonts {
  $MW->fontCreate('DejaVu_Serif_10_normal_roman_',
   -underline  => 0,
   -slant      => 'roman',
   -overstrike => 0,
   -size       => -17,
   -family     => 'DejaVu Serif',
   -weight     => 'normal',
  );
}

sub CancelEverything { #Abandon, exit
    exit();
}

sub SaveSettings {  #Save settings to config file
		open (my $FH,'>',$CONF_FILE);
        print $FH $curr_language;
        print $FH "\n";
        print $FH $ZWIDGETS{"Text1"}->width;
        print $FH "\n";
        print $FH $ZWIDGETS{"Text1"}->height;
        print $FH "\n";
		close $FH;
}

sub ChangeCurrent {  #Change currently selected wrong word with CONTENTS OF REPLACEMENT FIELD and proceed next
    if ($bad_word ne "" )
    {
    
    $Ptxt=$txt; #not a good undo technique
    $Ppos=$pos;
    
    #Change to contents of the bottom input. The bad_word is on the pos position.
    substr($txt,$pos-length($bad_word)-1,length($bad_word),$curr_word); #Replace
       $ZWIDGETS{"Text1"}->delete("1.0", "end"); #Reinstantiate text
       $ZWIDGETS{"Text1"}->insert("0.0",$txt);   #Reinstantiate text
    #Calculate new pos
    my $ldiff=length($bad_word)-length($curr_word);
        $pos=$pos+(-1*$ldiff);
    
    }
    find_next();
}

sub UndoChange { #Undo change and proceed next
    if ($Ptxt ne "")
    {
        $pos=$Ppos;
        $txt=$Ptxt;
        $ZWIDGETS{"Text1"}->delete("1.0", "end"); #Reinstantiate text
        $ZWIDGETS{"Text1"}->insert("0.0",$txt);   #Reinstantiate text
        $Ppos=0;
        $Ptxt="";
        find_next();
    }
}

sub ConfirmEverything { #Finally confirm changes, rewrite target, exit.
     $txt = $ZWIDGETS{"Text1"}->get('1.0', 'end-1c'); #update
     if ($mode eq 'CLIPBOARD' )
     {
        
        #Select all - implicit copy to GRAPHOSCOPE's clipboard 
         $ZWIDGETS{"Text1"}->SetCursor("0.0");
         $ZWIDGETS{"Text1"}->tagDelete('sel');
         $ZWIDGETS{"Text1"}->tagAdd('sel',"0.0","end");
         
        #copy $txt to clipboard (ALPHASCOPE's / System's clipboard)
         $ZWIDGETS{"Text1"}->clipboardClear();
         $ZWIDGETS{"Text1"}->clipboardAppend($txt);

         #This split is a relict of early Unix workstations noone remembers about
     }
    if ($mode eq 'FILE' )
     {
         #save $txt to file in $ARGV[1]
         open(my $FH, ">",$ARGV[1]) or die("Cannot open file for writing!");
         print $FH $txt;
         close $FH;
         exit;
     }
}

sub LanguageChanged { #The alnguage has been changed mid-flight. Reconfigure and proceed.
    print "Lang if $curr_language now\n";
    $speller = Text::Aspell->new;
    $speller->set_option('lang',$curr_language);
    $speller->set_option('sug-mode','normal');
    $speller->set_option('mode','url');
    $speller->set_option('encoding','utf-8');
    initializeTest();
    if ($txt ne "")
    {
        find_next();
    }
}

sub AddToDict {    #Add the word to personal dictionary on disk.
#    $speller->add_to_session($bad_word);   #comment this! For testing only!
    $speller->add_to_personal($bad_word); #uncomment that!
    $speller->save_all_word_lists;
    find_next();
}

sub IgnoreCurrent { #Proceed next ignoring the word.
    find_next();
}

sub IgnoreAll { #Add the word to temporary ignore list
    $speller->add_to_session($bad_word);
    find_next();
}

sub initializeTest { #Initialize spell check.
    $speller->set_option('lang',$curr_language);
    $txt = $ZWIDGETS{"Text1"}->get('1.0', 'end-1c');  #get textt to var
    $buf="";
    $pos=0;
}

sub find_next { #Proceed next routine. Main checking is here.
    #iterate word by word
    for (my $i=$pos;$i<=length($txt);$i++)
    { 
       if ($i==length($txt)) # End of text
       {
           my $d = $MW->MsgBox(-title => "End", -message=>"End reached, Click Change/Ignore to restart.", -type => "ok");
           $d->Show;
           $pos=0;
           $buf="";
           $ZWIDGETS{"Text1"}->tagDelete('under');
           last;
       } 
       
       #TODO: Fix this with regex as it grown too much. Remember about ' in O'Hara and McDonald's are not breaks, while 'quoted' is OK
       if ((substr($txt,$i,1) ne ' ') and (substr($txt,$i,1) ne '\t') and (substr($txt,$i,1) ne '\n') and (substr($txt,$i,1) ne '\r') 
       and (substr($txt,$i,1) ne '.') and (substr($txt,$i,1) ne ',') and (substr($txt,$i,1) ne '!') and (substr($txt,$i,1) ne '?') 
       and (substr($txt,$i,1) ne '-') and (substr($txt,$i,1) ne '/') and (substr($txt,$i,1) ne ')') and (substr($txt,$i,1) ne ']') and (substr($txt,$i,1) ne '}') 
       and (substr($txt,$i,1) ne '(') and (substr($txt,$i,1) ne '[') and (substr($txt,$i,1) ne '{') and (substr($txt,$i,1) ne ':') and (substr($txt,$i,1) ne ';') 
       and (substr($txt,$i,1) ne '|') and (substr($txt,$i,1) ne '\\') and (substr($txt,$i,1) ne '=') and (substr($txt,$i,1) ne '+') and (substr($txt,$i,1) ne '"') 
       and (substr($txt,$i,1) ne '\'') and (substr($txt,$i,1) ne '_') and (substr($txt,$i,1) ne '*') and (substr($txt,$i,1) ne '&') and (substr($txt,$i,1) ne '^') 
       and (substr($txt,$i,1) ne '%') and (substr($txt,$i,1) ne '$') and (substr($txt,$i,1) ne '#') and (substr($txt,$i,1) ne '@') 
       and (substr($txt,$i,1) ne '0') and (substr($txt,$i,1) ne '1') and (substr($txt,$i,1) ne '2') and (substr($txt,$i,1) ne '3') and (substr($txt,$i,1) ne '4') and (substr($txt,$i,1) ne '5') 
       and (substr($txt,$i,1) ne '6') and (substr($txt,$i,1) ne '7') and (substr($txt,$i,1) ne '8') and (substr($txt,$i,1) ne '9') and (substr($txt,$i,1) ne '<') and (substr($txt,$i,1) ne '>') 
       and (substr($txt,$i,1) ne '\`') and (substr($txt,$i,1) ne '~') and (substr($txt,$i,1) ne '”') and (substr($txt,$i,1) ne '“') and (substr($txt,$i,1) ne '„') and (ord(substr($txt,$i,1)) != 0x0a) )
        {
           my $q=ord(substr($txt,$i,1));
           if (($q != 0x0a ) ) #unix newline - thanks Solaris's Perl!
            {
                $buf=$buf.substr($txt,$i,1);
            }
      #     $pos=$i+1;
       } 
       else
       {    
           if($buf eq "") #last ass-saver.
           {                #People who push UTF standard should buy all people additional few TBs of RAM as well as hire graphic designers for fonts.
               next;        #You know that “ and ” are totally separate characters and both are used by some moron with 1500-key keyboard?
           }
           
            $ZWIDGETS{"Listbox1"}->selectionClear(0,'end'); #ceremony of stable listbox cleaning
            while ($#suggestions>-1)
            {
                splice(@suggestions,0,1);
            } 
            $MW->update;
             
            $pos=$i-length($buf);
#            print "$pos-$i: \"$buf\"\n";
           
            #WE HAVE A WORD in global var buf, in offset pos.

            #Skip bare-word
            my $tester=$buf;
            $tester=~s/[\ \t\r\l\n]//g;
            if (($tester eq "") or ($buf eq ""))
            {
                $pos = $i + 1;
                next;
            }
            
            my $found = $speller->check($buf);            
            if ( ! $found )
            {
                $bad_word=$buf;
                $curr_word=$buf;
                
                #selekt word
                $ZWIDGETS{"Text1"}->SetCursor("0.0");
                $ZWIDGETS{"Text1"}->tagDelete('under');
                my $qq="0.0+".$pos."c";
                my $ww="0.0+".($pos+length($buf))."c";
                $ZWIDGETS{"Text1"}->tagConfigure('under', -foreground => "red");
                $ZWIDGETS{"Text1"}->tagAdd('under',$qq,$ww);
                $ZWIDGETS{"Text1"}->see($qq);
                
                #fill suggestion box
                @suggestions = $speller->suggest( $buf );
                foreach my $aa (@suggestions)
                {
                    utf8::decode($aa);  #quick fix for Tk 804.
                }
                #propose first suggestion. The better with retarded ASpell probability engine is usually **the second** one but meh.
                if ($#suggestions>-1)
                {
                    $curr_word=$suggestions[0];
                }
                $pos=$i+1;
                $buf="";
                last;
            }
            
            $bad_word="";
            #prepare for next one
            $pos=$i+1;
            $buf="";
            next;
       }
    }
}
