#ifndef POWERTABLE_H
#define POWERTABLE_H

#include <QString>
#include <QVector>
#include "testsheet.h"

class PowerTable
{
public:
    struct powerEntry
    {
        short number;
        short type;
        short pin;
    };

    PowerTable(QString tableFile);

    int saveTable();
    int getCount();
    QString checkModel(TestSheet model);
    int getEntryFunc(int i);
    int getEntryPin(int i);
    bool setEntry(powerEntry ent, int i);
    void revertToDefault();
    void resize(int len);
private:
    QString filePath;
    QVector <powerEntry> entries;
    void createDefaultTable();
};

#endif // POWERTABLE_H
