#ifndef DEVICEDRIVER_H
#define DEVICEDRIVER_H

#include <QtSerialPort/QSerialPort>
#include <QtSerialPort/QSerialPortInfo>
#include <qstring.h>

class DeviceDriver
{
public:
    DeviceDriver(QString portName, int baudRate, int timeout);
    ~DeviceDriver();
    int changeName(QString portName);
    int changeRate(int baudRate);
    void changeTimeout(int timeout);
    int getTimeout();

    //Device handling routines
    int reset();
    int powerON();
    int setIO(QString pins);
    int setData(QString pins);
    QString getData();
    QString deviceVersion();
private:
    QSerialPort *serialConn;
    int openConn(QString portName,int baudRate);
    int Timeout;
    QByteArray getResponse(int expLength);
};

#endif // DEVICEDRIVER_H
