/*
 * $Workfile: gfx_rtns.h $
 * $Revision: 18 $
 * $Date: 9/27/00 5:08p $
 *
 * Copyright (c) 1999-2000 National Semiconductor Corporation.
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of National 
 * Semiconductor Corporation. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into
 * with National Semiconductor Corporation.
 * This code is supplied as is.
 *
 * This header file defines the Durango routines and variables used
 * to access the memory mapped regions.
 */

/*
 *$History: gfx_rtns.h $
 * 
 * *****************  Version 18  *****************
 * User: Sarma        Date: 9/27/00    Time: 5:08p
 * Updated in $/Engineering_Releases/Durango/gfx
 * Automated move of  C++ comments to c style commenting.
 * 
 * *****************  Version 17  *****************
 * User: Hari         Date: 9/08/00    Time: 12:22p
 * Updated in $/Engineering Releases/Durango/gfx
 * Added the function declaration and variable declarations for the
 * focus450 chip.
 * 
 * *****************  Version 16  *****************
 * User: Sarma        Date: 8/24/00    Time: 3:45p
 * Updated in $/durango/Engineering Releases/gfx
 * No parameter requied is void.
*/

/* COMPILER OPTION FOR C++ PROGRAMS */
#ifdef __cplusplus
extern "C" {
#endif

/* DURANGO MEMORY POITNERS */

extern unsigned char *gfx_regptr;
extern unsigned char *gfx_fbptr;
extern unsigned char *gfx_vidptr;
extern unsigned char *gfx_vipptr;

/* TV DEFINITIONS */

#define TV_FORMAT_NTSC		0x01
#define TV_FORMAT_PAL		0x02

#define TV_RES_640_480		0x01
#define TV_RES_800_600		0x02
#define TV_RES_DVIP         0x03

#define TV_OUTPUT_COMPOSITE	0x01
#define TV_OUTPUT_S_VIDEO	0x02

#define TV_FLICKER_FILTER_NONE	      0x01
#define TV_FLICKER_FILTER_NORMAL      0x02
#define TV_FLICKER_FILTER_INTERLACED  0x03

/* VBI FORMATS */
#define VBI_FORMAT_VIDEO	0x1
#define VBI_FORMAT_RAW		0x2
#define VBI_FORMAT_CC		0x4
#define VBI_FORMAT_NABTS	0x8

/* VIDEO DEFINITIONS */
#define VIDEO_FORMAT_UYVY   0x1
#define VIDEO_FORMAT_YUYV   0x2
#define VIDEO_FORMAT_Y2YU   0x3
#define VIDEO_FORMAT_YVYU   0x4
#define VIDEO_FORMAT_Y0Y1Y2Y3 0x5
#define VIDEO_FORMAT_Y3Y2Y1Y0 0x6
#define VIDEO_FORMAT_Y1Y0Y3Y2 0x7
#define VIDEO_FORMAT_Y1Y2Y3Y0 0x8
#define VIDEO_FORMAT_RGB    0x9

#define VIDEO_DOWNSCALE_KEEP_1_OF 0x1
#define VIDEO_DOWNSCALE_DROP_1_OF 0x2

#define VIDEO_SOURCE_MEMORY 0x1
#define VIDEO_SOURCE_DVIP   0x2
#define VBI_SOURCE_MEMORY   0x1
#define VBI_SOURCE_DVIP     0x2

#define GENLOCK_FIELD_SYNC  0x1
#define GENLOCK_SINGLE      0x2
#define GENLOCK_CONTINUOUS  0x4
#define GENLOCK_SYNCED_EDGE_FALLING  0x8
#define GENLOCK_SYNCING_EDGE_FALLING 0x10
#define GENLOCK_TIMEOUT              0x20
#define GENLOCK_ENCODER_RESET        0x40
#define GENLOCK_RESET_EVEN_FIELD     0x80

/* VIP DEFINITIONS */

#define VIP_MODE_C          0x1

#define VIP_CAPTURE_STOP_LINE	0x1
#define VIP_CAPTURE_STOP_FIELD	0x2
#define VIP_CAPTURE_START_FIELD	0x4

#define VBI_ANCILLARY       0x1
#define VBI_TASK_A          0x2
#define VBI_TASK_B          0x4


/* End of the Added code */

/* VGA STRUCTURE */

#define GFX_STD_CRTC_REGS 25
#define GFX_EXT_CRTC_REGS 16

#define GFX_VGA_FLAG_MISC_OUTPUT	0x00000001
#define GFX_VGA_FLAG_STD_CRTC		0x00000002
#define GFX_VGA_FLAG_EXT_CRTC		0x00000004

/* FS450 TV Standard flags */
#define GFX_TV_STANDARD_NTSC_M 0x0001
#define GFX_TV_STANDARD_NTSC_M_J 0x0002
#define GFX_TV_STANDARD_PAL_B 0x0004
#define GFX_TV_STANDARD_PAL_D 0x0008
#define GFX_TV_STANDARD_PAL_H 0x0010
#define GFX_TV_STANDARD_PAL_I 0x0020
#define GFX_TV_STANDARD_PAL_M 0x0040
#define GFX_TV_STANDARD_PAL_N 0x0080
#define GFX_TV_STANDARD_PAL_G 0x0100
/* FS450 VGA Mode flags */
#define GFX_VGA_MODE_UNKNOWN 0
#define GFX_VGA_MODE_640X480 0x0001
#define GFX_VGA_MODE_720X487 0x0002
#define GFX_VGA_MODE_720X576 0x0004
#define GFX_VGA_MODE_800X600 0x0008
#define GFX_VGA_MODE_1024X768 0x0010
/* FS450 TVout mode flags */
#define GFX_TVOUT_MODE_CVBS 0x0001
#define GFX_TVOUT_MODE_YC 0x0002
#define GFX_TVOUT_MODE_RGB 0x0004
#define GFX_TVOUT_MODE_CVBS_YC (GFX_TVOUT_MODE_CVBS | GFX_TVOUT_MODE_YC)
/* FS450 Luma and Chroma Filters */
#define GFX_LUMA_FILTER 0x0001
#define GFX_CHROMA_FILTER 0x0002
/* APS Trigger Bits */
#define GFX_APS_TRIGGER_OFF 0
#define GFX_APS_TRIGGER_AGC_ONLY 1
#define GFX_APS_TRIGGER_AGC_2_LINE 2
#define GFX_APS_TRIGGER_AGC_4_LINE 3


typedef struct {
	int xsize;
	int ysize;
	int hz;
	int clock;
	unsigned char miscOutput;
	unsigned char stdCRTCregs[GFX_STD_CRTC_REGS];
	unsigned char extCRTCregs[GFX_EXT_CRTC_REGS];
} gfx_vga_struct;

/* DURANGO VARIBLES FOR RUNTIME SELECTION AND POSSIBLE VALUES */

extern int gfx_display_type;
#define GFX_DISPLAY_TYPE_GU1		0x0001
#define GFX_DISPLAY_TYPE_GU2		0x0002

extern int gfx_2daccel_type;
#define GFX_2DACCEL_TYPE_GU1		0x0001
#define GFX_2DACCEL_TYPE_GU2		0x0002

extern int gfx_video_type;
#define GFX_VIDEO_TYPE_CS5530		0x0001
#define GFX_VIDEO_TYPE_SC1400		0x0002
#define GFX_VIDEO_TYPE_SC1200		0x0004

extern int gfx_vip_type;
#define GFX_VIP_TYPE_SC1400			0x0002
#define GFX_VIP_TYPE_SC1200			0x0004

extern int gfx_decoder_type;
#define GFX_DECODER_TYPE_SAA7114	0x0001

extern int gfx_tv_type;
#define GFX_TV_TYPE_SC1400			0x0001
#define GFX_TV_TYPE_GEODE			0x0001
#define GFX_TV_TYPE_SC1200			0x0002
#define GFX_TV_TYPE_FS451			0x0004

extern int gfx_i2c_type;
#define GFX_I2C_TYPE_ACCESS			0x0001
#define GFX_I2C_TYPE_GPIO			0x0002



/* POSSIBLE STATUS VALUES */

#define GFX_STATUS_UNSUPPORTED		(-3)
#define GFX_STATUS_BAD_PARAMETER	(-2)
#define GFX_STATUS_ERROR            (-1)
#define GFX_STATUS_OK				0

#define GFX_CPU_GXLV		1
#define GFX_CPU_SC1400		2
#define GFX_CPU_SC1200		3
#define GFX_CPU_PYRAMID		0x20801		

#define GFX_VID_CS5530		1
#define GFX_VID_SC1400		2
#define GFX_VID_SC1200		3

extern unsigned long gfx_cpu_version;
extern unsigned long gfx_cpu_frequency;
extern unsigned long gfx_vid_version;

/* ROUTINES IN GFX_INIT.C */

unsigned long gfx_pci_config_read(unsigned long address);
unsigned char gfx_gxm_config_read(unsigned char index);
unsigned long gfx_get_core_freq(unsigned char dir0, unsigned char dir1);
unsigned long gfx_detect_cpu(void);
unsigned long gfx_detect_video(void);
unsigned long gfx_get_cpu_register_base(void);
unsigned long gfx_get_frame_buffer_base(void);
unsigned long gfx_get_frame_buffer_size(void);
unsigned long gfx_get_vid_register_base(void);
unsigned long gfx_get_vip_register_base(void);
 
/* ROUTINES IN GFX_DISP.C */

int gfx_is_display_mode_supported(int xres, int yres, int bpp, int hz);
int gfx_set_display_mode(int xres, int yres, int bpp, int hz);
int	gfx_set_display_timings(unsigned short bpp, unsigned short flags,
	unsigned short hactive, unsigned short hblank_start, 
	unsigned short hsync_start, unsigned short hsync_end, 
	unsigned short hblank_end, unsigned short htotal, 
    unsigned short vactive, unsigned short vblank_start, 
	unsigned short vsync_start, unsigned short vsync_end, 
	unsigned short vblank_end, unsigned short vtotal,
	unsigned long frequency);
void gfx_set_display_pitch(unsigned short pitch);
void gfx_set_display_offset(unsigned long offset);
int gfx_set_display_palette(unsigned long *palette);
void gfx_video_shutdown(void);
void gfx_set_clock_frequency(unsigned long frequency);
int gfx_set_crt_enable(int enable);
void gfx_set_cursor_enable(int enable);
void gfx_set_cursor_colors(unsigned long bkcolor, unsigned long fgcolor);
void gfx_set_cursor_position(unsigned long memoffset, 
	unsigned short xpos, unsigned short ypos, 
	unsigned short xhotspot, unsigned short yhotspot);
void gfx_set_cursor_shape32(unsigned long memoffset, 
	unsigned long *andmask, unsigned long *xormask);
int gfx_set_compression_enable(int enable);
int gfx_set_compression_offset(unsigned long offset);
int gfx_set_compression_pitch(unsigned short pitch);
int gfx_set_compression_size(unsigned short size);
void gfx_set_display_priority_high(int enable);
int gfx_test_timing_active(void);
int gfx_test_vertical_active(void);
int gfx_wait_vertical_blank(void);
void gfx_delay_milliseconds(unsigned long milliseconds);
void gfx_delay_microseconds(unsigned long microseconds);
void gfx_enable_panning(int x, int y);
int gfx_set_fixed_timings(int panelResX, int panelResY, unsigned short width, unsigned short height, unsigned short bpp);

/* "READ" ROUTINES IN GFX_DISP.C */

int gfx_get_display_details(unsigned int mode, int *xres, int *yres, int *hz);
unsigned short gfx_get_display_pitch(void);
int gfx_get_sync_polarities(void);
unsigned long gfx_get_clock_frequency(void);
int gfx_mode_frequency_supported(int xres, int yres, int bpp, unsigned long frequency);
int gfx_get_refreshrate_from_frequency(int xres, int yres, int bpp, int *hz, unsigned long frequency);
int gfx_get_display_mode_count(void);
int gfx_get_display_mode(int *xres, int *yres, int *bpp, int *hz);
unsigned short gfx_get_hactive(void);
unsigned short gfx_get_hblank_start(void);
unsigned short gfx_get_hsync_start(void);
unsigned short gfx_get_hsync_end(void);
unsigned short gfx_get_hblank_end(void);
unsigned short gfx_get_htotal(void);
unsigned short gfx_get_vactive(void);
unsigned short gfx_get_vblank_start(void);
unsigned short gfx_get_vsync_start(void);
unsigned short gfx_get_vsync_end(void);
unsigned short gfx_get_vblank_end(void);
unsigned short gfx_get_vtotal(void);
unsigned short gfx_get_display_bpp(void);
unsigned long gfx_get_display_offset(void);
void gfx_get_display_palette(unsigned long *palette);
unsigned long gfx_get_cursor_enable(void);
unsigned long gfx_get_cursor_offset(void);
unsigned long gfx_get_cursor_position(void);
unsigned long gfx_get_cursor_clip(void);
unsigned long gfx_get_cursor_color(int color);
int gfx_get_compression_enable(void);
unsigned long gfx_get_compression_offset(void);
unsigned short gfx_get_compression_pitch(void);
unsigned short gfx_get_compression_size(void);
int gfx_get_display_priority_high(void);
int gfx_get_valid_bit(int line);

/* ROUTINES IN GFX_RNDR.C */

void gfx_set_bpp(unsigned short bpp);
void gfx_set_blt_buffers(unsigned short BB0base, unsigned short BB1base, 
	unsigned short BBwidthPixels);
void gfx_set_solid_pattern(unsigned long color);
void gfx_set_mono_pattern(unsigned long bgcolor, unsigned long fgcolor, 
	unsigned long data0, unsigned long data1, unsigned char transparency);
void gfx_set_color_pattern(unsigned long bgcolor, unsigned long fgcolor, 
	unsigned long data0, unsigned long data1,unsigned long data2,unsigned long data3, unsigned char transparency);
void gfx_set_solid_source(unsigned long color);
void gfx_set_mono_source(unsigned long bgcolor, unsigned long fgcolor,
	unsigned short transparent);
void gfx_set_pattern_flags(unsigned short flags);
void gfx_set_raster_operation(unsigned char rop);
void gfx_pattern_fill(unsigned short x, unsigned short y, 
	unsigned short width, unsigned short height);
void gfx_screen_to_screen_blt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height);
void gfx_screen_to_screen_xblt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height, unsigned long color);
void gfx_color_bitmap_to_screen_blt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height, unsigned char *data, long pitch); 
void gfx_color_bitmap_to_screen_xblt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height, unsigned char *data, long pitch, 
	unsigned long color); 
void gfx_mono_bitmap_to_screen_blt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height, unsigned char *data, short pitch); 
void gfx_bresenham_line(unsigned short x, unsigned short y, 
	unsigned short length, unsigned short initerr, 
	unsigned short axialerr, unsigned short diagerr, 
	unsigned short flags);
void gfx_wait_until_idle(void);
int gfx_test_blt_pending(void);

/* ROUTINES IN GFX_VID.C */

int gfx_set_video_enable(int enable);
int gfx_set_video_format(unsigned long format);
int gfx_set_video_size(unsigned short width, unsigned short height);
int gfx_set_video_offset(unsigned long offset);
int gfx_set_video_window(short x, short y, unsigned short w, 
	unsigned short h);
int gfx_set_video_scale(unsigned short srcw, unsigned short srch, 
	unsigned short dstw, unsigned short dsth);
int gfx_set_video_downscale_config(unsigned short type, unsigned short m); 
int gfx_set_video_color_key(unsigned long key, unsigned long mask, 
	int bluescreen);
int gfx_set_video_filter(int xfilter, int yfilter);
int gfx_set_video_palette(unsigned long *palette);
int gfx_set_video_downscale_coefficients(unsigned short coef1, unsigned short coef2,
										 unsigned short coef3, unsigned short coef4) ;
int gfx_set_video_downscale_enable(int enable);										 
int gfx_set_video_request(unsigned short x, unsigned short y);
int gfx_set_video_source(int source);
int gfx_set_vbi_source(int source);
int gfx_set_vbi_lines(unsigned long even, unsigned long odd);
int gfx_set_vbi_total(unsigned long even, unsigned long odd);
int gfx_set_video_interlaced(int enable);
int gfx_set_color_space_YUV(int enable);
	int gfx_set_genlock_delay(unsigned long delay);
int gfx_set_genlock_enable(int flags);
int gfx_set_video_cursor(unsigned long key, unsigned long mask, unsigned short select_color2,
						 unsigned long color1, unsigned short color2);
int gfx_set_video_request(unsigned short x, unsigned short y);

int gfx_select_alpha_region(int region);
int gfx_set_alpha_enable(int enable);
int gfx_set_alpha_window(unsigned short x, unsigned short y, 
	unsigned short width, unsigned short height);
int gfx_set_alpha_value(unsigned char alpha, char delta);
int gfx_set_alpha_priority(int priority);
int gfx_set_alpha_color(unsigned long color);
int gfx_set_video_outside_alpha(int enable);
int gfx_disable_softvga(void);
int gfx_enable_softvga(void);

/* READ ROUTINES IN GFX_VID.C */

int gfx_get_video_enable(void);
int gfx_get_video_format(void);
unsigned long gfx_get_video_src_size(void);
unsigned long gfx_get_video_line_size(void);
unsigned long gfx_get_video_xclip(void);
unsigned long gfx_get_video_offset(void);
unsigned long gfx_get_video_scale(void);
int gfx_get_video_downscale_config(unsigned short *type, unsigned short *m);
void gfx_get_video_downscale_coefficients(unsigned short *coef1, unsigned short *coef2,
										  unsigned short *coef3, unsigned short *coef4);
void gfx_get_video_downscale_enable(int *enable);									  

unsigned long gfx_get_video_dst_size(void);
unsigned long gfx_get_video_position(void);
unsigned long gfx_get_video_color_key(void);
unsigned long gfx_get_video_color_key_mask(void);
int gfx_get_video_color_key_src(void);
int gfx_get_video_filter(void);
int gfx_get_video_request(unsigned short *x, unsigned short *y);
int gfx_get_video_source(int *source);
int gfx_get_vbi_source(int *source);
unsigned long gfx_get_vbi_lines(int odd);
unsigned long gfx_get_vbi_total(int odd);
int gfx_get_video_interlaced(void);
int gfx_get_color_space_YUV(void);
unsigned long gfx_get_genlock_delay(void);
int gfx_get_genlock_enable(void);
int gfx_get_video_cursor(unsigned long *key, unsigned long *mask, unsigned short *select_color2,
						 unsigned long *color1, unsigned short *color2);

unsigned long gfx_read_crc(void);

void gfx_get_alpha_enable(int *enable);
void gfx_get_alpha_size(unsigned short *x, unsigned short *y, 
	unsigned short *width, unsigned short *height);
void gfx_get_alpha_value(unsigned char *alpha, char *delta);
void gfx_get_alpha_priority(int *priority);
void gfx_get_alpha_color(unsigned long *color);

/* ROUTINES IN GFX_VIP.C */

int gfx_set_vip_enable(int enable);
int gfx_set_vip_capture_run_mode(int mode); 
int gfx_set_vip_base(unsigned long even, unsigned long odd);
int gfx_set_vip_pitch(unsigned long pitch);
int gfx_set_vbi_enable(int enable);
int gfx_set_vbi_mode(int mode); 
int gfx_set_vbi_base(unsigned long even, unsigned long odd);
int gfx_set_vbi_pitch(unsigned long pitch);
int gfx_set_vbi_direct(unsigned long even_lines, unsigned long odd_lines); 
int gfx_set_vbi_interrupt(int enable); 

/* READ ROUTINES IN GFX_VIP.C */

int gfx_get_vip_enable(void);
unsigned long gfx_get_vip_base(int odd);
unsigned long gfx_get_vip_pitch(void);
int gfx_get_vip_mode(void); 
int gfx_get_vbi_enable(void);
int gfx_get_vbi_mode(void); 
unsigned long gfx_get_vbi_base(int odd);
unsigned long gfx_get_vbi_pitch(void);
unsigned long gfx_get_vbi_direct(int odd); 
int gfx_get_vbi_interrupt(void); 

/* ROUTINES IN GFX_DCDR.C */

int gfx_set_decoder_defaults(void);
int gfx_set_decoder_for_dvip(void); 
int gfx_set_decoder_analog_input(unsigned char input);
int gfx_set_decoder_brightness(unsigned char brightness);
int gfx_set_decoder_contrast(unsigned char contrast);
int gfx_set_decoder_hue(char hue);
int gfx_set_decoder_saturation(unsigned char saturation);
int gfx_set_decoder_input_offset(unsigned short x, unsigned short y);
int gfx_set_decoder_input_size(unsigned short width, unsigned short height);
int gfx_set_decoder_output_size(unsigned short width, unsigned short height);
int gfx_set_decoder_scale(unsigned short srcw, unsigned short srch, 
	unsigned short dstw, unsigned short dsth);
int gfx_set_decoder_vbi_format(int format);
int gfx_set_decoder_vbi_enable(int enable);
int gfx_decoder_software_reset(void);
int gfx_decoder_detect_macrovision(void);
int gfx_decoder_detect_video(void);

/* READ ROUTINES IN GFX_DCDR.C */

unsigned char gfx_get_decoder_brightness(void);
unsigned char gfx_get_decoder_contrast(void);
char gfx_get_decoder_hue(void);
unsigned char gfx_get_decoder_saturation(void);
unsigned long gfx_get_decoder_input_offset(void);
unsigned long gfx_get_decoder_input_size(void);
unsigned long gfx_get_decoder_output_size(void);
int gfx_get_decoder_vbi_format(int line);

/* ROUTINES IN GFX_I2C.C */

void gfx_i2c_reset(void);
int gfx_i2c_select_bus(int bus);
int gfx_i2c_select_gpio(int clock, int data);
int gfx_i2c_write(unsigned char chipadr, unsigned int subadr, 
	unsigned long data, unsigned int bytes);
int gfx_i2c_read(unsigned char chipadr, unsigned int subadr, 
	unsigned long *data, unsigned int bytes);
int gfx_i2c_write_multiple(unsigned char chipadr, unsigned char subadr, 
	unsigned char count, unsigned char *data);
int gfx_i2c_read_multiple(unsigned char chipadr, unsigned char subadr, 
	unsigned char count, unsigned char *data);
int gfx_i2c_init(void);
void gfx_i2c_cleanup(void);

/* ROUTINES IN GFX_TV.C */
int gfx_set_tv_format(int format, int resolution); 
int gfx_set_tv_output(int output); 
int gfx_set_tv_defaults(int format);
int gfx_set_tv_enable(int enable);
int gfx_set_tv_flicker_filter(int ff);
int gfx_set_tv_cc_enable(int enable);
int gfx_set_tv_cc_data(unsigned char data1, unsigned char data2);
int gfx_test_tvout_odd_field(void);
int gfx_test_tv_encoder_odd_field(void);

int gfx_get_tv_enable(unsigned int *p_on);
int gfx_get_tv_standard(unsigned long *p_standard);
int gfx_get_available_tv_standards(unsigned long *p_standards);
int gfx_set_tv_standard(unsigned long standard);
int gfx_get_tv_vga_mode(unsigned long *p_vga_mode);
int gfx_get_available_tv_vga_modes(unsigned long *p_vga_modes);
int gfx_set_tv_vga_mode(unsigned long vga_mode);
int gfx_get_tvout_mode(unsigned long *p_tvout_mode);
int gfx_set_tvout_mode(unsigned long tvout_mode);
int gfx_get_sharpness(int *p_sharpness);
int gfx_set_sharpness(int sharpness);
int gfx_get_flicker_filter(int *p_flicker);
int gfx_set_flicker_filter(int flicker);
int gfx_get_overscan(int *p_x, int *p_y);
int gfx_set_overscan(int x, int y);
int gfx_get_position(int *p_x, int *p_y);
int gfx_set_position(int x, int y);
int gfx_get_color(int *p_color);
int gfx_set_color(int color);
int gfx_get_brightness(int *p_brightness);
int gfx_set_brightness(int brightness);
int gfx_get_contrast(int *p_contrast);
int gfx_set_contrast(int constrast);
int gfx_get_yc_filter(unsigned int *p_yc_filter);
int gfx_set_yc_filter(unsigned int yc_filter);
int gfx_get_aps_trigger_bits(unsigned int *p_trigger_bits);
int gfx_set_aps_trigger_bits(unsigned int trigger_bits);

/* ROUTINES IN GFX_VGA.C */

int gfx_vga_test_pci(void);
unsigned char gfx_vga_get_pci_command(void);
int gfx_vga_set_pci_command(unsigned char command);
int gfx_vga_seq_reset(int reset);
int gfx_vga_set_graphics_bits(void);
int gfx_vga_mode(gfx_vga_struct *vga, int xres, int yres, int bpp, int hz);
int gfx_vga_pitch(gfx_vga_struct *vga, unsigned short pitch);
int gfx_vga_save(gfx_vga_struct *vga, int flags);
int gfx_vga_restore(gfx_vga_struct *vga, int flags);
int gfx_vga_mode_switch(int active);
void gfx_vga_clear_extended(void);

/* CLOSE BRACKET FOR C++ COMPLILATION */

#ifdef __cplusplus
}
#endif

/* END OF FILE */



