{{$DEFINE DEBUG}

program patch704;
{

Patches a DOS boot sector (floppy or hard disk) to force the end of
system memory from 640K to 704K.  You probably do not want to do this.
Consult the included readme.txt for more info and disclaimer.

20201022, trixter@oldskool.org
}

const
  JMPSHORT=$EB;
  JMPDIRECT=$E9;
  NOOP=$90;
  patchsize=13;
  patch:array[0..patchsize-1] of byte=(

(*
; asm snippet that illustrates the 704k MBR patch code
org 0

        db      00                      ;so prior string will terminate
        xor     ax,ax
        mov     ds,ax
        mov     byte ptr [0413],0c0h    ;force 02c0h (704)
                                        ;Don't ADD here because system will
                                        ;get trashed if user warm-reboots.
        jmp     01234h                  ;will be fixed during patching
*)

  $00,
  $33,$C0,                      {XOR AX,AX}
  $8E,$D8,                      {MOV DS,AX}
  $C6,$06,$13,$04,$C0,          {MOV BYTE PTR [0413],C0}
  $E9,$27,$12                   {JMP xxxx}
);

var
  buf:array[0..512-1] of byte;
  idx:word;
  str:string;
  asciiPos,asciiLastPos:word;
  asciiLen,asciiLastLen:byte;

  oldJMP,newJMP:integer;
  si:shortint;
  i:integer;
  drive:byte;
  status:byte;
  side:byte;

Function ReadKeyChar:Char; Assembler;
Asm
  xor ah,ah
  int 16h
  cmp al,0
  jne @endit
  mov al,ah
@endit:
end;

procedure fatal(s:string);
begin
  writeln('A fatal error has been encountered:');
  writeln(s);
  halt(1);
end;

begin
  writeln(#13#10'PATCH704 patches a DOS boot sector to force 704K.');
  writeln('Don''t do this unless you know why this should be done.');
  write('This program is interactive.  Continue? (Y/N) ');
  if upcase(readkeychar) <> 'Y' then halt(1);

  {ask user for drive letter}
  write(#13#10'Drive to patch? (A: or B: floppy, C: or later hard drive) ' );
  readln(str);
  side:=0;
  drive:=ord(upcase(str[1]))-65;
  if drive>1 then begin
    drive:=drive-2+$80;
    side:=1;
  end;

  {read boot sector}
  asm
        {reset disk system}
        mov     ah,0
        mov     dl,drive
        int     13h

        {read first sector}

        mov     ah,02           {read sector}
        mov     al,1            {number of sectors}
        mov     ch,0            {cylinder}
        mov     cl,1            {sector}
        mov     dh,side         {head}
        mov     dl,drive
        push    ds
        pop     es
        mov     bx,offset buf
        int     13h
        lahf
        and     ah,00000001b
        mov     status,ah
  end;
  if status<>0
    then fatal('Boot sector read was not successful');

  {search for JMP at beginning and record abs loc where it initially goes}
  case buf[0] of
    JMPSHORT:if buf[2]<>NOOP
      then fatal('Short jump left no space for patching')
      else oldJMP:=buf[1] + 2;
    JMPDIRECT:if buf[3]<>NOOP
      then fatal('Direct jump left no space for patching')
      else oldJMP:=(buf[1] OR (buf[2] SHL 8)) + 3;
  else
    fatal('First opcode is not a JMP');
  end;

  {search for largest ASCII we can use to store patch in}
  asciiLen:=0; asciiLastLen:=0; str:='';
  for idx:={3e} $100 to 511-2 {55AA} do begin
    case char(buf[idx]) of
      #32..#127:begin
        if asciiLen=0 then asciiPos:=idx;
        inc(asciiLen);
        {str:=str+char(buf[idx]);}
      end;
    else
      begin
        if asciiLen>asciiLastLen then begin
          asciiLastLen:=asciiLen;
          asciiLastPos:=asciiPos;
        end;
        asciiLen:=0;
        {str:=''}
      end;
    end; {case}
  end;
  if asciiLastLen<16 then fatal('Couldn''t find an ASCII string large enough for the patch');
  str[0]:=chr(asciiLastLen);
  move(buf[asciiLastPos],str[1],asciiLastLen);
  writeln('Found a string we can use:');
  writeln('"',str,'"');
  {$IFNDEF DEBUG}
  writeln('String will be truncated to store our patch, looking like this:');
  dec(byte(str[0]),patchsize);
  writeln('"',str,'"');
  {$ENDIF}

  {insert patch into ASCII}
  {$IFDEF DEBUG}
  asciiPos:=asciiLastPos;
  {$ELSE}
  asciiPos:=asciiLastPos+asciiLastLen-patchsize;
  {$ENDIF}
  move(patch,buf[asciiPos],patchsize);

  {alter patch's JMP to go to original JMP}
  newJMP:=oldJMP-(asciiPOS+patchsize-3);
  {code a direct jump no matter how long -- I am not an assembler!}
  buf[asciiPOS+patchsize-3]:=JMPDIRECT;
  buf[asciiPOS+patchsize-2]:=lo(newJMP-3);
  buf[asciiPOS+patchsize-1]:=hi(newJMP-3);

  {patch initial jump to go to our code}
  newJMP:=asciiPOS+1; {+1 to skip over DB 00}
  buf[0]:=JMPDIRECT;
  buf[1]:=lo(newJMP-3);
  buf[2]:=hi(newJMP-3);

  {write boot sector to disk after user confirmation}
  write('Ready to write boot sector.  Continue? (Y/N) ');
  if upcase(readkeychar) <> 'Y' then halt(1);
  asm
        {reset disk system}
        mov     ah,0
        mov     dl,drive
        int     13h

        {write first sector}
        mov     ah,03           {write sector}
        mov     al,1            {number of sectors}
        mov     ch,0            {cylinder}
        mov     cl,1            {sector}
        mov     dh,side         {head}
        mov     dl,drive
        push    ds
        pop     es
        mov     bx,offset buf
        {$IFNDEF DEBUG}
        int     13h
        {$ENDIF}
        lahf
        and     ah,00000001b
        mov     status,ah
  end;

  if status<>0
    then fatal('Boot sector write was not successful')
    else writeln(#13#10'Boot sector written.');
end.
