#include "script.h"
// script.cpp is the file used to form actor scripts.
// following are the defined commands.

scriptNode::scriptNode(byte icommand, int ix, int iy, int isquareX, int isquareY)
{
  command = icommand;
  mapX = ix;
  mapY = iy;
  squareX = isquareX;
  squareY = isquareY;
}
void script::advanceLine()
{
  if (thisLine != NULL)
    thisLine = thisLine->nextLine;
}

void script::addLine(byte command, int mapX, int mapY, int squareX, int squareY)
{
  if (firstLine == NULL)
    firstLine = thisLine = lastLine = new scriptNode(command, mapX, mapY, squareX, squareY);
  else
    {
    lastLine->nextLine = new scriptNode(command, mapX, mapY, squareX, squareY);
    lastLine = lastLine->nextLine;
    }
  lastLine->nextLine = NULL;
}

void script::addCommand(scriptNode::scriptCommand command, int mapX, int mapY, int squareX, int squareY)
{
  switch(command)
  {
    case scriptNode::doNothing   :
    case scriptNode::turn        :
    case scriptNode::fineMoveRel :  addLine(command, mapX, mapY, squareX, squareY); break;
    case scriptNode::fineSlide   :  for (int counter = 0; counter < mapX; ++counter)
				      addLine(scriptNode::fineMoveRel, 0,0, squareX/mapX, squareY/mapX); break;
  }
}