# include <stdio.h>
# include <conio.h>
# include "sound.h"
# include "drecord.h"
# include "dgetbuf.h"
# include "csrbase.h"
# include "csrcmps.h"

extern	JoyWasLoaded;
/*
 *	This routine records a sound into the memory allocated by
 *	set_up_buffers().
 */

# ifdef __STDC__
void do_record_sound(void)
# else
void do_record_sound()
# endif
{
	int     i;
	int     prompted = 0;
	MSGBOX  msg;
	EVENT   event;


	/* set up for recording */
	snd_cue(TORECORD);

  	/* prompt the operator and wait for response */
	msg.pString = "Record";
	msg.pMessage = "Press Enter to start recording.";
	msg.btn_combo = MSG_COMBO_OK;
	msg_run( &msg );

	/* Disable the busy icon during recording */
	vid_busy_disable();

	/* clear out recording buffers */
	for (i=0; i<numbuffers; i++) {
		sndstructs[i]->sndlen = (u_long)0;
	}
	/* for each buffer */
	for (i = 0; i < numbuffers; i++)
	{
		/*
		 * maxtime = 0 means "record until buffer fills up"
		 * rate = R11000; use 11,000 samples/second
		 */
		do
		{
			/* first pass through loop, give instructions */
			if (prompted == 0)
			{
				msg.pMessage = "Press Enter to stop recording.";
				msg_draw( &msg );
				prompted = 1;
			}

			/* Check for keyboard input, which is considered a */
			/* request to stop recording */
			event_scan( &event );

  			if ( event.msg != EVENT_NULL )
			{
				/* stop recording */
				snd_stop((SNDHDR far *) 0);

				vid_move_cursor(0, 4 * CHAR_YEXT);
				vid_clear_to_bot();

				event_purge();

				/* Reenable the busy icon */
				vid_busy_enable();
				return;
			}
		} while (snd_record(sndstructs[i], 0, R11000,
			(u_char far *) NULL, FALSE) == WOULDBLOCK);
	}

	snd_wait((SNDHDR far *) 0, (short) 1);
	/* wait for recording to finish */

	/* clear the screen */
	vid_move_cursor(0, 4 * CHAR_YEXT);
	vid_clear_to_bot();

	/* Reenable the busy icon */
	vid_busy_enable();

	msg.pMessage = "Recording stopped - buffer full.";
	msg_run( &msg );
	return;
}
