.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_FILE_RECORD PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_FILE_RECORD troff documentation \- Version 1(6) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.de IW
.if t  .in +1.5i
.if n  .in +1.8i
..
.de OW
.if t  .in -1.5i
.if n  .in -1.8i
..
.de TW
.if t  .ti -1.5i
.if n  .ti -1.8i
..
.SH Name
.br
snd_file_record \- Records sounds directly to a file on a hard disk drive.

.SH Syntax
.br
\fBshort far snd_file_record(handle, rate, options, adj_table, length, silence_len, threshold, compression);\fR
.br
.B FILE handle;
.br
.B unsigned short rate;
.br
.B unsigned short options;
.br
.B unsigned char far *adj_table;
.br
.B unsigned short length;
.br
.B unsigned short silence_len;
.br
.B unsigned short threshold;
.br
.B unsigned short compression;
.br

.SH Description
\fISnd_file_record\fR accepts the handle to an already-opened file and
begins recording audio and storing the data in that file.  The sampling
rate to be used is specified by the \fIrate\fR parameter.

The caller is responsible for opening the sound file and passing a
\fIhandle\fR to \fIsnd_file_record\fR.  The file must be writable and
positioned to the first byte of the file, just as the file would be
when first opened.  Any existing contents will be overwritten.

The recording process begins with \fIsnd_file_record\fR writing a header
to the file.
Some fields of the file header are left blank and will be filled-in when 
the recording process ends.  An incomplete file cannot be played
regardless of how much data it contains.

Once the recorder starts, \fIsnd_file_record\fR will return to
the caller and the recording process will continue until the maximum
recording time (if specified) is reached, \fIsnd_stop\fR(PSSJ) or
\fIsnd_exit\fR(PSSJ) are called, or a disk error occurs, including a
disk full error.  \fISnd_file_record\fR continues to run in the
background, leaving the calling program free to perform other activities.
There are restrictions as to what other things can be done at the same time.
See the Notes and the Restrictions sections, below.

While recording, \fIsnd_wait\fR(PSSJ) can be called to
determine how many seconds of audio have been recorded.
(See \fIsnd_wait\fR(PSSJ) for more information.)

\fIAdj_table\fR points to a translation table that will be used on each
sample that is recorded.  It is identical to the table filled in by such
functions as \fIsnd_amplify\fR(PSSJ).  The table should be filled in by
calling \fIsnd_compensate\fR(PSSJ) before recording begins.  If this
translation is not desired, call \fIsnd_record\fR with \fIadj_table\fR
equal to "(unsigned char far *)\fBNULL\fR".

When \fIthreshold\fR is non-zero, it enables a mode where the recorder
will only record when the sound amplitude exceeds the specified value.
When the sound amplitude drops below and remains below the specified level,
the recorder will continue to "listen" but will not save the
digital data for these quiet periods.  Any single sample that exceeds the
threshold will cause sound data storing to resume, which will include
the sample that caused "recording" to resume.  The \fIthreshold\fR must be
a value between 0x0001 and 0x007e.  0x0000 disables this feature.

The \fIsilence_len\fR parameter informs the recorder as to how long it
should wait after sound levels fall below the \fIthreshold\fR before the
recording process is suspended.  This allows you to avoid "deleting" the
breaks between words or syllables in normal conversation.  \fISilence_len\fR
is specified in 100 msec intervals.  If \fIsilence_len\fR is zero
and the \fIthreshold\fR parameter is non-zero, a default minimum will be
enforced.

The combination of the \fIthreshold\fR and \fIsilence_len\fR parameters
allow you to emulate the actions of a voice-activated recorder (also
known as VOX), which will result in smaller recordings.  

The \fIoptions\fR parameter controls operation of the recorder.  The
following bits are defined.  

.IW
.TW
\fBCLOSEFILE\fR         If specified, the file will be closed by the recorder when
it stops recording the file.  By default, the caller is responsible
for closing the file after the recorder has completed making a recording. 
The file header is updated by \fIsnd_file_record\fR regardless of the setting
of this flag.
.br
.TW
\fBRECORDLENGTH\fR      If specified, an upper limit is placed on the recording
time by the \fIlength\fR parameter.  Otherwise, \fIlength\fR is ignored
and recording must be stopped by \fIsnd_stop\fR(PSSJ) or an error.
.br
.TW
.if t \fBVOXSTARTOFF\fR If thresholding is enabled, this flag tells
.if n \fBVOXSTARTOFF\fR         If thresholding is enabled, this flag tells
the recorder to begin recording after sounds are detected.  The default
for thresholding is to start recording immediately.  \fBVOXSTARTOFF\fR
eliminates silence between the start of the recording and the first sound.
.br
.OW

All others bits in \fIoptions\fR are reserved and must be set to zero.

.SH Notes
\fISnd_file_record\fR uses buffers that were allocated by the caller and
provided to the library functions via the \fIsnd_addbuf\fR(PSSJ) call.
For reliable operation on a 8MHz 286 system (1000TL) at 22KHz sampling
rates, at least 25 buffers (about 56K) should be provided.  The number of
buffers suggested for 5.5KHz sampling is 15 buffers.  On slower systems
(1000SL), slow disk drives, high disk fragmentation, high sampling rates, or
excessive foreground activity, the number of buffers should be increased.
Having insufficient buffers is indicated by periods of missing sound or
"hiccups" in the recordings that are made.  Faster (386/486) systems and
faster hard disk drives can use fewer buffers.

\fISnd_file_record\fR creates files that have the PSSJ Digital Sound
Toolkit header.  This header is also compatible with files
created by the Deskmate Sound Editor (1990 versions and later).
Files containing this header can be played using \fIsnd_file_play\fR(PSSJ).
Converting this file format to other audio file formats is trivial.

\fISnd_file_record\fR will stop recording if any error is returned by
MS-DOS in response to a disk I/O request.  The "Abort, Retry or Ignore"
message or any other text will not be displayed if an error occurs.

Thresholding should be used with \fIadj_table\fR pointing at a table
created by \fIsnd_compensate\fR(PSSJ), particularly
when low threshold values are selected.  (See \fIsnd_compensate\fR(PSSJ) for
more information.)  If the hardware centerline is not adjusted, thresholding
may not work as expected.

When recording resumes after a period of silence, some silence may be
included in front of the first sample that exceeds the value \fIthreshold\fR.
The amount of "silence" will never exceed 2,100 samples.

As of this release, the \fIcompression\fR field is not examined but should
be set to zero for future compatibility.  Its intended function is to
specify the compression type, with 0 being equal to No Compression.
.if n .sp
.if t .bp
.SH Storage Media Restrictions
(The following statements assume that the slower PSSJ-equipped systems
are to be supported, such as the 1000TL or the 1000SL.  Some of the
issues are not applicable on 386 and 486 systems.)

\fISnd_file_record\fR cannot be used to write files that are to be located
on floppy disk drives.  The continuous data transfer rates of most floppy
systems are not high enough.  This is regardless of the CPU speed.

All hard disk drives, hard cards, CD-ROM and Iomega drives can all be
used at sampling rates of 5.5Khz and 11Khz.  Extremely fragmented
filesystems may affect recording and playback quality, so this should be
avoided. 

22Khz can be used from disk only with drives with good seek times
(35 milliseconds or better) and low fragmentation.  (If the drive has the
capability to perform DMA or CPU data transfers and you are on a 286-based
or faster system, select CPU data transfer as it is usually faster under DOS.)

.SH Concurrency Restrictions
The activities you can perform while a recording is in process are limited
by these rules:

.IN
.TI
(1)     Never leave interrupts disabled for more than three milliseconds
at a time.  Longer periods will cause fragments of the sound
to be lost from the recording.  (If you disable interrupts
and then make DOS or BIOS calls, you may inadvertently
leave interrupts disabled too long, so watch for this.)  For
example, a program that waits for a vertical sync period to occur so
it can reprogram video registers can have to wait up to 20 msec and
must avoid disabling interrupts.

.TI
(2)     Interrupt-driven (background) printing (on IRQ7) may not be
performed.  The PSSJ chip uses IRQ7 for both audio and printing
functions.

.TI
(3)     The PSSJ chip uses DMA channel 1, so no other adapter card can
use this channel while audio operations are being performed.  

.TI
(4)     The file handle specified in the \fIsnd_file_record\fR call must
not be used by the calling program while \fIsnd_file_record\fR
is still active.

.TI
(5)     The calling program should not exit before the PSSJ digital sound
toolkit recorder completes its activities.  If you want a program to record
audio and for the recording to continue after that program exits, a TSR
that contains the toolkit code should be used to record the sound and
the main program should pass commands to the TSR.  (The \fBCLOSEFILE\fR
option is useful in TSRs.)  As soon as control returns to the program
that called the TSR, the main program may exit and the TSR will remain
in memory.  The TSR can be removed from memory only after a
\fIsnd_exit\fR(PSSJ) call is made.
(The PSP region describing the open file and the PSSJ digital sound
toolkit code must remain intact in RAM while it is recording audio as it
contains numerous interrupt service routines that are active.)

.TI
(6)     Simultaneous disk I/O to any device can impact recording
performance.  To a certain extent this can be prevented by
allocating additional buffers for the recorder to use.
The speed of the CPU and access time of the
drives involved will directly affect this situation.
.if n .bp
.if t .bp
.TI
(7)     Some DOS calls for keyboard activity wait inside MS-DOS until
a key is pressed before returning.  These calls also forbid
disk I/O to occur in background while waiting for a key to be
pressed.  Using these calls while \fIsnd_file_record\fR is being
used will cause the recording to be interrupted.  (These same
calls also cause spooled printing to pause.)  Since high-level
languages like "C" may make these calls to perform certain
functions, it may be difficult to determine if
you are using these DOS calls without trying the program
out first.
.br
With some DOS C compilers, the \fIgetch\fR(S) function blocks disk I/O
and has to be avoided.

.TI
(8)     On 1000 SL, SL/2, TL, TL/2 systems and other systems with
enhanced (16 color PCJr) CGA video, the last 128K of RAM should not be
used for toolkit code or for the buffers that you allocate for the
toolkit's use.  This memory is actually dual-ported video memory
(not all of this memory is used for video all the time) and may have
up to 12 wait states on each access, depending on the current video mode.
The recorder may be unable to operate at higher sampling rates if
it has to use this memory.
.OU

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID There are several causes for this error:
.br
.IN
.TI
1.      The Player or Recorder is active.
.br
.TI
2.      Not enough buffers provided to \fIsnd_addbuf\fR(PSSJ).
.br
.TI
3.      Sound file could not be read.
.br
.TI
4.      Sound file header contained errors or requested unsupported functions.
.br
.OU
.OZ

.SH See Also
snd_wait(PSSJ), snd_stop(PSSJ), snd_exit(PSSJ), snd_file_play(PSSJ)

.SH Credit
\fISnd_file_record\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410186

