/*-----------------------------------------------------------------------------
	Do_record_sound -
			Instructs the sound toolkit to record sounds and place
			the digitized data in the memory that was allocated by
			set_up_buffers().
			2-Jul-94

			The recording is made at a sampling rate of 11 KHz. 
			The sound toolkit also compensates for any centerline
			errors in the hardware while the recording is being
			made.  The recorder is also instructed to record when
			sounds are present.  Long periods of silence are
			omitted from the recording.

			This function is used by demo1 and demo2.  Please
			refer to DEMO1.C and DEMO2.C for more information.

	DRECORD is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include "sound.h"
#include "drecord.h"
#include "dgetbuf.h"
#include "dtime.h"

#ifdef __STDC__
void do_record_sound(int threshold,int length)
#else
void do_record_sound()
	int	threshold;
	int	length;
#endif
{
	int	i;			/*Loop variable*/
	char	compensate_tab[256];	/*Array for sound compensation*/

	snd_cue(TORECORD);		/*Set up for recording */

/* prompt the operator and wait for response */

	printf("Press ENTER to perform calibration.  There must be no sound");
	printf(" input while\n");
	printf("the calibration is performed.\n");

	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

	snd_compensate(compensate_tab);	/*Generate the table that will be
					  used to perform adjustments*/


	printf("Press ENTER to start recording\n");

	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

	if (threshold) {
		printf("Note: Periods of silence longer than .%d",length);
		printf(" seconds will suspend recording.\n");
	}
	printf("Press any key to stop recording\n");
	printf("      Seconds of sound recorded\r");

	for (i = 0; i < numbuffers; i++) {	/*For each buffer */
		do {
			if (kbhit()) {	/*If a key is pressed, stop recording*/
				snd_stop(0,0);	/*Stop recording now*/
				getch();	/*Read and discard character*/

				printf("\nRecording stopped by operator\n");
				return;
			}
			show_time();	/*Display elapsed recording time*/

/*	Finally, we issue the call that causes the sound toolkit to
	start recording or continue recording. 
*/
	
		} while (snd_record(sndstructs[i],	/*SOUND structure*/
			 	    0,			/*Fill entire buffer*/
			 	    R11000, 		/*11,000 samples/sec*/
				    compensate_tab,	/*Compensate table*/
				    FALSE,		/*If buffer is not yet
						 	 needed, return err*/
				    0,			/*Double buffering ok*/
				    threshold,		/*How loud a sound has
							  to be considered
							  non-silence*/
				    length) ==		/*Amount of silence
							  that is kept before
							  pausing recorder*/
			  WOULDBLOCK);			/*Re-use buffer*/
	}

	while(show_time()) ;		/*Returns 0 when recording ends*/

	printf("\nRecording stopped - buffers full\n");
	return;
}

