; TESTLOAD.ASM
;
; This program tests RAM on the Memory Plus Expansion card on the 1000HX.
; This card has either 128k RAM or 384k RAM onboard, in either case
; starting at 0.  Memory is saved and tested 16 bytes (1 paragraph) at a
; time, using various bit patterns.
;
; This is part 1 of a 2-part program:  This part, the loader, detects how
; much memory is on the card, then loads the actual testing routine into
; "safe" motherboard RAM above the expansion card RAM.
;

CODE	SEGMENT PUBLIC	
	ASSUME	CS:CODE;DS:CODE;SS:CODE
	ORG	100H
MAIN	PROC	FAR
	JMP	STARTUP
	;
	; Data.
	;
STARTSEG	DW	?
TESTMEM		DB	"TESTMEM.BIN",0
HANDLE		DW	?
FILESIZE	DW	?

STARTUP:
	;
	; Get memory size - must be either 624 (640-16) or 368 (384-16).
	;
	INT	12h
	CMP	AX,624
	JNE	CARD_128K
	MOV	STARTSEG,6000h
	JMP	OPENTEST
CARD_128K:
	CMP	AX,368
	JNE	NOCARD
	MOV	STARTSEG,2000h
	JMP	OPENTEST
NOCARD:
	MOV	AH,9
	MOV	DX,OFFSET ERRMSG1
	INT	21h
	MOV	AX,4C01h
	INT	21h
	;
	; Open the file containing the testing routine.
	;
OPENTEST:
	LEA	DX,TESTMEM
	MOV	AX,3D00h
	INT	21h
	JNC	LOADTEST
	MOV	AH,9
	MOV	DX,OFFSET ERRMSG2
	INT	21h
	MOV	AX,4C02h
	INT	21h
	;
	; Seek to the end of the file to find out its size.
	;
LOADTEST:
	MOV	HANDLE,AX
	MOV	BX,AX
	MOV	AX,4202h
	XOR	DX,DX
	MOV	CX,DX
	INT	21h
	MOV	FILESIZE,AX
	MOV	BX,HANDLE
	MOV	AX,4200h
	XOR	DX,DX
	MOV	CX,DX
	INT	21h
	;
	; Read file into memory at the start of motherboard RAM.
	;
	MOV	AH,9
	MOV	DX,OFFSET LOADMSG
	INT	21h
	MOV	BX,HANDLE
	MOV	CX,FILESIZE
	MOV	AX,3F00h
	PUSH	DS
	MOV	DS,STARTSEG
	XOR	DX,DX
	INT	21h
	POP	DS
	;
	; Jump to the start of the memory test routine.
	;
	MOV	AH,9
	MOV	DX,OFFSET TESTMSG
	INT	21h
	CLI
	MOV	SS,STARTSEG	; SS:SP->end of segment at STARTSEG
	MOV	SP,2000h
	STI
	MOV	AX,STARTSEG
	MOV	DS,AX		; DS=ES=STARTSEG
	MOV	ES,AX
	MOV	[3],CS
	PUSH	AX		; CS:IP=STARTSEG:0
	XOR	AX,AX
	PUSH	AX
	RETF			; go there (never returns)
MAIN	ENDP
	;
	; User messages.
	;
ERRMSG1	DB	"Card not found or not 1000EX/HX.",0Ah,0Dh,"$"
ERRMSG2	DB	"Can't locate TESTMEM.BIN.",0Ah,0Dh,"$"
LOADMSG	DB	"Loading TESTMEM.BIN.",0Ah,0Dh,"$"
TESTMSG	DB	"Jumping to test code.",0Ah,0Dh,"$"
CODE	ENDS
	END	MAIN
