#!/usr/bin/perl

# Note that if you are using this in a multitasking system, you
# have to ensure that connections to pprd are serialised
# so that only one jd.pl is connected at a particular time.
# Exercise left to reader.

# edit this to the printer hostname
$them = 'printer';
$port = 9100;

open(STDIN, "$ARGV[0]") if $#ARGV >= 0;

require 'sys/socket.ph';

$sockaddr = 'S n a4 x8';
chop($hostname = `hostname`);

($name, $aliases, $proto) = getprotobyname('tcp');
($name, $aliases, $port) = getservbyname($port, 'tcp')
	unless $port =~ /^\d+$/;
($name, $aliases, $type, $len, $thisaddr) = gethostbyname($hostname);
($name, $aliases, $type, $len, $thataddr) = gethostbyname($them);

socket(S, &PF_INET, &SOCK_STREAM, $proto) || &errexit("socket: $!\n");

$this = pack($sockaddr, &AF_INET, 0, $thisaddr);
bind(S, $this) || &errexit("bind: $!\n");

$that = pack($sockaddr, &AF_INET, $port, $thataddr);
connect(S, $that) || &errexit("connect: $!\n");

select(S); $| = 1; select(STDOUT);

$buffer = '';
while (1)
{
	$nread = read(STDIN, $buffer, 1024);
	last if $nread == 0;
	&errexit("write: $!\n") unless
		defined($written = syswrite(S,$buffer,$nread));
}
close(S);
# hack to make sure server is ready before exiting and letting
# spooler send next job
socket(S, &PF_INET, &SOCK_STREAM, $proto) || &errexit("socket: $!\n");
bind(S, $this) || &errexit("bind: $!\n");
while (!connect(S, $that)) {
	close(S);
	sleep(5);
	socket(S, &PF_INET, &SOCK_STREAM, $proto) || &errexit("socket: $!\n");
	bind(S, $this) || &errexit("bind: $!\n");
}
close(S);
exit 0;

sub errexit
{
	print STDERR @_;
	exit 2;
}
