using System;
using System.ComponentModel;
using System.Runtime.Serialization;
using System.Collections;

namespace ComputerBuff.Controls.XPanel
{
	/// <summary>
	///		MenuItems collection class
	/// </summary>
	[Serializable,
	DefaultProperty("Item")]
	public class MenuItems : CollectionBase
	{
		/// <summary>
		///		Create a new MenuItems collection instance
		/// </summary>
		public MenuItems()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		/// <summary>
		///		Add a new MenuItem to the collection
		/// </summary>
		/// <param name="menuItem">MenuItem that you want to add</param>
		public void Add(MenuItem menuItem)
		{
			this.List.Add(menuItem);
		}

		/// <summary>
		///		Removes a MenuItem from the collection
		/// </summary>
		/// <param name="menuItem">MenuItem you want to remove</param>
		public void Remove(MenuItem menuItem)
		{
			this.List.Remove(menuItem);
		}

		/// <summary>
		///		Gets/Sets the MenuItem at the given index
		/// </summary>
		public MenuItem this[int index]
		{
			get
			{
				return (MenuItem)base.List[index];
			}

			set 
			{
				base.List[index] = value;
			}			
		}

		/// <summary>
		///		Returns the index for the given MenuItem within the collection
		/// </summary>
		/// <param name="menuItem">MenuItem that you want to find the index of</param>
		/// <returns>int - Index</returns>
		public int IndexOf(MenuItem menuItem)
		{
			return List.IndexOf(menuItem); 
		}
	}
}
