/*
 * Decompiled with CFR 0.152.
 */
package vx.apps.email;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import com.sun.mail.pop3.POP3Folder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import sun.misc.BASE64Decoder;
import vx.apps.email.EmailMessageReader;
import vx.server.VxApp;

public class EmailManager {
    private String readProto_ = null;
    private String readHost_ = null;
    private String readPort_ = null;
    private String readUser_ = null;
    private String readPassword_ = null;
    private String sendProto_ = null;
    private String sendHost_ = null;
    private String sendUser_ = null;
    private String sendPassword_ = null;
    private boolean useSocks_ = false;
    private String socksHost_ = null;
    private String socksPort_ = null;
    private ArrayList noSocksHosts_ = null;
    private String recordDir_ = null;
    private String notifyPhone_ = null;
    private ArrayList alertFroms_ = new ArrayList();
    private ArrayList alertTos_ = new ArrayList();
    private int newEmailCount_ = 0;
    private boolean isShareware_ = true;
    private AlertThread notifyThread_ = null;
    private long pollTime_ = 600000L;
    private AccessLock accessLock_ = new AccessLock();
    private Session conn_ = null;
    private Transport transport_ = null;
    private Store store_ = null;
    private Folder curFolder_ = null;
    private ArrayList messages_ = new ArrayList();
    private ArrayList oldUids_ = new ArrayList();
    private ArrayList deletedMessages_ = null;
    private ArrayList deliveredMessages_ = null;
    private Object synch_ = new Object();
    protected PrintStream log_ = System.out;
    protected String failedReason_ = null;
    static EmailManager instance_ = null;

    public EmailManager() {
        if (instance_ != null) {
            throw new RuntimeException();
        }
    }

    public static String getVxsid(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        String string = null;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equals("vxsid")) {
                    string = cookieArray[n].getValue();
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    public static EmailManager getInstance(HttpServletRequest httpServletRequest) {
        String string = EmailManager.getVxsid(httpServletRequest);
        if (!VxApp.checkSession((String)string)) {
            return null;
        }
        return instance_;
    }

    public void init(String string) throws IOException {
        Object object;
        String string2;
        this.log_.println("Init: " + string);
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("application direction does not exist: " + string);
        }
        this.log_ = new PrintStream(new FileOutputStream(new File(file, "../email.log")));
        File file2 = new File(file, "../work");
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.recordDir_ = file2.getAbsolutePath();
        Properties properties = new Properties();
        File file3 = new File(file, "emailsetup.conf");
        if (!file3.exists()) {
            this.log_.println("ERROR: email account has not been set up yet.");
            this.failedReason_ = "Email account not set up yet";
            return;
        }
        Object object2 = new FileInputStream(file3);
        properties.load((InputStream)object2);
        ((FileInputStream)object2).close();
        this.readProto_ = properties.getProperty("readproto");
        if (this.readProto_ == null) {
            this.readProto_ = "pop3";
        }
        this.readHost_ = properties.getProperty("readhost");
        if (this.readHost_ == null || this.readHost_.length() == 0) {
            this.log_.println("ERROR: POP host not defined.");
            this.failedReason_ = "POP host not defined";
            return;
        }
        this.readPort_ = properties.getProperty("readport");
        if (this.readPort_ == null) {
            this.readPort_ = "110";
        }
        this.readUser_ = properties.getProperty("readuser");
        if (this.readUser_ == null || this.readUser_.length() == 0) {
            this.log_.println("ERROR: email name not defined.");
            this.failedReason_ = "email name not defined";
            return;
        }
        object2 = properties.getProperty("readpassword");
        this.readPassword_ = object2 != null ? new String(new BASE64Decoder().decodeBuffer((String)object2)) : "";
        this.sendProto_ = properties.getProperty("sendproto");
        if (this.sendProto_ == null) {
            this.sendProto_ = "SMTP";
        }
        this.sendHost_ = properties.getProperty("sendhost");
        if (this.sendHost_ == null || this.sendHost_.length() == 0) {
            this.log_.println("ERROR: SMTP host not defined.");
            this.failedReason_ = "SMTP host not defined";
            return;
        }
        this.notifyPhone_ = properties.getProperty("aphone");
        String string3 = properties.getProperty("polltime");
        this.pollTime_ = string3 != null && string3.length() > 0 ? Long.parseLong(string3) * 60L * 1000L : 600000L;
        String string4 = properties.getProperty("alertfrom");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string4));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.length() <= 0) continue;
            this.alertFroms_.add(string2);
        }
        String string5 = properties.getProperty("alertto");
        bufferedReader = new BufferedReader(new StringReader(string5));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.length() <= 0) continue;
            this.alertTos_.add(string2);
        }
        this.socksHost_ = properties.getProperty("socksProxyHost");
        this.socksPort_ = properties.getProperty("socksProxyPort");
        this.noSocksHosts_ = new ArrayList();
        String string6 = properties.getProperty("noSocksProxyHosts");
        if (string6 != null) {
            object = new StringTokenizer(string6, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.noSocksHosts_.add(((StringTokenizer)object).nextToken());
            }
        }
        if (!this.noSocksHosts_.contains("localhost")) {
            this.noSocksHosts_.add("localhost");
        }
        if (this.socksHost_ != null && this.socksPort_ != null) {
            try {
                object = new Socket(this.socksHost_, Integer.parseInt(this.socksPort_));
                ((Socket)object).close();
                this.useSocks_ = true;
            }
            catch (Exception exception) {
                this.useSocks_ = false;
            }
        }
        instance_ = this;
        this.checkLicense();
    }

    public boolean download(boolean bl) {
        try {
            this.openDefaultFolder(bl);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log_);
            this.failedReason_ = exception.toString();
            return false;
        }
    }

    public void endSession() {
        try {
            this.closeDefaultFolder();
            this.closeStore();
            this.conn_ = null;
            this.transport_ = null;
            this.accessLock_.release();
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace(this.log_);
        }
    }

    public boolean startSession() {
        try {
            this.accessLock_.lock();
            this.failedReason_ = null;
            this.switchOnSocksProxy(this.sendHost_);
            Properties properties = System.getProperties();
            properties.setProperty("mail.smtp.host", this.sendHost_);
            this.conn_ = Session.getDefaultInstance((Properties)properties, null);
            this.deliveredMessages_ = new ArrayList();
            this.switchOffSocksProxy(this.sendHost_);
            this.openStore();
            return true;
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            authenticationFailedException.printStackTrace(this.log_);
            this.failedReason_ = "Authentication failed";
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace(this.log_);
            this.failedReason_ = "Cannot connect to the server";
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(this.log_);
            this.failedReason_ = throwable.toString();
        }
        return false;
    }

    protected void openStore() throws NoSuchProviderException, MessagingException {
        this.switchOnSocksProxy(this.readHost_);
        this.store_ = this.conn_.getStore(this.readProto_);
        int n = -1;
        if (this.readPort_ != null) {
            n = Integer.parseInt(this.readPort_);
        }
        this.store_.connect(this.readHost_, n, this.readUser_, this.readPassword_);
        this.switchOffSocksProxy(this.readHost_);
    }

    protected void closeStore() throws MessagingException {
        if (this.store_ != null) {
            this.store_.close();
            this.store_ = null;
        }
    }

    protected void openDefaultFolder(boolean bl) throws NoSuchProviderException, MessagingException {
        this.switchOnSocksProxy(this.readHost_);
        this.curFolder_ = this.store_.getFolder("INBOX");
        this.curFolder_.open(2);
        this.initDefaultFolder(bl);
        this.switchOffSocksProxy(this.readHost_);
    }

    public void closeDefaultFolder() throws MessagingException {
        if (this.curFolder_ != null) {
            this.curFolder_.close(true);
            this.curFolder_ = null;
        }
    }

    protected void initDefaultFolder(boolean bl) throws MessagingException {
        Message[] messageArray = this.curFolder_.getMessages();
        FetchProfile fetchProfile = new FetchProfile();
        fetchProfile.add(FetchProfile.Item.ENVELOPE);
        fetchProfile.add(FetchProfile.Item.FLAGS);
        this.curFolder_.fetch(messageArray, fetchProfile);
        if (this.readProto_.equals("pop3")) {
            POP3Folder pOP3Folder = (POP3Folder)this.curFolder_;
            int n = 0;
            while (n < this.messages_.size()) {
                String string = pOP3Folder.getUID((Message)this.messages_.get(n));
                this.oldUids_.add(string);
                ++n;
            }
            int n2 = this.oldUids_.size() - 1;
            while (n2 >= 0) {
                boolean bl2 = true;
                int n3 = 0;
                while (n3 < messageArray.length) {
                    String string = pOP3Folder.getUID(messageArray[n3]);
                    if (string.equals(this.oldUids_.get(n2))) {
                        bl2 = false;
                        break;
                    }
                    ++n3;
                }
                if (bl2) {
                    this.oldUids_.remove(n2);
                }
                --n2;
            }
        }
        this.messages_ = new ArrayList();
        this.deletedMessages_ = new ArrayList();
        int n = 0;
        while (n < messageArray.length) {
            Flags flags = messageArray[n].getFlags();
            if (this.readProto_.equals("pop3")) {
                if (!bl || this.isNewPop3Message((POP3Folder)this.curFolder_, messageArray[n])) {
                    this.messages_.add(messageArray[n]);
                }
            } else if (messageArray[n].isSet(Flags.Flag.RECENT)) {
                this.messages_.add(messageArray[n]);
            }
            ++n;
        }
    }

    public int totalMessages() {
        return this.messages_.size();
    }

    public Message read(int n) {
        return (Message)this.messages_.get(n);
    }

    public boolean delete(int n) {
        try {
            Message message = this.read(n);
            Message[] messageArray = new Message[]{message};
            message.setFlag(Flags.Flag.DELETED, true);
            this.deletedMessages_.add(message);
            this.messages_.remove(n);
            return true;
        }
        catch (MessagingException messagingException) {
            this.failedReason_ = messagingException.toString();
            messagingException.printStackTrace(this.log_);
            return false;
        }
    }

    public void delete(Message message) {
        int n = 0;
        while (n < this.messages_.size()) {
            if (message == this.read(n)) {
                this.delete(n);
                break;
            }
            ++n;
        }
    }

    public String getRecordDir() {
        return this.recordDir_;
    }

    public String getFailedReason() {
        return this.failedReason_;
    }

    public String getUserAddress() {
        return this.readUser_;
    }

    public int totalContacts() {
        return 0;
    }

    public String getContactName(int n) {
        return null;
    }

    public String getContactEmail(int n) {
        return null;
    }

    public String getContactEmail(String string) {
        return null;
    }

    public Message send(String string, String string2, String string3, String string4) throws AddressException, MessagingException {
        return this.send((Address[])InternetAddress.parse((String)string, (boolean)false), string2, string3, string4);
    }

    public Message send(Address[] addressArray, String string, String string2, String string3) throws AddressException, MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.conn_);
        mimeMessage.setFrom((Address)new InternetAddress(this.getUserAddress()));
        mimeMessage.setRecipients(Message.RecipientType.TO, addressArray);
        mimeMessage.setSubject(string);
        mimeMessage.setSentDate(new Date());
        if (string3 == null) {
            mimeMessage.setText(string2);
        } else {
            MimeMultipart mimeMultipart = new MimeMultipart();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string2);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            FileDataSource fileDataSource = new FileDataSource(string3);
            mimeBodyPart2.setDataHandler(new DataHandler((DataSource)fileDataSource));
            mimeBodyPart2.setFileName(fileDataSource.getName());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            mimeMessage.setContent((Multipart)mimeMultipart);
        }
        this.send((Message)mimeMessage);
        return mimeMessage;
    }

    public String includeMessage(Message message) throws IOException, MessagingException {
        EmailMessageReader emailMessageReader = new EmailMessageReader(message);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("----- Original Message -----\n");
        stringBuffer.append("From: " + emailMessageReader.getFrom() + "\n");
        stringBuffer.append("To: " + emailMessageReader.getRecipients() + "\n");
        stringBuffer.append("Sent: " + emailMessageReader.getDate() + "\n");
        stringBuffer.append("Subject: " + message.getSubject() + "\n\n");
        stringBuffer.append(emailMessageReader.includeContent() + "\n");
        return stringBuffer.toString();
    }

    public Message reply(String string, String string2, Message message) throws MessagingException, IOException {
        return this.send(message.getRecipients(Message.RecipientType.TO), "Re: " + message.getSubject(), string + "\n\n" + this.includeMessage(message), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForDeliver(Message message, long l) {
        long l2 = System.currentTimeMillis();
        while (!this.deliveredMessages_.contains(message)) {
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > l) {
                return false;
            }
            Object object = this.synch_;
            synchronized (object) {
                try {
                    this.synch_.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDelivered(TransportEvent transportEvent) {
        this.deliveredMessages_.add(transportEvent.getMessage());
        Object object = this.synch_;
        synchronized (object) {
            this.synch_.notifyAll();
        }
    }

    public void messageNotDelivered(TransportEvent transportEvent) {
    }

    public void messagePartiallyDelivered(TransportEvent transportEvent) {
    }

    private void send(Message message) throws MessagingException {
        this.switchOnSocksProxy(this.sendHost_);
        Transport.send((Message)message);
        this.switchOffSocksProxy(this.sendHost_);
    }

    private void switchOnSocksProxy(String string) {
        if (!this.useSocks_ || this.socksHost_ == null) {
            return;
        }
        if (this.noSocksHosts_.contains(string)) {
            return;
        }
        System.out.println("Turn on socks for host : " + string);
        Properties properties = System.getProperties();
        properties.setProperty("socksProxyHost", this.socksHost_);
        properties.setProperty("socksProxyPort", this.socksPort_);
        System.setProperties(properties);
    }

    private void switchOffSocksProxy(String string) {
        if (!this.useSocks_ || this.socksHost_ == null) {
            return;
        }
        if (this.noSocksHosts_.contains(string)) {
            return;
        }
        System.out.println("Turn off socks for host : " + string);
        Properties properties = System.getProperties();
        properties.remove("socksProxyHost");
        properties.remove("socksProxyPort");
        System.setProperties(properties);
    }

    private void checkLicense() {
        this.log_.println("Obtaining gateway license ...");
        String string = VxApp.getAppLicense((String)"AutoReminder", (String)"1.0");
        if (string.indexOf("[") == -1 || string.indexOf("]") == -1) {
            this.log_.println(string);
            return;
        }
        if (string.indexOf("FIRSTNAME=") == -1 || string.indexOf("LASTNAME=") == -1) {
            this.log_.println("Invalid license info");
            return;
        }
        int n = string.indexOf("LICENSE=");
        if (string.indexOf("standard", n + 8) != -1 || string.indexOf("professional", n + 8) != -1) {
            this.log_.println("License OK");
            this.isShareware_ = false;
            return;
        }
        this.log_.println("No Gateway license information. Assuming shareware version");
    }

    private void makeAlertCall() {
        try {
            this.log_.println("Making alert calls. Sending request to gateway...");
            NVPair[] nVPairArray = new NVPair[7];
            nVPairArray[0] = new NVPair("info", "New Email Alert Call");
            nVPairArray[1] = new NVPair("calltime", "0");
            nVPairArray[2] = new NVPair("firstocc", "30");
            nVPairArray[3] = new NVPair("phoneno", this.notifyPhone_);
            nVPairArray[4] = new NVPair("attendee", "<My Self>");
            nVPairArray[5] = new NVPair("selfdelete", "1");
            String string = "http://localhost:" + Integer.toString(VxApp.getPort());
            string = string + "/email/email_alert.jsp?newemail=" + this.newEmailCount_;
            nVPairArray[6] = new NVPair("starturl", string);
            HTTPConnection hTTPConnection = new HTTPConnection("localhost", VxApp.getPort());
            HTTPResponse hTTPResponse = hTTPConnection.Post("/ocall/callreqHandler.jsp", nVPairArray);
            if (hTTPResponse == null || hTTPResponse.getStatusCode() != 200) {
                this.log_.print("*** Failed: ");
                if (hTTPResponse != null) {
                    this.log_.println(hTTPResponse.getReasonLine());
                }
            } else {
                this.log_.println("Request Sent");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(this.log_);
        }
    }

    public synchronized String startAlertThread() {
        if (this.isShareware_) {
            return "Email Alert not available in shareware version";
        }
        if (this.notifyThread_ != null && !this.notifyThread_.isStopped()) {
            return "Alert has been turned on already.";
        }
        if (this.notifyPhone_ == null || this.notifyPhone_.length() == 0) {
            return "Alert phone number not defined.";
        }
        if (this.alertFroms_.size() == 0 && this.alertTos_.size() == 0) {
            return "No address is defined for alerts.";
        }
        if (this.notifyThread_ == null) {
            this.notifyThread_ = new AlertThread();
            this.notifyThread_.start();
        } else {
            this.notifyThread_.setStop(false);
        }
        return "Email Alert started";
    }

    public synchronized String stopAlertThread() {
        if (this.notifyThread_ == null || this.notifyThread_.isStopped()) {
            return "Alert has been turned off already";
        }
        this.notifyThread_.setStop(true);
        return "Alert is turned off";
    }

    public boolean isAlertStopped() {
        return this.notifyThread_ == null || this.notifyThread_.isStopped();
    }

    public synchronized void setAlertThread(AlertThread alertThread) {
        this.notifyThread_ = alertThread;
    }

    private boolean isNewPop3Message(POP3Folder pOP3Folder, Message message) throws MessagingException {
        String string = pOP3Folder.getUID(message);
        if (this.oldUids_.contains(string)) {
            return false;
        }
        int n = 0;
        while (n < this.oldUids_.size()) {
            if (string.equals(this.oldUids_.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            EmailManager emailManager = new EmailManager();
            emailManager.init("D:\\repo\\vg\\install-debug\\email\\conf");
            emailManager.isShareware_ = false;
            emailManager.startAlertThread();
            Thread.currentThread();
            Thread.sleep(1000000000L);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void printMessage(Message message, PrintStream printStream) throws MessagingException, IOException {
        EmailMessageReader emailMessageReader = new EmailMessageReader(message);
        printStream.println(emailMessageReader.getFrom());
        printStream.println(emailMessageReader.getRecipients());
        printStream.println(emailMessageReader.getDate());
        printStream.println(message.getSubject());
        printStream.println(emailMessageReader.getContent());
        printStream.println("Include files: " + Integer.toString(emailMessageReader.numIncludeFiles()));
        printStream.println("****************** structure ****************");
        EmailManager.printPart(emailMessageReader, (Part)message, printStream, 0);
    }

    public static void printPart(EmailMessageReader emailMessageReader, Part part, PrintStream printStream, int n) throws MessagingException, IOException {
        block5: {
            String string;
            block6: {
                block4: {
                    if (part == null) {
                        return;
                    }
                    printStream.println("Mime-Type: " + part.getContentType());
                    if (!EmailMessageReader.isMultipart(part)) break block4;
                    Multipart multipart = (Multipart)part.getContent();
                    int n2 = 0;
                    while (n2 < multipart.getCount()) {
                        EmailManager.printPart(emailMessageReader, (Part)multipart.getBodyPart(n2), printStream, n + 1);
                        ++n2;
                    }
                    break block5;
                }
                if (!EmailMessageReader.isWave(part)) break block6;
                EmailManager.printIndentation(printStream, n);
                printStream.println("======== Attached Wave File ========");
                EmailManager.printIndentation(printStream, n);
                printStream.println("File name: " + part.getFileName());
                break block5;
            }
            if (!EmailMessageReader.isText(part)) break block5;
            if (part.getFileName() != null) {
                EmailManager.printIndentation(printStream, n);
                printStream.println("-------- Attached Text File --------");
                EmailManager.printIndentation(printStream, n);
                printStream.println("File name: " + part.getFileName());
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader((String)part.getContent()));
            while ((string = bufferedReader.readLine()) != null) {
                EmailManager.printIndentation(printStream, n);
                printStream.println(string);
            }
        }
    }

    public static void printIndentation(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print(">");
            ++n2;
        }
    }

    static /* synthetic */ int access$002(EmailManager emailManager, int n) {
        emailManager.newEmailCount_ = n;
        return emailManager.newEmailCount_;
    }

    static /* synthetic */ int access$000(EmailManager emailManager) {
        return emailManager.newEmailCount_;
    }

    static /* synthetic */ ArrayList access$100(EmailManager emailManager) {
        return emailManager.alertFroms_;
    }

    static /* synthetic */ ArrayList access$200(EmailManager emailManager) {
        return emailManager.alertTos_;
    }

    static /* synthetic */ void access$300(EmailManager emailManager) {
        emailManager.makeAlertCall();
    }

    static /* synthetic */ long access$400(EmailManager emailManager) {
        return emailManager.pollTime_;
    }

    class AlertThread
    extends Thread {
        private boolean isStop_ = false;

        AlertThread() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public synchronized void setStop(boolean bl) {
            this.isStop_ = bl;
        }

        public synchronized boolean isStopped() {
            return this.isStop_;
        }
    }

    class AccessLock {
        private boolean isLocked_ = false;

        AccessLock() {
        }

        public synchronized void lock() {
            if (this.isLocked_) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isLocked_ = true;
        }

        public synchronized void release() {
            this.isLocked_ = false;
            this.notifyAll();
        }
    }
}

