<?php
//============================================================+
// File name   : cp_config.php                                 
// Begin       : 2002-02-24                                    
// Last Update : 2003-04-02                                    
//                                                             
// Description : SHARED cofiguration file                      
//                                                             
//                                                             
// Author: Nicola Asuni                                        
//                                                             
// (c) Copyright:                                              
//               Tecnick.com S.r.l.                            
//               Via Ugo Foscolo n.19                          
//               09045 Quartu Sant'Elena (CA)                  
//               ITALY                                         
//               www.tecnick.com                               
//               info@tecnick.com                              
//============================================================+

// -- INCLUDE files -- 
require_once('../../shared/config/cp_extension.inc');
require_once('../../shared/config/cp_paths.'.CP_EXT);
require_once('../../shared/config/cp_general_constants.'.CP_EXT);
require_once('../../shared/config/cp_ecommerce.'.CP_EXT);

// -- Options / COSTANTS --
define ("K_AIOCP_VERSION", "1.0"); // DO NOT CHANGE : program version

define ("K_SESSION_LIFE", K_SECONDS_IN_HOUR); //user session life time in seconds (without actions)
define ("K_SHOPPING_CART_LIFE", K_SECONDS_IN_DAY); //max shopping cart entry life time in seconds
define ("K_CHAT_REFRESH_TIME", 20); // chat default refresh time in seconds
define ("K_CHAT_LIVE_TIME", 600); //seconds of live time for a chat message
define ("K_CHAT_USER_LIVE_TIME", 90); //seconds of live time for a chat user
define ("K_MAX_WAIT_VERIFICATION", 15); //max number of days to wait user verification (after registration request)

define ("K_BAD_WORD_CENSOR", TRUE); //enable bad word censor

define ("K_SHOW_LANG_FLAGS", true); //if true display flags for language selection from F_choose_page_language(). Flags URL must be defined on x_flag language template.

define ("K_AUTH_MIN_MODERATOR_LEVEL", 5); //Minimum level to be a Forum Moderator
define ("K_AUTH_EDIT_USER_LEVEL", 10); //Minimum user level that may access to user editor
define ("K_AUTH_EDIT_PRODUCTS_LEVEL", 10); //Minimum user level that may access to product editor
define ("K_AUTH_BANNER_STATS_LEVEL", 10); //Minimum user level that may access to banner stats
define ("K_AUTH_EDIT_PAGES_LEVEL", 10); //Minimum user level that could see the edit link on public pages

//images settings
define ("K_USE_GD2", true); //set to true if you are using GD2 graphic library (enable true colors for generated images)
define ("K_MAX_USER_IMAGE_SIZE", 500000); //max size for user image in bytes
define ("K_USER_IMAGE_HEIGHT", 100); //height for user image in pixel
define ("K_USER_IMAGE_WIDTH", 100); //width for user image in pixel
define ("K_PRODUCT_IMAGE_HEIGHT", 100); //height for product small image in pixel
define ("K_PRODUCT_IMAGE_WIDTH", 100); //width for product small image in pixel
define ("K_MANUFACTURER_IMAGE_HEIGHT", 100); //height for manufacturer logo in pixel
define ("K_MANUFACTURER_IMAGE_WIDTH", 100); //width for manufacturer logo in pixel
define ("K_BLANK_IMAGE", "_blank.png"); //default blank image
//defaul background color for generated thumbnails
define ("K_IMAGE_BACKGROUND_R", 255); // red value of background color (0-255)
define ("K_IMAGE_BACKGROUND_G", 255); // green value of background color (0-255)
define ("K_IMAGE_BACKGROUND_B", 255); // blue value of background color (0-255)

// Client Cookie settings
define ("K_COOKIE_DOMAIN", "");
define ("K_COOKIE_PATH", K_PATH_AIOCP);
define ("K_COOKIE_SECURE", FALSE); 
define ("K_COOKIE_EXPIRE", K_SECONDS_IN_YEAR); //cookie expire time (one year)

define ("K_PASSWORD_LENGTH", 8); //default user password length (for genenerated passwords)

error_reporting  (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
set_magic_quotes_runtime(0); //disable magic quotes

global $selected_language;

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
