#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjMult.cgi - Change list of Topics for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/27 22:21:26 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjMult.cgi,v 1.26.2.4 2001/09/27 22:21:26 stepper Exp $';
$Version = '1.4.0';

if ($ARGV[0] eq "-v" || $ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";

$Class = $CGIQuery->param('fid');
@Subject = $CGIQuery->param('tid');
$newsubject = $CGIQuery->param('newsubject');
$func = $CGIQuery->param('func');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if (@Subject == 1 && $Subject[0] eq "") {
	splice(@Subject, 0);
}

$Subject = "";
for ($i=0; $i < @Subject; $i++) {
	if ($Subject[$i] eq "(NEW_SUBJECT)") {
		$Subject = "(NEW_SUBJECT)";
	}
}

if ($Subject eq "(NEW_SUBJECT)") {
	splice(@Subject, 0);
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "showedit" && (@Subject > 0 || $Subject eq "(NEW_SUBJECT)" || $newsubject ne "")) {
	# Class and subject chosen, print out editing page.

	$prevsubject = $CGIQuery->param('prevsubject');
	$location = $CGIQuery->param('location');
	$MakeSects = $CGIQuery->param('MakeSects');
	$AllowPost = $CGIQuery->param('AllowPost');
	
	# Escape perl variable characters
	# $newsubject =~ s/([\$\%\&\@])/\\$1/g;
	# $prevsubject =~ s/([\$\%\&\@])/\\$1/g;
	
	if ($AllowPost eq "YES") {
		$allowpost = "all";
	} else {
		$allowpost = "nopost";
	}
	
	$dorefresh = 0;
	
	if (($newsubject ne "" || $MakeSects ne "") && $location ne "") {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		
		@location = $CGIQuery->param('location');
	
		if ($MakeSects eq "UsePrevious" && $prevsubject ne "") {
			if ($prevsubject !~ /\n/ && $prevsubject =~ /\r/) {
				@makesubs = split(/\r/, $prevsubject);
			} else {
				@makesubs = split(/\n/, $prevsubject);
			}
		} elsif ($MakeSects eq "NO" && $newsubject ne "") {
			if ($newsubject !~ /\n/ && $newsubject =~ /\r/) {
				@makesubs = split(/\r/, $newsubject);
			} else {
				@makesubs = split(/\n/, $newsubject);
			}
		} elsif ($MakeSects eq "YES") {
			#for ($k=1; $k <= $C_Sect_n; $k++) {
			#	@makesubs[$k -1] = $C_Sects{$k}{"name"};
			#}
			@makesubs = $CGIQuery->param('sectsubs');
		}
		
		# Get rid of any remaining \n or \r in new topic names
		for ($i=0; $i < @makesubs; $i++) {
			$makesubs[$i] =~ s/[\r\n]//g;
		}
		
		@makesubs = &unique(@makesubs);
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		for ($l=0; $l < @makesubs; $l++) {
			if ($makesubs[$l] eq "" || $makesubs[$l] !~ /\S/) {
				next;
			}
		
			$newsub = $makesubs[$l];
			
			# Shorten topic to max length
			while(length($newsub) > $MAX_TOPIC_LENGTH) {
				chop($newsub);
			}
			
			$nicename = $newsub;
			
			$newsub =~ s/\s+$//;

			# Take out funky characters and spaces
			# $newsub = &realClean($newsub);
			$newsub = &escapeTopicSlash(&escapeTopic($newsub));

			$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		
			for ($i=0; $i < @location; $i++) {
		
				$newloc = $C_rootpath . "/" . $DIR_CLASSFORUM . $location[$i];
				if ($newloc !~ /\/$/) {
					$newloc .= "/";
				}
				$newloc .= $newsub;
			
				$tmp = $newloc;
				$tmp =~ s/$C_rootpath\/$DIR_CLASSFORUM\///;
				$dbkey = $tmp;
			
				# Does this topic exist already? If so, skip to the next one
				@retval = `$prtDB $dbfile -tbtree -q -k \"$dbkey\"`;
				if ($retval[0] ne "") {
					# This topic exists
					next;
				}
			
				# if the subject contains /'s, mark its parents to be expanded
				@tmp = split (/\//, $tmp);
				$prev = "";
				for($j=0; $j < @tmp; $j++) {	
					if ($prev ne "") {
						$expand .= $prev . "/" . $tmp[$j] . ",";
						$prev = $prev . "/" . $tmp[$j];
					} else {
						$expand .= $tmp[$j] . "," ;
						$prev = $tmp[$j];
					}
				}
			
				if (! -e $newloc) {
					mkdir($newloc, 0775);
				}
			
				# Add it to the database
   
   				#$prettysub = $newsub;
				#$prettysub =~ s/_/ /g;
				$prettysub = $nicename;
				$parent = $location[$i];
				$parent =~ s/^\///;
				@getindents = split(/\//, $parent);
				$ImgIndents = @getindents;
			
   				$value = "0\\t" . $prettysub . "\\t$ImgIndents\\t0\\t" . $parent. "\\t$allowpost\\t0";
				
				@retval = `$setDB $dbfile -tbtree -q -k \"$dbkey\" -d \"$value\"`;
				$status = &dbErrorCheck($?, $retval[0]);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to write to Topics database: $dbfile.");
					exit();
				}
			
				# Update subdirs for the parent
				if ($parent ne "") {
					($key, @getvalues) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$parent\"`);
					
					$status = &dbErrorCheck($?, $key);
					if ($status) {
						&showErrorBackHTML("$status<p>Unable to read topic: $parent from Topics database: $dbfile.");
						exit();
					}

					$getvalues[3] = 1;
					$value = join("\\t", @getvalues);
					@retval = `$setDB $dbfile -tbtree -q -k \"$parent\" -d \"$value\"`;
					
					$status = &dbErrorCheck($?, $retval[0]);
					if ($status) {
						&showErrorBackHTML("$status<p>Unable to write to Topics database: $dbfile.");
						exit();
					}
				}
				
							
				if ($Subject eq "(NEW_SUBJECT)" && $newsub ne "") {
					push(@Subject, $newsub);		
					$dorefresh = 1;
				}
				
				# If we got a signal, exit here.
				if ($gotSignal) {
					close(DEVNULL);
					exit(0);
				}
			}
		}
		
			
		if ($newsubject ne "") {
			$Subject = "";
		}
	}
	
	@Subject = &unique(@Subject);
	
	########################
	# Print out the web page
	########################
	
	if ($Subject eq "(NEW_SUBJECT)") {
		$header = "Create New Topic";
	} elsif (@Subject == 1) {
		$header = "Add Topics to " . &printPretty(&unEscapeTopic($Subject[0]));
	} else {
		$header = "Add Topics";
	}
	
	$helplink = "file=TopicAddCORP_Admin.html&anchor=AddTopicEdtFSummary";
	$helplink .= "&helptitle=Add%20Topics%20Editing%20Frame";
	&showHeaderBackHTML($header, "", 0, 0, 0, $helplink);
		
	if (($newsubject ne "" || $MakeSects eq "YES") && $location eq "") {
		print $FontRed, "<b>You must choose a location!</b></font>";
	}
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	if ($Subject eq "(NEW_SUBJECT)") {
		print "<input type=hidden name=tid value=\"$Subject\">\n";
	} else {
		for ($i=0; $i < @Subject; $i++) {
			$Subject[$i] =~ s/ /\+/g;
			print "<input type=hidden name=tid value=\"$Subject[$i]\">\n";
		}
	}
	print "<input type=hidden name=func value=showedit>\n";
	
	if ($Subject eq "(NEW_SUBJECT)") {
		print "<input type=hidden name=location value='/'>\n";
	}

	print "<table cellpadding=5 cellspacing=0 border=0>\n";
	
	if ($Subject ne "(NEW_SUBJECT)") {
		print "<tr><td valign=top colspan=3>", $FontFace, $FontSize;	
		print "(Additions will be inserted as sub-topics under each ";
		print "selected topic location.)";
		print "</td></tr>\n";
	}
	
	print "<tr><td valign=top>";

	print "<table cellpadding=0 cellspacing=0 border=0>\n";

	if ($Subject ne "(NEW_SUBJECT)") {	
		print "<tr><td bgcolor=$FTheaderback>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		
		print "<tr><td>";
		print $FontFace, $FontSize;
		print "<b>Where</b> to Add New Topic(s):";
		print "</td></tr>\n";
		
		print "<tr><td>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	}
	
	print "<tr><td valign=top>", $FontFace, $FontSize;	
	if ($Subject ne "(NEW_SUBJECT)") {
		for ($i=0; $i < @Subject; $i++) {
			&printsubjectlist($Subject[$i]);
		}
	}
	print "</td></tr>\n";
	
	print "</table>\n</td>\n";
	
	############### Spacer Column
	print "<td>&nbsp;&nbsp;</td>\n";
	
	############### Right Column
	print "<td valign=top>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
	if ($Subject ne "(NEW_SUBJECT)") {	
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		
		print "<tr><td colspan=2>";
		print $FontFace, $FontSize;	
		print "<b>What</b>";
		print "</td></tr>\n";

		print "<tr><td>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	}
	
	if ($Subject eq "(NEW_SUBJECT)") {
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
	
		print "<tr><td colspan=2>", $FontFace, $FontSize;
		print "<b>What</b> New Top Level Topic(s) to Add:</td></tr>\n";
		
		print "<tr><td>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	}
	
	print "<tr>";
	print "<td valign=top>", $FontFace, $FontSize;
	print "<input type=radio name=MakeSects value=NO checked>";
	print "</td>\n";
	print "<td valign=middle>", $FontFace, $FontSize;
	print "Enter New Topic Names (One per line)";
	print "</td></tr>\n";
	
	print "<tr>";
	print "<td valign=top>", $FontFace, $FontSize;
	print $ImgIndentSmall, "</td>\n";
	print "<td valign=top>", $FontFace, $FontSize;
	# print "<input type=text name=newsubject size=30 maxlength=30";
	print "<textarea name=newsubject rows=5 cols=40 ";
	if ($Subject ne "(NEW_SUBJECT)") {
		print " onFocus=\"document.forms[0].MakeSects[0].checked=1\"";
	}
	print ">";
	if ($newsubject ne "" && $location eq "") {
		# print " value=\"$newsubject\"";
		print "$newsubject";
	}
	print "</textarea>";
	print "</td></tr>\n";
	
	if ($Subject ne "(NEW_SUBJECT)") {
		print "<tr><td colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=5>";
		print "</td></tr>\n";
	
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
		print "<input type=radio name=\"MakeSects\" value=\"YES\" ";
		# print "onClick=document.forms[0].newsubject.value=''";
		print "></td>\n";
		print "<td valign=middle>", $FontFace, $FontSize;
		print "Add These Topics ($CorF $SorGs)";
		print "</td></tr>";
		
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
		print $ImgIndentSmall, "</td>\n";
		print "<td valign=top>", $FontFace,$FontSize;
		&printSectionSelection;
		print "</td></tr>\n";
	} 
	
	if (@makesubs > 0) {
		print "<tr><td colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=5>";
		print "</td></tr>\n";
	
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
		print "<input type=radio name=MakeSects value=UsePrevious>";
		print "</td>\n";
		print "<td valign=middle>", $FontFace, $FontSize;
		print "Add These Previously Entered Topic Names";
		print "</td></tr>";
	
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
		print $ImgIndentSmall, "</td>\n";
		print "<td valign=top>", $FontFace, $FontSize;
		print "<textarea name=prevsubject rows=5 cols=40 ";
		print " onFocus=\"document.forms[0].MakeSects[2].checked=1\"";
		print ">";
		for ($i=0; $i < @makesubs; $i++) {
			print $makesubs[$i], "\n";
		}
		print "</textarea>";
		print "</td></tr>";
	}
	
	print "<tr><td colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=5>";
	print "</td></tr>\n";

	print "<tr><td bgcolor=$FTheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr><td colspan=2>";
	print $FontFace, $FontSize;	
	print "<b>Posting Permissions</b>";
	print "</td></tr>\n";
		
	print "<tr><td>";
	print "<img src=$ImgSrcClearDot width=20 height=4>";
	print "</td></tr>\n";
	
	print "<tr>";
	print "<td colspan=2>", $FontFace,$FontSize;
	print "<input type=checkbox value=YES name=AllowPost checked>\n";
	print "Allow posting to your new topic(s)</td></tr>\n";
	
	print "<tr><td>";
	print "<img src=$ImgSrcClearDot width=20 height=4>";
	print "</td></tr>\n";

	print "<tr><td bgcolor=$FTheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";

	print "<tr>";
	print "<td colspan=2>", $FontFace,$FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr></table>\n\n";
	
	print "</td></tr>\n";
	print "</table>\n";
	
	print "</form>\n\n";
	
	if ($dorefresh) {
		print "<script language=javascript>\n";
		print "parent.subjectmenu.document.location.reload();\n";
		print "</script>\n";
	}
	
	print "</body></html>";
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen, but no subject. Print list of subjects
	#####################################################

	@selected = $CGIQuery->param('selected');
	$selleng = @selected;
	$BtnSelected = @selected[$selleng - 1];
	
	$helplink = "file=TopicAddCORP_Admin.html&anchor=AddTopicTskFSummary";
	$helplink .= "&helptitle=Add%20Topics%20Task%20Frame";
	&showHeaderBackHTML("Add Topics for $CorF - $Class", 
		"", 0, 1, 0, $helplink);

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=subjectedit>\n";
	print "<input type=hidden name=func value=showedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";

	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=middle align=right>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=tid size=4 multiple>\n";
	print "<option value='(NEW_SUBJECT)'> (Create New Top Level Topic)\n";
	# print "<option value=''> ------------------\n";
	
	# Get the list of existing subjects
	@ls = &gettopsubjectlist($Subject);
	
	# Put the list of subjects in the selection box
	for ($i=0; $i < @ls; $i++) {
		$ls[$i] =~ s/ /\+/g;
		print "<option value=\"", $ls[$i], "\"";
		if ($BtnSelected eq $ls[$i]) {
			print " SELECTED";
		}
		print "> ";
		print &printPretty(&unEscapeTopic($ls[$i])), "\n";
	}
	
	print "</select></td>";
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	# print "<input type=submit name=submit value='Edit'>";
	print $BtnFormSubmit;
	print "</td>\n";
	
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	print "<img src=$ImgSrcClearDot width=8 height=30 align=absmiddle></td>\n";
	
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	print "(Select \"Create New Top Level Topic\" ";
	print "or select one or more topics to create subtopics)";
	print"</td>\n";
	print "</tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
} elsif ($func eq "nothing" || $func eq "showedit") {

	# User input nothing, tell them to select something
	
	&printEmptyTaskFrame("Please choose a Topic above.");
	
} else {
	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Topic Addition</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=subjectmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=subjectedit src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}


########

sub printsubjectlist {
	local($Subject) = @_;
	local($match, $i);

	# Start a table
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	@match = split(//, $Subject);
	for ($i=0; $i < @match; $i++) {
		$match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
	}
	$match = join("", @match);
	
	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent, $allowpost, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}

		if ($DB_Key eq $Subject || $DB_Key =~ /^$match\//) {
	
			print "<tr>";
			print "<td valign=top nowrap>", $FontFace, $FontSize;
			
			# Print a spacer for the margin
			print $ImgClear88;
		
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print $ImgClear88;
			}
		
			if ($subdirs ne "" && $subdirs == 1) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		
			print $ImgIndentSmall;
			
			if ($ImgIndents == 0) {
				print "<b>";
			}
			print $nicename;
			if ($ImgIndents == 0) {
				print "</b>";
			}
			
			print $ImgClear88;
			print "<input type=checkbox name=location value=\"/";
			print $DB_Key;
			print "\">";
			
			print "</td></tr>\n";
		
			#print "<tr><td valign=top>", $FontFace, $FontSize;
			#print $ImgClear88, $ImgClear88;
			# Print the indents
			#for ($k=0; $k < $ImgIndents; $k++) {
			#	print $ImgClear88;
			#}
			#print $IcoNoReplies;
			#print "<input type=checkbox name=location value=\"/";
			#print $DB_Key;
			#print "\"> ";
			#print "<font color=$FCdate>";
			#print "Add Topic under</font><font color=#000000> $nicename";
			#print "</font></td></tr>\n";
		}
	}
	
	print "</table>\n\n";
}

sub printSectionSelection {
	for ($j=1; $j <= $C_Sect_n; $j++) {
		print "<input type=checkbox name=sectsubs value=\"";
		print $C_Sects{$j}{"name"}, "\" checked ";
		print "onClick=\"document.forms[0].MakeSects[1].checked=1\">";
		print $C_Sects{$j}{"name"}, "\n";
		print "<br>";
	}
}
