// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : packet.h
//
//  DESCRIPTION :
//         Packet related class definition
//
// #################################################################


/////////////////////////
#ifndef INCLUDED_PACKET_H
#define INCLUDED_PACKET_H
/////////////////////////


// ==================
#include "sockets2.h"
// ==================


// ---------------------------
template <typename T>
string GetTypeName ();
// Implementation is in demotype.cpp

template <typename T>
string AuxGetTypeName (const string& typeid_name_i);

string GetTypeName (const string& typeid_name_i);


// ---------------------------
class BasicDataType
{
  protected :
    const string	typeid_data_type_;
    const ulong		id_;
    const string	file_;
    const ulong		line_no_;

    static ulong	created_s;
    static ulong	deleted_s;

  public :

    // --------------------------
    // Constructor-1
    BasicDataType (
		const string& typeid_data_type_i,
		const string& file_i,
		const ulong line_no_i
		);
    virtual ~BasicDataType ();

    string		get_typeid_data_type () const;

    virtual size_t	get_packet_transmission_len () const = 0;
    bool		is_packet_allowed_len (size_t max_allowed_len_i = BUFSIZE_DEFAULT) const;

    virtual void	show_packet (const vector<string>& msg_i, char ch_i) const = 0;

    static size_t	Get_PrePacket_Len ();

    static ulong	Get_Created_Instances ();
    static ulong	Get_Deleted_Instances ();


};


// ---------------------------
template <typename T>
class PacketType : public BasicDataType
{
  private :
    vector<T>		data_items_;

  public :
    // Constructor-1
    PacketType (
		const vector<T>& data_items_i,
		const string& file_i,
		const ulong line_no_i
		);

    // Destructor
    ~PacketType ();

    vector<T>	get_data_items () const;

    size_t	get_packet_transmission_len () const;

    void	show_packet (const vector<string>& msg_i, char ch_i) const;

};

//////
#endif
//////


