// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : main.h
//
//  DESCRIPTION :
//         Main program header file
//
// #################################################################


///////////////////////
#ifndef INCLUDED_MAIN_H
#define INCLUDED_MAIN_H
///////////////////////


// ==================
#include "demoapp2.h"
// ==================


// ----------------------------
#define OPTION_SIGN			"-"

#define RUN_CLIENT_OPTION		"c"
#define RUN_SERVER_OPTION		"s"

#define IP_SERVER_ADDRESS_OPTION	"i"
#define IP_PORT_NUMBER_OPTION		"p"
#define NUMBER_OF_TEST_REQUESTS_OPTION	"r"

#define RUN_DEMO_SAMPLE_1		1
#define RUN_DEMO_SAMPLE_2		2

static const string isClient_CNS                (string (OPTION_SIGN) + RUN_CLIENT_OPTION);
static const string isServer_CNS                (string (OPTION_SIGN) + RUN_SERVER_OPTION);
static const string isIpAddressOption_CNS       (string (OPTION_SIGN) + IP_SERVER_ADDRESS_OPTION);
static const string isPortNumberOption_CNS      (string (OPTION_SIGN) + IP_PORT_NUMBER_OPTION);
static const string isNumberOfRequestOption_CNS (string (OPTION_SIGN) + NUMBER_OF_TEST_REQUESTS_OPTION);



// ------------------
void show_info ();
void show_help (const char argv0[]);
void show_demo1_descr ();
void show_demo2_descr ();
bool parse_command_line (
		int		argc, 
		char		*argv[],
		bool&		is_client_o,	// true - client, false - server
		size_t&		demo_sample_no_o,
		string&		ip_server_address_o,
		int&		ip_port_no,
		size_t&		number_of_test_requests_o
		);



//////
#endif
//////

