// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : tests.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============


// #########################################
// #
// #  Function Implementation
// #  Prototypes are in file user.h
// #
// #########################################
// =============================
void SetEnv ()
{
  SetTotalTests (TOTAL_TESTS_default);
  SetScaleAndTotalIterations (PER_CALLS_default, TOTAL_ITERATIONS_PER_TEST_default);
  SetDiscardingThreshold (DISCARDING_THRESHOLD_default);

  SetDetailedMeasurementReportFlag (true);
  SetMeasurementReportFlag (true);
  // SetTracingReportFlag (true);

}


// =============================
// =============================
void MeasureDemo ()
{
  MeasureFunc (demo_10);
  MeasureFunc (demo_11);
}


// =============================
void CompareDemo ()
{
const string demo_str ("### Demo Tests ###");

  sout << endl;
  sout << endl;
  sout << endl;
  sout << "\t" << string (demo_str.size(), '#') << endl;
  sout << "\t" << demo_str << endl;
  sout << "\t" << string (demo_str.size(), '#') << endl;

  // ----------------------------------
const string compare_group1_name      ("delete-new-string etc");
const string compare_group2_name      ("delete-new-string only");
const string compare_group3_name      ("delete-new-string only (with TURN_ON_DEFAULT_TIMER)");
const string compare_group4_name      ("strlen vs. string-size");

  CompareFunc (compare_group1_name, demo_01);
  CompareFunc (compare_group1_name, demo_02);
  CompareFunc (compare_group1_name, demo_03);
  CompareFunc (compare_group1_name, demo_04);
  CompareFunc (compare_group1_name, demo_05);

  CompareFunc (compare_group2_name, demo_05);
  CompareFunc (compare_group2_name, demo_06);
  CompareFunc (compare_group2_name, demo_07);
  CompareFunc (compare_group2_name, demo_08);
  CompareFunc (compare_group2_name, demo_09);

  CompareFunc (compare_group3_name, demo_12);

  CompareFunc (compare_group4_name, demo_13);

} // CompareDemo



// =============================
// =============================
void MeasureIt ()
{
  // Nothing
}

// =============================
void CompareIt ()
{
const string stub__comparison_group         ("stub tested functions");
const string string_init__comparison_group  ("string initialization (C vs. STL)");
const string string_treat__comparison_group ("string processing (C vs. STL)");
const string string_len__comparison_group   ("string length (C vs. STL)");
const string find__comparison_group         ("find method vs. find algorithm");
const string for__comparison_group          ("for-loop vs. for_each");
const string access__comparison_group       ("access to element");
const string call__comparison_group         ("calling functions : templated vs. non-templated");
const string endl__comparison_group         ("endl vs. \"\\n\" and \'\\n\'");
const string read_file__comparison_group    ("reading contents from file into one string");
const string container__comparison_group    ("container performance (A.Stepanov & B.Stroustrup)");
const string recursion__comparison_group    ("recursion vs. iteration vs. accumulate");
const string inheritance__comparison_group  ("multiple inheritance vs. single inheritance");
const string dcast_switch__comparison_group ("dynamic_cast vs. switch");


  // ------------------------------------------------------
  CompareFunc (stub__comparison_group, stub_action1);
  CompareFunc (stub__comparison_group, stub_action2);

  CompareFunc (string_init__comparison_group, string_init1);
  CompareFunc (string_init__comparison_group, string_init2);

  CompareFunc (string_treat__comparison_group, string_treat1);
  CompareFunc (string_treat__comparison_group, string_treat2);

  CompareFunc (string_len__comparison_group, string_len);

  CompareFunc (find__comparison_group, find_action);

  CompareFunc (for__comparison_group, for_action);

  CompareFunc (access__comparison_group, access_action);

  CompareFunc (call__comparison_group, calling_functions);

  CompareFunc (read_file__comparison_group, file_action);

  CompareFunc (container__comparison_group, container_action);

  CompareFunc (recursion__comparison_group, recursion_action);

  CompareFunc (inheritance__comparison_group, creating_inherited_objects);

  CompareFunc (dcast_switch__comparison_group, derived_action1);
  CompareFunc (dcast_switch__comparison_group, derived_action2);


  // ---------------------------------------------------
  // To test this comparison group 
  //    you should redirect stdout and stderr to files 
  //    when running an executable file via command line. 
  //    For instance (in bash) :
  //    perfo.exe > tmp.out 2> tmp.err
  // ---------------------------------
  // CompareFunc (endl__comparison_group, endl_action);
  // ----------------------------------------------------


} // CompareIt



///////////////
// End-Of-File
///////////////
