// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : macro.h
//
//  DESCRIPTION :
//         Various Macro
//
// ##############################################################



////////////////
#ifndef _MACRO_H
#define _MACRO_H
////////////////


// #########################################
// #
// #  macro
// #
// #########################################

#define	DEBUG_MODE	0

// =============================
#define DOUT(x)	\
	sout	<< "DBG"	\
		<< " ["		\
		<< setw(10)	\
		<< __FILE__	\
		<< ", #"	\
		<< __LINE__	\
		<< "] "		\
		x		\
		<< endl

#define DOUT1_VAL(x, t1)	DOUT(<< t1 << " : " << #x << " = <" << x << ">")	
#define DOUT2_VAL(x, t1, t2)	DOUT(<< t1 << " : " << #x << " = <" << x << "> " << t2)	

// =============================
#define I_AM_X(x)				\
	sout	<< ""				\
		<< x				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl

#define I_AM_Y(y, n)				\
	sout	<< ""				\
		<< y				\
		<< "-"				\
		<< n				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl

#define I_AM_Z(z, n, m)				\
	sout	<< ""				\
		<< z				\
		<< "-"				\
		<< n				\
		<< "-"				\
		<< m				\
		<< " ["		      		\
		<< setw(10)			\
		<< string (__FILE__).c_str()	\
		<< ", #"			\
		<< setw(4)			\
		<< __LINE__			\
		<< "] "				\
		<< __PRETTY_FUNCTION__		\
		<< endl


#if (DEBUG_MODE)

  #define I_AM_TRACE		I_AM_X ("TRACE")	
  #define I_AM_CTOR		I_AM_X ("CTOR ")	
  #define I_AM_COPY_CTOR	I_AM_X ("COPY-CTOR ")	
  #define I_AM_DTOR		I_AM_X ("DTOR ")	

  #define I_AM_ITRACE(n)	I_AM_Y ("TRACE", n)	
  #define I_AM_IJTRACE(n, m)	I_AM_Z ("TRACE", n, m)	

  #define DBG_TMP_STR		__FILE__ << ", # " << __LINE__ << " ---> " << __PRETTY_FUNCTION__			

#else
  #define I_AM_TRACE	
  #define I_AM_CTOR	
  #define I_AM_COPY_CTOR	
  #define I_AM_DTOR	

  #define I_AM_ITRACE(n)		
  #define I_AM_IJTRACE(n, m)	

  #define DBG_TMP_STR	

#endif

// =============================
#define  MAX_VALUE(x,y)  ((x) > (y) ? (x) : (y))

#if ((defined __GNUC__)	|| (defined __GNUG__) || (defined __DJGPP__) || (defined __DJGPP) || (defined DJGPP))
  #define prettyFuncName	__PRETTY_FUNCTION__	
  #define funcName		__FUNCTION__	
#else
  #define prettyFuncName	"NoPrettyFunctionName"	
  #define funcName		"NoFunctionName"	
#endif

extern unsigned long meas_counter_exn;
extern unsigned long curr_meas_exn;
#define BASIC_TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG, iterations_ARG)	\
	cerr.setf (ios::right, ios::adjustfield); \
	++meas_counter_exn; \
	cerr << "(" << setw(2) << curr_meas_exn << " of " << setw(2) << mng.get_total_tests() << ")" ; \
	cerr << setw(7) << meas_counter_exn; \
	cerr.setf (ios::left, ios::adjustfield); \
	cerr << "  : Measure -> [ " << setw(12) << __FILE__ << ", " ; \
	cerr.setf (ios::right, ios::adjustfield); \
	cerr << setw (4) << __LINE__ << "; " ; \
	cerr.setf (ios::left, ios::adjustfield); \
	cerr << setw (15) << funcName << " ]  " << descr_ARG << endl; \
	ulong total_meas_iterations = iterations_ARG;	\
	ulong i_meas_iterations;   	\
	ClassPerfoMeter<T1, T2, T3> ins_meter(	\
		mng.get_cur_func_ptr(),	\
		prettyFuncName,		\
		funcName,		\
		__FILE__,		\
		__LINE__,		\
		descr_ARG,		\
		iterations_ARG		\
		);			\
		for (	i_meas_iterations = 0;	\
			i_meas_iterations < total_meas_iterations;	\
			i_meas_iterations++	\
			)
			 

#define TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG) \
	BASIC_TURN_ON_PERFOMETER(T1, T2, T3, descr_ARG, mng.get_current_total_iterations ())

#define TURN_ON	TURN_ON_PERFOMETER


///////////////////
#endif  // _MACRO_H
///////////////////
