#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. ERU server stop script.
#
# Note:
#    1) System parameters marked as (!) MUST be configured by deployer.
#       System will not work if these parameters are not defined properly.
#
#    2) System parameters marked as (S) are important for system security.
#       It is recommended to configure them after initial system installation
#       and configuration.
#

#
# (!) $SERVER is host where ERU server is running.
# See 'address' parameter in erus.conf.
#
SERVER=MyERUServer

#
# $PORT is port which ERU server is listening to.
# See 'port' parameter in erus.conf.
#
PORT=9008

#
# (S) $PASSWORD is password to authenticate in ERU server.
# See 'shutdown.password' parameter in erus.conf.
#
PASSWORD=MyERUShutdownPassword

# if CACHALOT_HOME not defined
if [ -z "$CACHALOT_HOME" ]; then
    PRG=$0
    # Resolve symlinks.
    while [ -L "$PRG" ]; do
        ls=`ls -ld "$PRG"`
        link=`expr "$ls" : '.*-> \(.*\)$'`
        if expr "$link" : '/' > /dev/null; then
            PRG="$link"
        else
            PRG="`dirname $PRG`/$link"
        fi
    done
    # define CACHALOT_HOME
    CACHALOT_HOME=`dirname "$PRG"`/..
fi

ENV=$CACHALOT_HOME/bin/environment.sh
if [ ! -r "$ENV" ]; then
    echo "Can't find file: $ENV."
    echo "This file is needed to run this program."
    echo
    exit 1
fi

. "$ENV"

$JAVA com.rathedg.socketserver.Shutdown $SERVER $PORT $PASSWORD

