/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.socketserver;

import com.rathedg.socketserver.HandlerThreadPool;
import com.rathedg.socketserver.RequestDescriptor;
import com.rathedg.socketserver.ServerException;
import com.rathedg.socketserver.Shutdown;
import com.rathedg.util.log.LoggerInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;

public final class SocketServer {
    public static final String version = "1.2.0";
    protected static final boolean DEBUG = false;
    protected int port = 9008;
    protected InetAddress bindaddr;
    protected int connections = 16;
    protected HandlerThreadPool threadpool;
    protected LoggerInterface logger;
    protected List requestdescriptors;
    protected short requestdescriptorsnum;
    protected String password;
    private boolean mustshutdown = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketServer(int n, InetAddress inetAddress, int n2, int n3, List list, String string, LoggerInterface loggerInterface) throws IOException {
        this.logger = loggerInterface;
        this.password = string;
        this.requestdescriptors = list;
        this.requestdescriptorsnum = (short)list.size();
        ServerSocket serverSocket = new ServerSocket(n, n2, inetAddress);
        this.threadpool = new HandlerThreadPool(this, n3);
        loggerInterface.log("Server started");
        block6: while (true) {
            try {
                while (true) {
                    SocketServer socketServer = this;
                    synchronized (socketServer) {
                        this.threadpool.startThread(serverSocket.accept());
                        if (this.mustshutdown) {
                            break block6;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                loggerInterface.log("Exception occured (" + throwable.getClass().getName() + ") during listening or accepting request: " + throwable.getMessage());
                continue;
            }
            break;
        }
        try {
            serverSocket.close();
            return;
        }
        catch (IOException iOException) {
            loggerInterface.log("Exception occured (" + iOException.getClass().getName() + ") during closing server socket: " + iOException.getMessage());
        }
    }

    void doShutdown() {
        this.mustshutdown = true;
        this.threadpool.synchronizeShutdown();
        int n = 0;
        while (n < this.requestdescriptors.size()) {
            ((RequestDescriptor)this.requestdescriptors.get(n)).getHandler().shutdown();
            n = (short)(n + 1);
        }
        this.logger.log("Shutted down");
    }

    void shutdown() throws IOException, ServerException {
        try {
            Shutdown.shutdown(this.bindaddr, this.port, 0, this.password);
        }
        catch (ServerException serverException) {
            throw new IOException("server error");
        }
    }
}

