// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-daemon.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : daemon methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========
OusideRuleTypes TuringMachine::get_daemon_behavior (
			const pair<const CurSituation, NextSituation>& rule_i,
			Transitions_t::const_iterator& daemon_fault_iter_o
			) const
{

  // --- Sample of get_daemon_behavior body ---

#define FAILED_MACHINE_NO	6	// Sample
#define FAILED_INPUT_SET_NO	1	// Sample
#define FAILED_STEP_NO		119	// Sample

  // -------- Failure -------
  if (
       (machine_serial_no_ == FAILED_MACHINE_NO)
       &&
       (input_set_no_ == FAILED_INPUT_SET_NO)
       &&
       (process_transitions_.size() == FAILED_STEP_NO)
     )
  {
    return AGGRESSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE;
  }

  // -------- Fault ---------
  daemon_fault_iter_o = daemon_fault_action (rule_i);
  if (daemon_fault_iter_o != daemon_defined_fault_transitions_.end())
  {
    return ACTIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE;
  }

  // -----------------------
  assert (daemon_fault_iter_o == daemon_defined_fault_transitions_.end());
  return PASSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE;

}

    
// =========
Transitions_t::const_iterator TuringMachine::daemon_fault_action (
		const pair<const CurSituation, NextSituation>& rule_i
		) const
{

  // --- Sample of daemon_fault_action body ---

  if (daemon_defined_fault_transitions_.empty())
  {
    return daemon_defined_fault_transitions_.end();
  }

  assert (!daemon_defined_fault_transitions_.empty());

  if (belongs_to (rule_i.first, daemon_defined_fault_transitions_))
  {
    count_daemon_transitions_[rule_i.first]++;
    if (count_daemon_transitions_[rule_i.first] == 1)
    {
      Transitions_t::const_iterator ret_iter = daemon_defined_fault_transitions_.find(rule_i.first);
      assert (ret_iter != daemon_defined_fault_transitions_.end());
      return ret_iter;  
    }
  }

  return daemon_defined_fault_transitions_.end();

} // daemon_fault_action


