// ==============================================================
//
//  Copyright (c) 1999-2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================

static char id [] = "@(#)## n-ary Huffman Template Algorithm ## Author : Alex Vinokur ## "__FILE__;


// ##############################################################
// =================================
//  n-ary Huffman Template Algorithm
// ==================================
//
//  FILE : demotype.cpp
//
//  AUTHOR : Alex Vinokur
//
//  DESCRIPTION :
//
//         Implementation of the following test classes :
//         ----------------------------------------------
//         - AAA        (non-char) symbol type
//         - BBB        (non-numerical) weight type
//         ----------------------------------------------
//
// ##############################################################


// ===========================
#include "demotype.h"
// ===========================



// ###################################################
// ############## "Symbols" Test Class ###############
// ###################################################
// =========================
AAA::AAA()
{
  counter_ = ++counter_s;
}

// =========================
ostream& operator<< (ostream& o, const AAA& instance_i)
{
        return o << "AAA_" << instance_i.counter_;
}
// ----------------------
bool operator< (const AAA& inst1_i, const AAA& inst2_i)
{
        return (inst1_i.counter_ < inst2_i.counter_);
}




// ###################################################
// ############## "Weight" Test Class ################
// ###################################################
// =========================
BBB::BBB()
{
 	counter_ = ++counter_s; value_ = rand ();
}
// ----------------------
BBB& BBB::operator+= (const BBB& inst_i)
{
	value_ += inst_i.value_;
	return (*this);
}


// =========================
ostream& operator<< (ostream& o, const BBB& instance_i)
{
        return o << "BBB_" << instance_i.counter_;
        // #########################################
        // Note! This operator shows bogus weight.
        // Real value (instance_i.value_) hidden.
        // #########################################
}
// ----------------------
bool operator< (const BBB& inst1_i, const BBB& inst2_i)
{
        return (inst1_i.value_ < inst2_i.value_);
}
// ----------------------
bool operator== (const BBB& inst1_i, const BBB& inst2_i)
{
        return (inst1_i.value_ == inst2_i.value_);
}
// ----------------------
BBB operator* (const BBB& inst1_i, unsigned int int_value_i)
{
BBB bbb;
        bbb.value_ = bbb.value_*int_value_i;
        return bbb;
}
// ----------------------
BBB operator/ (const BBB& inst1_i, unsigned int int_value_i)
{
BBB bbb;
        bbb.value_ = bbb.value_/int_value_i;
        return bbb;
}



// #####################################################
// =========================
unsigned int    AAA::counter_s (0);
unsigned int    BBB::counter_s (0);
// =========================


// #######################################################
// ################ END OF FILE ##########################
// #######################################################

