/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.win32;

import com.develop.io.LittleEndianOutputStream;
import com.develop.io.NakedByteStream;
import com.develop.jawin.COMError;
import com.develop.jawin.COMException;
import com.develop.jawin.FuncPtr;
import com.develop.jawin.marshal.GenericStub;
import com.develop.jawin.marshal.MarshalConstants;
import com.develop.jawin.marshal.SharedStubs;
import com.develop.jawin.marshal.StructConverter;
import com.develop.jawin.win32.EVENTLOGRECORD;
import java.io.IOException;

public class EventLog
implements MarshalConstants {
    private static final FuncPtr fpRES;
    private static final FuncPtr fpDES;
    private static final FuncPtr fpRE;
    private static final FuncPtr fpCEL;
    private static final FuncPtr fpOEL;
    private static final FuncPtr fpGOELR;
    private static final FuncPtr fpGNOELR;
    private static final FuncPtr fpREL;

    public static int RegisterEventSource(String string, String string2) throws COMException, IOException {
        return SharedStubs.invokeGG_I(string, string2, fpRES.getPeer(), 1);
    }

    public static int OpenEventLog(String string, String string2) throws COMException, IOException {
        return SharedStubs.invokeGG_I(string, string2, fpOEL.getPeer(), 1);
    }

    public static int DeregisterEventSource(int n) throws COMException, IOException {
        return SharedStubs.invokeI_I(n, fpDES.getPeer(), 1);
    }

    public static int CloseEventLog(int n) throws COMException, IOException {
        return SharedStubs.invokeI_I(n, fpCEL.getPeer(), 1);
    }

    public static int GetOldestEventLogRecord(int n) {
        return SharedStubs.invokeIO(n, fpGOELR.getPeer(), 1);
    }

    public static int GetNumberOfEventLogRecords(int n) {
        return SharedStubs.invokeIO(n, fpGNOELR.getPeer(), 1);
    }

    public static int ReportEvent(int n, int n2, int n3, int n4, String string) throws COMException, IOException {
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeInt(n2);
        littleEndianOutputStream.writeInt(n3);
        littleEndianOutputStream.writeInt(n4);
        littleEndianOutputStream.writeInt(0);
        littleEndianOutputStream.writeInt(1);
        littleEndianOutputStream.writeInt(0);
        littleEndianOutputStream.writeInt(0);
        littleEndianOutputStream.writeInt(0);
        Object[] objectArray = new Object[]{new String[]{string}};
        byte[] byArray = GenericStub.win32Invoke(fpRE.getPeer(), "B28T4I:T1:", 36, 40, nakedByteStream.getInternalBuffer(), objectArray);
        return StructConverter.bytesIntoInt(byArray, 0);
    }

    public static byte[] RawReadEventLog(int n, int n2, int n3) throws IOException, COMException {
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeInt(n2);
        littleEndianOutputStream.writeInt(n3);
        byte[] byArray = GenericStub.win32Invoke(fpREL.getPeer(), "IIIAkAA:T8:L24n4", 28, 28, nakedByteStream.getInternalBuffer(), null);
        int n4 = StructConverter.bytesIntoInt(byArray, 0);
        littleEndianOutputStream.writeInt(n4);
        byte[] byArray2 = GenericStub.win32Invoke(fpREL.getPeer(), "IIIM" + n4 + "IAA:T3:L12n" + n4, 28, 28, nakedByteStream.getInternalBuffer(), null);
        return byArray2;
    }

    public static EVENTLOGRECORD ReadEventLog(int n, int n2, int n3) throws IOException, COMException {
        byte[] byArray = EventLog.RawReadEventLog(n, n2, n3);
        return new EVENTLOGRECORD(byArray);
    }

    static {
        try {
            fpRES = new FuncPtr("ADVAPI32.DLL", "RegisterEventSourceW");
            fpDES = new FuncPtr("ADVAPI32.DLL", "DeregisterEventSource");
            fpRE = new FuncPtr("ADVAPI32.DLL", "ReportEventW");
            fpOEL = new FuncPtr("ADVAPI32.DLL", "OpenEventLogW");
            fpCEL = new FuncPtr("ADVAPI32.DLL", "CloseEventLog");
            fpGOELR = new FuncPtr("ADVAPI32.DLL", "GetOldestEventLogRecord");
            fpGNOELR = new FuncPtr("ADVAPI32.DLL", "GetNumberOfEventLogRecords");
            fpREL = new FuncPtr("ADVAPI32.DLL", "ReadEventLogW");
        }
        catch (COMException cOMException) {
            throw new COMError("Unable to load event log entry points");
        }
    }
}

