/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DecimalDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private BigDecimal[] fEnumDecimal = null;
    private String fPattern = null;
    private BigDecimal fMaxInclusive = null;
    private BigDecimal fMaxExclusive = null;
    private BigDecimal fMinInclusive = null;
    private BigDecimal fMinExclusive = null;
    private int fFacetsDefined = 0;
    private int fScale = 0;
    private int fPrecision = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private boolean isScaleDefined = false;
    private boolean isPrecisionDefined = false;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private RegularExpression fRegex = null;
    private Hashtable fFacets = null;

    public DecimalDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DecimalDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            int n;
            int n2;
            int n3;
            int n4;
            this.fFacets = this.checkForFacetConsistency(hashtable, datatypeValidator.getFacets());
            this.fFacets = hashtable;
            Vector vector = null;
            String string = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                try {
                    if (string2.equals("pattern")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 8;
                        this.fPattern = string;
                        if (this.fPattern == null) continue;
                        this.fRegex = new RegularExpression(this.fPattern, "X");
                        continue;
                    }
                    if (string2.equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        vector = (Vector)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("maxInclusive")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 32;
                        this.fMaxInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
                        continue;
                    }
                    if (string2.equals("maxExclusive")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 64;
                        this.fMaxExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
                        continue;
                    }
                    if (string2.equals("minInclusive")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 128;
                        this.fMinInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
                        continue;
                    }
                    if (string2.equals("minExclusive")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 256;
                        this.fMinExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
                        continue;
                    }
                    if (string2.equals("precision")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 512;
                        this.isPrecisionDefined = true;
                        this.fPrecision = Integer.parseInt(string);
                        continue;
                    }
                    if (string2.equals("scale")) {
                        string = (String)hashtable.get(string2);
                        this.fFacetsDefined += 1024;
                        this.isScaleDefined = true;
                        this.fScale = Integer.parseInt(string);
                        continue;
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, string2}));
                }
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if (this.isMaxExclusiveDefined && this.isMinExclusiveDefined && (n4 = this.fMaxExclusive.compareTo(this.fMinExclusive)) != 1) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinInclusiveDefined && (n3 = this.fMaxInclusive.compareTo(this.fMinInclusive)) == -1) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be >= than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxExclusiveDefined && this.isMinInclusiveDefined && (n2 = this.fMaxExclusive.compareTo(this.fMinInclusive)) != 1) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinExclusiveDefined && (n = this.fMaxInclusive.compareTo(this.fMinExclusive)) != 1) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && vector != null) {
                this.fEnumDecimal = new BigDecimal[vector.size()];
                int n5 = 0;
                try {
                    while (n5 < vector.size()) {
                        this.fEnumDecimal[n5] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)vector.elementAt(n5)));
                        this.boundsCheck(this.fEnumDecimal[n5]);
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{vector.elementAt(n5)}));
                }
            }
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContentEnum(string, object, null);
        return null;
    }

    protected void checkContentEnum(String string, Object object, Vector vector) throws InvalidDatatypeValueException {
        int n;
        if (this.fBaseValidator != null) {
            ((DecimalDatatypeValidator)this.fBaseValidator).checkContentEnum(string, object, vector);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "' does not match regular expression facet " + this.fRegex.getPattern());
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(this.getErrorString(3, 0, new Object[]{"'" + string + "'"}));
        }
        if (vector != null) {
            n = vector.size();
            BigDecimal[] bigDecimalArray = new BigDecimal[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    bigDecimalArray[n2] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)vector.elementAt(n2)));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(8, 0, new Object[]{vector.elementAt(n2)}));
            }
            this.enumCheck(bigDecimal, bigDecimalArray);
        }
        if (this.isScaleDefined && bigDecimal.scale() > this.fScale) {
            throw new InvalidDatatypeValueException(this.getErrorString(17, 0, new Object[]{string}));
        }
        if (this.isPrecisionDefined && (n = bigDecimal.movePointRight(bigDecimal.scale()).toString().length() - (bigDecimal.signum() < 0 ? 1 : 0)) > this.fPrecision) {
            throw new InvalidDatatypeValueException(this.getErrorString(16, 0, new Object[]{"'" + string + "'" + "with precision = '" + n + "'", "'" + this.fPrecision + "'"}));
        }
        this.boundsCheck(bigDecimal);
        if (this.fEnumDecimal != null) {
            this.enumCheck(bigDecimal, this.fEnumDecimal);
        }
    }

    public void boundsCheck(BigDecimal bigDecimal) throws InvalidDatatypeValueException {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.fMaxExclusive != null ? this.fMaxExclusive.toString() : (string = this.fMaxInclusive != null ? this.fMaxInclusive.toString() : "");
        String string3 = this.fMinExclusive != null ? this.fMinExclusive.toString() : (this.fMinInclusive != null ? this.fMinInclusive.toString() : "");
        String string4 = "";
        String string5 = "";
        if (this.isMaxInclusiveDefined) {
            bl2 = bigDecimal.compareTo(this.fMaxInclusive) <= 0;
            string = this.fMaxInclusive.toString();
            if (string != null) {
                string5 = "<=";
            } else {
                string = "";
            }
        } else if (this.isMaxExclusiveDefined) {
            bl2 = bigDecimal.compareTo(this.fMaxExclusive) < 0;
            string = this.fMaxExclusive.toString();
            if (string != null) {
                string5 = "<";
            } else {
                string = "";
            }
        } else {
            boolean bl3 = bl2 = !this.isMaxInclusiveDefined && !this.isMaxExclusiveDefined;
        }
        if (this.isMinInclusiveDefined) {
            bl = bigDecimal.compareTo(this.fMinInclusive) >= 0;
            string3 = this.fMinInclusive.toString();
            if (string3 != null) {
                string4 = "<=";
            } else {
                string3 = "";
            }
        } else if (this.isMinExclusiveDefined) {
            bl = bigDecimal.compareTo(this.fMinExclusive) > 0;
            string3 = this.fMinExclusive.toString();
            if (string3 != null) {
                string4 = "<";
            } else {
                string3 = "";
            }
        } else {
            boolean bl4 = bl = !this.isMinInclusiveDefined && !this.isMinExclusiveDefined;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{bigDecimal.toString(), string3, string, string4, string5}));
        }
    }

    private void enumCheck(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < bigDecimalArray.length) {
            if (bigDecimal.equals(bigDecimalArray[n])) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{bigDecimal}));
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        try {
            BigDecimal bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
            BigDecimal bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2));
            return bigDecimal.compareTo(bigDecimal2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    private static String stripPlusIfPresent(String string) {
        String string2 = string;
        if (string.length() >= 2 && string.charAt(0) == '+' && string.charAt(1) != '-') {
            string2 = string.substring(1);
        }
        return string2;
    }

    private Hashtable checkForFacetConsistency(Hashtable hashtable, Hashtable hashtable2) throws InvalidDatatypeFacetException {
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable.get(string);
                if (string3 == null) {
                    String string4 = null;
                    hashtable.put(string, string2);
                    if (string.equals("maxExclusive") && hashtable.containsKey("maxInclusive")) {
                        string4 = (String)hashtable.get("maxInclusive");
                        bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string4));
                        if (bigDecimal.compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1) {
                            hashtable.remove(string);
                            continue;
                        }
                        hashtable.remove("maxInclusive");
                        continue;
                    }
                    if (string.equals("maxInclusive") && hashtable.containsKey("maxExclusive")) {
                        string4 = (String)hashtable.get("maxExclusive");
                        bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string4));
                        if (bigDecimal.compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1) {
                            hashtable.remove(string);
                            continue;
                        }
                        hashtable.remove("maxExclusive");
                        continue;
                    }
                    if (string.equals("minExclusive") && hashtable.containsKey("minInclusive")) {
                        string4 = (String)hashtable.get("minInclusive");
                        bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string4));
                        if (bigDecimal.compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == 1) {
                            hashtable.remove(string);
                            continue;
                        }
                        hashtable.remove("minInclusive");
                        continue;
                    }
                    if (!string.equals("minInclusive") || !hashtable.containsKey("minExclusive")) continue;
                    string4 = (String)hashtable.get("minExclusive");
                    bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string4));
                    if (bigDecimal.compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == 1) {
                        hashtable.remove(string);
                        continue;
                    }
                    hashtable.remove("minExclusive");
                    continue;
                }
                if (!(string.equals("maxExclusive") ? (bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string3))).compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1 : (string.equals("maxInclusive") ? (bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string3))).compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1 : (string.equals("minExclusive") ? (bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string3))).compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1 : !string.equals("minInclusive") || (bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string3))).compareTo(bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2))) == -1)))) continue;
            }
        }
        return hashtable;
    }
}

