/*
 * Created on Nov 7, 2003
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

import com.standbysoft.datepicker.DefaultMonthModel;
import com.standbysoft.datepicker.JMonthView;

/**
 * Shows how one can work with the month model used by JMonthView.
 */
public class DataModelDemo extends JPanel {
	private DefaultMonthModel model;
	private JMonthView monthView;
	private JLabel dowFirstLabel;
	private JComboBox dowFirstComboBox;

	public DataModelDemo() {
		model = new DefaultMonthModel();
		monthView = new JMonthView();
		
		dowFirstLabel = new JLabel("First Day of Week:");
		dowFirstComboBox = new JComboBox();
		dowFirstComboBox.addItem(new Integer(Calendar.SUNDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.MONDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.TUESDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.WEDNESDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.THURSDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.FRIDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.SATURDAY));
		dowFirstComboBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					Integer df = (Integer) dowFirstComboBox.getSelectedItem();
					model.setDowFirst(df.intValue());
				}
			}
		});
		dowFirstComboBox.setRenderer(new DefaultListCellRenderer() {
			private String DAY_NAMES[] = new DateFormatSymbols().getWeekdays();

			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				Integer day = (Integer) value;
				l.setText(DAY_NAMES[day.intValue()]);

				return l;
			}
		});
		
		setLayout(new GridBagLayout());
		add(monthView, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
	}

	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("DataModelDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		DataModelDemo newContentPane = new DataModelDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}