/*
 * Created on Nov 6, 2003
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.JMonthView;

/**
 * Shows how to set colors and font for JDatePicker and JMonthView.
 */
public class ColorsFontDemo extends JPanel {
	private JMonthView monthView;
	private JDatePicker datePicker;
	private JList fontsList;
	private JLabel foregroundLabel;
	private JButton foregroundButton;
	private JLabel titleBackgroundLabel;
	private JButton titleBackgroundButton;
	private JLabel titleForegroundLabel;
	private JButton titleForegroundButton;
	private JLabel trailingForegroundLabel;
	private JButton trailingForegroundButton;
	private JLabel monthBackgroundLabel;
	private JButton monthBackgroundButton;

	public ColorsFontDemo() {
		monthView = new JMonthView();
		datePicker = new JDatePicker();
		
		Vector fonts = new Vector();
		fonts.add(new Font("Serif", Font.PLAIN, 10));
		fonts.add(new Font("Arial", Font.PLAIN, 10));
		fonts.add(new Font("Serif", Font.PLAIN, 12));
		fonts.add(new Font("Arial", Font.ITALIC, 12));
		fonts.add(new Font("Courier", Font.PLAIN, 13));
		fonts.add(new Font("Serif", Font.PLAIN, 13));
		fonts.add(new Font("Arial", Font.PLAIN, 14));
		fontsList = new JList(fonts);
		
		fontsList.setVisibleRowCount(5);
		fontsList.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent evt) {
					Font font = (Font) fontsList.getSelectedValue();
					monthView.setFont(font);
					datePicker.setFont(font);
			}
		});
		fontsList.setCellRenderer(new DefaultListCellRenderer() {
			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				Font font = (Font) value;
				l.setFont(font);
				l.setText(font.getName() + " " + font.getSize());

				return l;
			}
		});
		JScrollPane fontsPane = new JScrollPane(fontsList);
		fontsPane.setBorder(new TitledBorder("Fonts"));
		
		foregroundLabel = new JLabel("Foreground:");
		foregroundButton = new JButton(" ");
		foregroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(ColorsFontDemo.this, "Choose Foreground", monthView.getForeground());
				if (color != null) {
					monthView.setForeground(color);
					datePicker.setCalendarForeground(color);
					foregroundButton.setBackground(monthView.getForeground());
				}
			}
		});
		foregroundButton.setBackground(monthView.getForeground());
		
		titleBackgroundLabel = new JLabel("Title Background:");
		titleBackgroundButton = new JButton(" ");
		titleBackgroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(ColorsFontDemo.this, "Choose Title Background", monthView.getTitleBackground());
				if (color != null) {
					monthView.setTitleBackground(color);
					datePicker.setCalendarTitleBackground(color);
					titleBackgroundButton.setBackground(monthView.getTitleBackground());
				}
			}
		});
		titleBackgroundButton.setBackground(monthView.getTitleBackground());
		
		titleForegroundLabel = new JLabel("Title Foreground:");
		titleForegroundButton = new JButton(" ");
		titleForegroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(ColorsFontDemo.this, "Choose Title Foreground", monthView.getTitleForeground());
				if (color != null) {
					monthView.setTitleForeground(color);
					datePicker.setCalendarTitleForeground(color);
					titleForegroundButton.setBackground(monthView.getTitleForeground());
				}
			}
		});
		titleForegroundButton.setBackground(monthView.getTitleForeground());
		
		trailingForegroundLabel = new JLabel("Trailing Foreground:");
		trailingForegroundButton = new JButton(" ");
		trailingForegroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(ColorsFontDemo.this, "Choose Trailing Foreground", monthView.getTrailingForeground());
				if (color != null) {
					monthView.setTrailingForeground(color);
					datePicker.setCalendarTrailingForeground(color);
					trailingForegroundButton.setBackground(monthView.getTrailingForeground());
				}
			}
		});
		trailingForegroundButton.setBackground(monthView.getTrailingForeground());
		
		monthBackgroundLabel = new JLabel("Month Background:");
		monthBackgroundButton = new JButton(" ");
		monthBackgroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Color color = JColorChooser.showDialog(ColorsFontDemo.this, "Choose Month Background", monthView.getMonthBackground());
				if (color != null) {
					monthView.setMonthBackground(color);
					datePicker.setCalendarBackground(color);
					monthBackgroundButton.setBackground(monthView.getMonthBackground());
				}
			}
		});
		monthBackgroundButton.setBackground(monthView.getMonthBackground());
		
		setLayout(new GridBagLayout());
		add(monthView, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(datePicker, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(fontsPane, new GridBagConstraints(1, 0, 2, 2, 1.0, 1.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		add(foregroundLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(foregroundButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(titleBackgroundLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(titleBackgroundButton, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(titleForegroundLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(titleForegroundButton, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(trailingForegroundLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(trailingForegroundButton, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(monthBackgroundLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(monthBackgroundButton, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
	}

	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("UIDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		ColorsFontDemo newContentPane = new ColorsFontDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}