/*
 * Decompiled with CFR 0.152.
 */
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

class VirtualClass
implements Runnable {
    public static long count;
    private String name;
    private String address;
    private int currentService;
    private int port;
    private boolean STATUS;
    private boolean STATE_CHANGE;
    private boolean LOGGING;
    private boolean RUNNING;
    private int STICKY;
    private Vector s;
    private Vector clientConnections;
    private Vector serverConnections;
    public Vector connections;
    public Vector stickyconnections;
    private String status;
    private loadbalanced m;
    private ServerSocket virtualserv;
    private Socket clientsock;

    public VirtualClass() {
        this.STATUS = true;
        this.STATE_CHANGE = false;
        this.RUNNING = false;
        this.LOGGING = true;
        this.STICKY = 0;
        this.currentService = 0;
        this.status = new String("active");
        this.s = new Vector(5, 1);
        this.clientConnections = new Vector(256, 256);
        this.serverConnections = new Vector(256, 256);
        this.connections = new Vector(256, 256);
        this.stickyconnections = new Vector(256, 256);
    }

    public VirtualClass(loadbalanced loadbalanced2) {
        this.m = loadbalanced2;
        this.STATUS = true;
        this.STATE_CHANGE = false;
        this.RUNNING = false;
        this.LOGGING = loadbalanced.THREAD_LOGGING;
        this.STICKY = 0;
        this.currentService = 0;
        this.status = new String("active");
        this.s = new Vector(5, 1);
        this.clientConnections = new Vector(256, 256);
        this.serverConnections = new Vector(256, 256);
        this.connections = new Vector(256, 256);
        this.stickyconnections = new Vector(256, 256);
    }

    public VirtualClass(loadbalanced loadbalanced2, String string) {
        this.m = loadbalanced2;
        this.name = string;
        this.currentService = 0;
        this.STATUS = true;
        this.STATE_CHANGE = false;
        this.RUNNING = false;
        this.LOGGING = loadbalanced.THREAD_LOGGING;
        this.STICKY = 0;
        this.status = new String("active");
        this.s = new Vector(5, 1);
        this.clientConnections = new Vector(256, 256);
        this.serverConnections = new Vector(256, 256);
        this.connections = new Vector(256, 256);
        this.stickyconnections = new Vector(256, 256);
    }

    public VirtualClass(loadbalanced loadbalanced2, String string, int n) {
        this.address = string;
        this.port = n;
        this.STATUS = true;
        this.STATE_CHANGE = false;
        this.RUNNING = false;
        this.STICKY = 0;
        this.currentService = 0;
        this.m = loadbalanced2;
        this.status = new String("active");
        this.s = new Vector(5, 1);
        this.clientConnections = new Vector(256, 256);
        this.serverConnections = new Vector(256, 256);
        this.connections = new Vector(256, 256);
        this.stickyconnections = new Vector(256, 256);
    }

    public void run() {
        block8: {
            try {
                this.virtualserv = new ServerSocket(this.port, 1000, InetAddress.getByName(this.address));
                while (this.RUNNING) {
                    this.clientsock = this.virtualserv.accept();
                    if (this.LOGGING) {
                        this.m.logEvent("Virtual Server " + this.name + " accepted connection " + count + " from " + this.clientsock.getInetAddress().getHostAddress() + ":" + this.clientsock.getPort());
                    }
                    this.connections.add(new ServiceClient(this.m, this, this.clientsock, count++));
                }
            }
            catch (BindException bindException) {
                if (this.LOGGING) {
                    this.m.logEvent("Virtual Server " + this.name + " cannot bind to " + this.address);
                }
                this.shutdown();
            }
            catch (SocketException socketException) {
                if (this.LOGGING) {
                    this.m.logEvent("Virtual Server " + this.name + " closed listening socket");
                }
            }
            catch (Exception exception) {
                if (!this.LOGGING) break block8;
                this.m.logEvent("Virtual Server " + this.name + " run():" + exception);
            }
        }
    }

    public void start() {
        this.RUNNING = true;
        if (this.LOGGING) {
            this.m.logEvent("Starting virtual server thread: " + this.name);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void halt() {
        block4: {
            if (this.LOGGING) {
                this.m.logEvent("Halting virtual server thread: " + this.name);
            }
            try {
                this.virtualserv.close();
            }
            catch (Exception exception) {
                if (!this.LOGGING) break block4;
                this.m.logEvent("VirtualClass " + this.name + " halt():" + exception);
            }
        }
        int n = 0;
        while (n < this.connections.size()) {
            ServiceClient serviceClient = (ServiceClient)this.connections.elementAt(n);
            serviceClient.halt();
            ++n;
        }
        this.RUNNING = false;
    }

    public synchronized void addService(ServiceClass serviceClass) {
        this.s.add(serviceClass);
    }

    public synchronized void delService(int n) {
        this.s.remove(n);
    }

    public int getCapacity() {
        return this.s.capacity();
    }

    public void setVirtualName(String string) {
        this.name = string;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public synchronized void stateChanged() {
        this.STATE_CHANGE = true;
    }

    public synchronized void setStateChanged(boolean bl) {
        this.STATE_CHANGE = bl;
    }

    public synchronized boolean isStateChanged() {
        return this.STATE_CHANGE;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public synchronized void activate() {
        if (!this.status.equals("active")) {
            this.STATUS = true;
            this.status = "active";
            if (this.LOGGING) {
                this.m.logEvent("Virtual Server " + this.name + " changed state to active");
            }
            this.start();
        }
    }

    public synchronized void shutdown() {
        if (this.status.equals("active")) {
            this.STATUS = false;
            this.status = "shutdown";
            if (this.LOGGING) {
                this.m.logEvent("Virtual Server " + this.name + " changed state to administratively shutdown");
            }
            this.halt();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public long getCount() {
        return count;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getVirtualName() {
        return this.name;
    }

    public String getServices() {
        String string = new String();
        int n = 0;
        while (n < this.s.size()) {
            string = string + " " + ((ServiceClass)this.s.elementAt(n)).getName() + "\r\n";
            ++n;
        }
        return string;
    }

    public String getConfigServices() {
        String string = new String();
        int n = 0;
        while (n < this.s.size()) {
            string = string + " add " + ((ServiceClass)this.s.elementAt(n)).getName() + "\r\n";
            ++n;
        }
        return string;
    }

    public ServiceClass getNextService() {
        boolean bl = false;
        ServiceClass serviceClass = null;
        int n = 0;
        while (!bl) {
            serviceClass = (ServiceClass)this.s.elementAt(this.currentService++);
            if (this.currentService >= this.s.size()) {
                this.currentService = 0;
            }
            if (serviceClass.getStatus().equals("active")) {
                bl = true;
            }
            if (++n <= this.s.size()) continue;
            serviceClass = null;
            break;
        }
        return serviceClass;
    }

    public void setStickyTime(int n) {
        this.STICKY = n;
    }

    public int getSticky() {
        return this.STICKY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceClass getStickyService(String string) {
        try {
            int n = 0;
            while (n < this.stickyconnections.size()) {
                Sticky sticky = (Sticky)this.stickyconnections.elementAt(n);
                ServiceClass serviceClass = sticky.getServiceClass();
                if (string.equals(sticky.getAddress())) {
                    long l = System.currentTimeMillis();
                    if (l < sticky.getExpireTime() && serviceClass.getStatus().equals("active")) {
                        sticky.incStickyHits();
                        return serviceClass;
                    }
                    return this.getNextService();
                }
                ++n;
            }
            long l = System.currentTimeMillis();
            ServiceClass serviceClass = this.getNextService();
            Vector vector = this.stickyconnections;
            synchronized (vector) {
                this.stickyconnections.add(new Sticky(serviceClass, string, this.STICKY));
            }
            return serviceClass;
        }
        catch (Exception exception) {
            this.m.logEvent("Virtual Class " + this.name + " caught exception " + exception);
            return null;
        }
    }
}

