/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDElementTraverser
extends XSDAbstractTraverser {
    protected XSElementDecl fTempElementDecl = new XSElementDecl();
    protected XSParticleDecl fTempParticleDecl = new XSParticleDecl();
    boolean fDeferTraversingLocalElements;

    XSDElementTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseLocal(Element elmDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags) {
        XSParticleDecl particle = new XSParticleDecl();
        if (this.fDeferTraversingLocalElements) {
            this.fSchemaHandler.fillInLocalElemInfo(elmDecl, schemaDoc, allContextFlags, particle);
        } else {
            this.traverseLocal(particle, elmDecl, schemaDoc, grammar, allContextFlags);
        }
        return particle;
    }

    protected void traverseLocal(XSParticleDecl particle, Element elmDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmDecl, false, schemaDoc);
        QName refAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XInt minAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS];
        XInt maxAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS];
        XSElementDecl element = null;
        if (elmDecl.getAttributeNode(SchemaSymbols.ATT_REF) != null) {
            if (refAtt != null) {
                element = (XSElementDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 3, refAtt);
                Element child = DOMUtil.getFirstChildElement(elmDecl);
                if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                    child = DOMUtil.getNextSiblingElement(child);
                }
                if (child != null) {
                    this.reportSchemaError("src-element.2.2", new Object[]{refAtt});
                }
            } else {
                element = null;
            }
        } else {
            element = this.traverseNamedElement(elmDecl, attrValues, schemaDoc, grammar, false);
        }
        particle.fMinOccurs = minAtt.intValue();
        particle.fMaxOccurs = maxAtt.intValue();
        if (element != null) {
            particle.fType = 1;
            particle.fValue = element;
        }
        Long defaultVals = (Long)attrValues[XSAttributeChecker.ATTIDX_FROMDEFAULT];
        this.checkOccurrences(particle, SchemaSymbols.ELT_ELEMENT, (Element)elmDecl.getParentNode(), allContextFlags, defaultVals);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }

    XSElementDecl traverseGlobal(Element elmDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmDecl, true, schemaDoc);
        XSElementDecl element = this.traverseNamedElement(elmDecl, attrValues, schemaDoc, grammar, true);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (element != null) {
            element.setIsGlobal();
        }
        return element;
    }

    XSElementDecl traverseNamedElement(Element elmDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar, boolean isGlobal) {
        String childName;
        Element child;
        Boolean abstractAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt blockAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_BLOCK];
        String defaultAtt = (String)attrValues[XSAttributeChecker.ATTIDX_DEFAULT];
        XInt finalAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        String fixedAtt = (String)attrValues[XSAttributeChecker.ATTIDX_FIXED];
        XInt formAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FORM];
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        Boolean nillableAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_NILLABLE];
        QName subGroupAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_SUBSGROUP];
        QName typeAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_TYPE];
        XSElementDecl element = new XSElementDecl();
        if (nameAtt != null) {
            element.fName = this.fSymbolTable.addSymbol(nameAtt);
        }
        element.fTargetNamespace = isGlobal ? schemaDoc.fTargetNamespace : (formAtt != null ? (formAtt.intValue() == 1 ? schemaDoc.fTargetNamespace : null) : (schemaDoc.fAreLocalElementsQualified ? schemaDoc.fTargetNamespace : null));
        element.fBlock = blockAtt == null ? schemaDoc.fBlockDefault : blockAtt.shortValue();
        short s = element.fFinal = finalAtt == null ? schemaDoc.fFinalDefault : finalAtt.shortValue();
        if (nillableAtt.booleanValue()) {
            element.setIsNillable();
        }
        if (abstractAtt != null && abstractAtt.booleanValue()) {
            element.setIsAbstract();
        }
        if (fixedAtt != null) {
            element.fDefault = new ValidatedInfo();
            element.fDefault.normalizedValue = fixedAtt;
            element.setConstraintType((short)2);
        } else if (defaultAtt != null) {
            element.fDefault = new ValidatedInfo();
            element.fDefault.normalizedValue = defaultAtt;
            element.setConstraintType((short)1);
        } else {
            element.setConstraintType((short)0);
        }
        if (subGroupAtt != null) {
            element.fSubGroup = (XSElementDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 3, subGroupAtt);
        }
        if ((child = DOMUtil.getFirstChildElement(elmDecl)) != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        XSTypeDecl elementType = null;
        boolean haveAnonType = false;
        if (child != null) {
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                elementType = this.fSchemaHandler.fComplexTypeTraverser.traverseLocal(child, schemaDoc, grammar);
                haveAnonType = true;
                child = DOMUtil.getNextSiblingElement(child);
            } else if (childName.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                elementType = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(child, schemaDoc, grammar);
                haveAnonType = true;
                child = DOMUtil.getNextSiblingElement(child);
            }
        }
        if (elementType == null && typeAtt != null) {
            elementType = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, typeAtt);
        }
        if (elementType == null && element.fSubGroup != null) {
            elementType = element.fSubGroup.fType;
        }
        if (elementType == null) {
            elementType = SchemaGrammar.fAnyType;
        }
        element.fType = elementType;
        if (child != null) {
            childName = DOMUtil.getLocalName(child);
            while (child != null && (childName.equals(SchemaSymbols.ELT_KEY) || childName.equals(SchemaSymbols.ELT_KEYREF) || childName.equals(SchemaSymbols.ELT_UNIQUE))) {
                if (childName.equals(SchemaSymbols.ELT_KEY) || childName.equals(SchemaSymbols.ELT_UNIQUE)) {
                    DOMUtil.setHidden(child);
                    this.fSchemaHandler.fUniqueOrKeyTraverser.traverse(child, element, schemaDoc, grammar);
                    if (DOMUtil.getAttrValue(child, SchemaSymbols.ATT_NAME).length() != 0) {
                        this.fSchemaHandler.checkForDuplicateNames(schemaDoc.fTargetNamespace == null ? "," + DOMUtil.getAttrValue(child, SchemaSymbols.ATT_NAME) : schemaDoc.fTargetNamespace + "," + DOMUtil.getAttrValue(child, SchemaSymbols.ATT_NAME), this.fSchemaHandler.getIDRegistry(), child, schemaDoc);
                    }
                } else if (childName.equals(SchemaSymbols.ELT_KEYREF)) {
                    this.fSchemaHandler.storeKeyRef(child, schemaDoc, element);
                }
                if ((child = DOMUtil.getNextSiblingElement(child)) == null) continue;
                childName = DOMUtil.getLocalName(child);
            }
        }
        if (isGlobal && nameAtt != null) {
            grammar.addGlobalElementDecl(element);
        }
        if (nameAtt == null) {
            if (isGlobal) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_ELEMENT, SchemaSymbols.ATT_NAME});
            } else {
                this.reportSchemaError("src-element.2.1", null);
            }
            nameAtt = "(no name)";
        }
        if (child != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{nameAtt, "(annotation?, (simpleType | complexType)?, (unique | key | keyref)*))"});
        }
        if (defaultAtt != null && fixedAtt != null) {
            this.reportSchemaError("src-element.1", new Object[]{nameAtt});
        }
        if (haveAnonType && typeAtt != null) {
            this.reportSchemaError("src-element.3", new Object[]{nameAtt});
        }
        this.checkNotationType(nameAtt, elementType);
        if (element.fDefault != null) {
            this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
            XSConstraints.ElementDefaultValidImmediate(element.fType, element.fDefault.normalizedValue, this.fValidationState, element.fDefault);
            if (element.fDefault.actualValue == null) {
                this.reportSchemaError("e-props-correct.2", new Object[]{nameAtt, element.fDefault.normalizedValue});
                element.setConstraintType((short)0);
            }
        }
        if (element.fSubGroup != null && !XSConstraints.checkTypeDerivationOk(element.fType, element.fSubGroup.fType, element.fSubGroup.fFinal)) {
            this.reportSchemaError("e-props-correct.3", new Object[]{nameAtt, subGroupAtt.prefix + ":" + subGroupAtt.localpart});
        }
        if (element.fDefault != null && (elementType.getXSType() == 2 && ((XSSimpleType)elementType).isIDType() || elementType.getXSType() == 1 && ((XSComplexTypeDecl)elementType).containsTypeID())) {
            this.reportSchemaError("e-props-correct.4", new Object[]{element.fName});
        }
        return element;
    }

    void reset(XMLErrorReporter reporter, SymbolTable symbolTable) {
        super.reset(reporter, symbolTable);
        this.fDeferTraversingLocalElements = true;
    }
}

