/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;
import org.apache.xerces.util.XMLChar;

public class IDREFDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private Hashtable fTableOfId = null;
    private Hashtable fTableIDRefs = null;
    private Object fNullValue = null;
    private Locale fLocale = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.setBasetype(base);
    }

    public void validate(String content, Object state) throws InvalidDatatypeValueException {
        if (!XMLChar.isValidName(content)) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
            error.setKeyIntoReporter("IDREFInvalid");
            throw error;
        }
        this.addIdRef(content, state);
    }

    public void validate() throws InvalidDatatypeValueException {
        this.checkIdRefs();
    }

    public void initialize(Object tableOfIDs) {
        if (this.fTableIDRefs != null) {
            this.fTableIDRefs.clear();
        } else {
            this.fTableIDRefs = new Hashtable();
        }
        this.fTableOfId = (Hashtable)tableOfIDs;
    }

    public int compare(String content1, String content2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void setBasetype(DatatypeValidator base) {
        this.fBaseValidator = base;
    }

    private void addIdRef(String content, Object state) {
        if (this.fTableOfId != null && this.fTableOfId.containsKey(content)) {
            return;
        }
        if (this.fTableIDRefs == null) {
            this.fTableIDRefs = new Hashtable();
        } else if (this.fTableIDRefs.containsKey(content)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableIDRefs.put(content, this.fNullValue);
        }
        catch (OutOfMemoryError ex) {
            System.out.println("Out of Memory: Hashtable of ID's has " + this.fTableIDRefs.size() + " Elements");
            ex.printStackTrace();
        }
    }

    private void checkIdRefs() throws InvalidDatatypeValueException {
        if (this.fTableIDRefs == null) {
            return;
        }
        Enumeration en = this.fTableIDRefs.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (this.fTableOfId != null && this.fTableOfId.containsKey(key)) continue;
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(key);
            error.setKeyIntoReporter("MSG_ELEMENT_WITH_ID_REQUIRED");
            throw error;
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object getInternalStateInformation() {
        return null;
    }

    private String getErrorString(int major, int minor, Object[] args) {
        return this.fMessageProvider.formatMessage(this.fLocale, null, null);
    }
}

