<%
    /*********************************************************/
    /*****  Category Information Page (TEMPLATE=CATDES)  *****/
    /*****  Show category images, descriptions, and a    *****/ 
    /*****  list box of subcategories or items under     *****/
    /*****  this category.                               *****/ 
    /*********************************************************/
%>

<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    String cat_name="", leaf_cat="N", image1="", image2="", cat_des="";
    if (id == 0)
    {
      cat_name = "List of Main Categories";
      leaf_cat = "N";
    }
    else
    {
      Category this_cat = CategoryBean.getCategory(id, language);
      cat_name = this_cat.getCatName();
      leaf_cat = this_cat.getLeafCat();
      image1 = this_cat.getCatImage1();
      image2 = this_cat.getCatImage2();
      cat_des = Util.encodeHTML(Util.addBR(this_cat.getCatDes()));
    }

    /*** Get list of sub-categories or items under this category. ***/
    int num_of_row=0;
    String child_title="";
    if (leaf_cat.equals("Y"))
    {
      ItemBean.refreshList(id, language);
      num_of_row = ItemBean.getListSize();
      child_title = "Items:";
    }
    else
    {
      CategoryBean.refreshList(id, language); 
      num_of_row = CategoryBean.getListSize();
      child_title = "Sub-Categories:";
    }
%>

<script language="JavaScript">
<!--
    function changePage(obj) 
    {
      i = obj.selectedIndex;
      {
        window.parent.location = obj.options[i].value;
      }
    }
// -->
</script>


<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr>
    <td valign="top" align="left" colspan="2">
      <font size="4" face="Arial"><strong><%= cat_name %></strong></font>
    </td>
  </tr>



<%
      /**************************************/
      /***** Sub-category or Item List ******/
      /**************************************/
%>

  <tr>
    <td valign="top" align="left" nowrap><b><%= child_title %>&nbsp;</b></td>
    <td valign="top" align="left" width="2000">
      <form enctype="application/x-www-form-urlencoded" name="URLGo">
      <select name="item" onChange="changePage(this.form.item)" size="1">
          <option selected>Please choose</option>
<%
    for (int i=0; i<num_of_row; i++)
    {
      String name = "", link="";
      if (leaf_cat.equals("Y"))
      {
        Item item = ItemBean.getItemAt(i);
        name = item.getItemName();
        link = new String("Product.jsp?Type=ITEM&ID=" + item.getItemID());
      }
      else
      {
        Category subcat = CategoryBean.getCategoryAt(i); 
        name = subcat.getCatName();
        link = new String("Product.jsp?Type=CAT&ID=" + subcat.getCatID());
      }
%>
          <option value="<%= link %>"><%= name %></option>
<%
    }
%>
      </select>
      </form>
    </td>
  </tr>


<%
      /***************************************/
      /*********** Category Images ***********/
      /***************************************/

      if (! Util.isMissing(image1) || ! Util.isMissing(image2)) 
      {
%>
  <tr>
    <td valign="top" align="left" colspan="2">
<%
        if (! Util.isMissing(image1)) {
%>
        <img src="../pimages/<%= image1 %>" width="150" height="150" hspace="0">
<%
        }
        if (! Util.isMissing(image2)) {
%>
        <img src="../pimages/<%= image2 %>" width="150" height="150" hspace="0">
<%
        }
%>
    </td>
  </tr>
  <tr><td valign="top" align="left" colspan="2">&nbsp;</td></tr>
<%
      }
%>


<%
      /***************************************/
      /******** Category Description *********/
      /***************************************/

      if (! Util.isMissing(cat_des)) 
      {
%>
  <tr>
    <td valign="top" align="left" colspan="2">
      <p><%= cat_des %></p>
    </td>
  </tr>
<%
      }
%>


</table>
