/*
 * Decompiled with CFR 0.152.
 */
package com.kplab.webeasy;

import com.kplab.webeasy.MemberBean;
import com.kplab.webeasy.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MemberUpdateServlet
extends HttpServlet {
    static final int OK = 0;
    static final int FAILED = 1;
    static final int NEWUSER = 0;
    static final int OLDUSER = 1;
    String member_page;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.member_page = Util.getMemberPage();
    }

    public void destroy() {
        super.destroy();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n = 1;
        String string = null;
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession.getValue("UserID") == null) {
            if (!this.validateNewUser(httpServletRequest, httpServletResponse)) {
                return;
            }
            if (!this.validateFields(httpServletRequest, httpServletResponse)) {
                return;
            }
            string = httpServletRequest.getParameter("UserID");
            n = this.update(httpServletRequest, 0, string);
        } else {
            if (!this.validateFields(httpServletRequest, httpServletResponse)) {
                return;
            }
            string = (String)httpSession.getValue("UserID");
            n = this.update(httpServletRequest, 1, string);
        }
        if (n == 0) {
            httpSession.removeValue("UserID");
            httpSession.removeValue("FirstName");
            httpSession.removeValue("Language");
            httpSession.putValue("UserID", (Object)string);
            httpSession.putValue("FirstName", (Object)httpServletRequest.getParameter("FirstName"));
            httpSession.putValue("Language", (Object)httpServletRequest.getParameter("Language"));
            Util.gotoPage(this.member_page, "Status=UPDATESUCCESS", httpServletRequest, httpServletResponse);
            return;
        }
        Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=RETRY_LATER", httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    private boolean validateNewUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (Util.isMissing(httpServletRequest.getParameter("UserID"))) {
            Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=MISSING_PARM", httpServletRequest, httpServletResponse);
            return false;
        }
        MemberBean memberBean = new MemberBean();
        String string = httpServletRequest.getParameter("UserID");
        MemberBean.Member member = memberBean.getMember(string);
        if (!Util.isMissing(member.getUserID())) {
            Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=USED_ID", httpServletRequest, httpServletResponse);
            return false;
        }
        return true;
    }

    private boolean validateFields(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        int n = 0;
        if (!Util.isMissing(httpServletRequest.getParameter("BirthYear"))) {
            try {
                n = Integer.parseInt(httpServletRequest.getParameter("BirthYear"));
            }
            catch (NumberFormatException numberFormatException) {
                Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=INVALID_BIRTH_YEAR", httpServletRequest, httpServletResponse);
                return false;
            }
            if (n < 1800 || n > 2100) {
                Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=INVALID_BIRTH_YEAR", httpServletRequest, httpServletResponse);
                return false;
            }
        }
        if (Util.isMissing(httpServletRequest.getParameter("Password1")) || Util.isMissing(httpServletRequest.getParameter("Password2")) || Util.isMissing(httpServletRequest.getParameter("FirstName")) || Util.isMissing(httpServletRequest.getParameter("Email")) || Util.isMissing(httpServletRequest.getParameter("Question")) || Util.isMissing(httpServletRequest.getParameter("Answer"))) {
            Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=MISSING_PARM", httpServletRequest, httpServletResponse);
            return false;
        }
        if (httpServletRequest.getParameter("Language").equals("0")) {
            Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=MISSING_PARM", httpServletRequest, httpServletResponse);
            return false;
        }
        String string2 = httpServletRequest.getParameter("Password1");
        if (!string2.equals(string = httpServletRequest.getParameter("Password2"))) {
            Util.gotoPage(this.member_page, "Status=UPDATEFAILED&Error=MISMATCH_PASSWORD", httpServletRequest, httpServletResponse);
            return false;
        }
        return true;
    }

    private int update(HttpServletRequest httpServletRequest, int n, String string) {
        int n2 = 1;
        String string2 = httpServletRequest.getParameter("BirthYear");
        String string3 = httpServletRequest.getParameter("Password1");
        String string4 = httpServletRequest.getParameter("FirstName");
        String string5 = httpServletRequest.getParameter("LastName");
        String string6 = httpServletRequest.getParameter("Question");
        String string7 = httpServletRequest.getParameter("Answer");
        String string8 = httpServletRequest.getParameter("Email");
        String string9 = httpServletRequest.getParameter("Phone");
        String string10 = httpServletRequest.getParameter("Address");
        int n3 = Integer.parseInt(httpServletRequest.getParameter("Gender"));
        int n4 = Integer.parseInt(httpServletRequest.getParameter("Language"));
        int n5 = Integer.parseInt(httpServletRequest.getParameter("Country"));
        int n6 = Integer.parseInt(httpServletRequest.getParameter("Occupation"));
        int n7 = Integer.parseInt(httpServletRequest.getParameter("Income"));
        int n8 = Integer.parseInt(httpServletRequest.getParameter("Education"));
        int n9 = Integer.parseInt(httpServletRequest.getParameter("Household"));
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = Util.getConnection();
                if (n == 0) {
                    String string11 = new String("INSERT INTO MEMBER (USER_ID, PASSWORD, FIRSTNAME, LASTNAME, BIRTH_YEAR, GENDER, LANGUAGE, COUNTRY, OCCUPATION, INCOME, EDUCATION, HOUSEHOLD, EMAIL, PHONE, ADDRESS, HINT_QUESTION, HINT_ANSWER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    statement = connection.prepareStatement(string11);
                    statement.setString(1, string);
                    statement.setString(2, string3);
                    statement.setString(3, string4);
                    if (Util.isMissing(string5)) {
                        statement.setNull(4, 12);
                    } else {
                        statement.setString(4, string5);
                    }
                    if (Util.isMissing(string2)) {
                        statement.setNull(5, 12);
                    } else {
                        statement.setString(5, string2);
                    }
                    statement.setInt(6, n3);
                    statement.setInt(7, n4);
                    statement.setInt(8, n5);
                    statement.setInt(9, n6);
                    statement.setInt(10, n7);
                    statement.setInt(11, n8);
                    statement.setInt(12, n9);
                    statement.setString(13, string8);
                    if (Util.isMissing(string9)) {
                        statement.setNull(14, 12);
                    } else {
                        statement.setString(14, string9);
                    }
                    if (Util.isMissing(string10)) {
                        statement.setNull(15, 12);
                    } else {
                        statement.setString(15, string10);
                    }
                    statement.setString(16, string6);
                    statement.setString(17, string7);
                } else {
                    String string12 = new String("UPDATE MEMBER SET PASSWORD = ?, FIRSTNAME = ?, LASTNAME = ?, BIRTH_YEAR = ?, GENDER = ?, LANGUAGE = ?, COUNTRY = ?, OCCUPATION = ?, INCOME = ?, EDUCATION = ?, HOUSEHOLD = ?, EMAIL = ?, PHONE = ?, ADDRESS = ?, HINT_QUESTION = ?, HINT_ANSWER = ? WHERE USER_ID= ?");
                    statement = connection.prepareStatement(string12);
                    statement.setString(1, string3);
                    statement.setString(2, string4);
                    if (Util.isMissing(string5)) {
                        statement.setNull(3, 12);
                    } else {
                        statement.setString(3, string5);
                    }
                    if (Util.isMissing(string2)) {
                        statement.setNull(4, 12);
                    } else {
                        statement.setString(4, string2);
                    }
                    statement.setInt(5, n3);
                    statement.setInt(6, n4);
                    statement.setInt(7, n5);
                    statement.setInt(8, n6);
                    statement.setInt(9, n7);
                    statement.setInt(10, n8);
                    statement.setInt(11, n9);
                    statement.setString(12, string8);
                    if (Util.isMissing(string9)) {
                        statement.setNull(13, 12);
                    } else {
                        statement.setString(13, string9);
                    }
                    if (Util.isMissing(string10)) {
                        statement.setNull(14, 12);
                    } else {
                        statement.setString(14, string10);
                    }
                    statement.setString(15, string6);
                    statement.setString(16, string7);
                    statement.setString(17, string);
                }
                statement.executeUpdate();
                connection.commit();
                n2 = 0;
            }
            catch (Exception exception) {
                Util.log("MemberUpdateServlet.update(): JDBC update error. " + exception.toString());
                n2 = 1;
            }
            Object var25_27 = null;
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {}
        return n2;
    }
}

