#include <gtk/gtk.h>
#include "parse.h"
#include "block.h"
#include "blist.hh"
#include "hcom.hh"
#include "conf.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "adb.h"

GtkWidget *conf_dialog;
GtkWidget *useproxy_w, *hostname_w, *proxyport_w, *allownonlocal_w,
 *listenport_w, *autochecknever_w, *autocheckstart_w, *autocheckfirst_w,
 *stealth_mode_w, *max_connection_tries_w;

void confdlg_ok(GtkWidget *widget, gpointer data)
{
  use_proxy = GTK_TOGGLE_BUTTON(useproxy_w)->active;
  strncpy(proxy_hostname, gtk_entry_get_text(GTK_ENTRY(hostname_w)), 256);
  proxy_port = atoi(gtk_entry_get_text(GTK_ENTRY(proxyport_w)));
  allow_nonlocal = GTK_TOGGLE_BUTTON(allownonlocal_w)->active;
  if (GTK_TOGGLE_BUTTON(autochecknever_w)->active)
    auto_update = 0;
  else if (GTK_TOGGLE_BUTTON(autocheckstart_w)->active)
    auto_update = 1;
  else if (GTK_TOGGLE_BUTTON(autocheckfirst_w)->active)
    auto_update = 2;
  int l2 = atoi(gtk_entry_get_text(GTK_ENTRY(listenport_w)));
  if (l2 && l2 != listen_port) {
    listen_port = l2;
    listen_port_changed = true;
  }
  stealth_mode = GTK_TOGGLE_BUTTON(stealth_mode_w)->active;
  GtkAdjustment *a = gtk_range_get_adjustment(GTK_RANGE(max_connection_tries_w));
  max_connection_tries = int(a->value);
  SaveConf();  
  gtk_grab_remove(conf_dialog);
  gtk_widget_hide(conf_dialog);
  gtk_widget_destroy(conf_dialog);    
}

void confdlg()
{
  GtkWidget *d = gtk_dialog_new();
  conf_dialog = d;
  gtk_window_set_title (GTK_WINDOW (d), "Configuration");
  gtk_container_border_width (GTK_CONTAINER (d), 10);
  GtkWidget *vbox = GTK_WIDGET(GTK_DIALOG (d)->vbox);
  GtkWidget *l;
    
  useproxy_w = gtk_check_button_new_with_label("Use proxy");
  gtk_box_pack_start (GTK_BOX (vbox), useproxy_w, TRUE, TRUE, 0);
  gtk_widget_show(useproxy_w);
  
  GtkWidget *hbox = gtk_hbox_new(FALSE, 1);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);  
  l = gtk_label_new("Hostname:");
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_widget_show(l);
  hostname_w = gtk_entry_new_with_max_length(200);
  gtk_box_pack_start (GTK_BOX (hbox), hostname_w, TRUE, TRUE, 0);
  gtk_widget_show(hostname_w);
  l = gtk_label_new("port:");
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_widget_show(l);
  proxyport_w = gtk_entry_new_with_max_length(200);
  gtk_box_pack_start (GTK_BOX (hbox), proxyport_w, TRUE, TRUE, 0);
  gtk_widget_show(proxyport_w);

  GtkWidget *separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);  
  
  allownonlocal_w = gtk_check_button_new_with_label("Allow non-local clients");
  gtk_box_pack_start (GTK_BOX (vbox), allownonlocal_w, TRUE, TRUE, 0);
  gtk_widget_show(allownonlocal_w);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);
  
  hbox = gtk_hbox_new(FALSE, 1);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
  l = gtk_label_new("Ad Buster's listen port:");
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_widget_show(l);
  listenport_w = gtk_entry_new_with_max_length(200);
  gtk_box_pack_start (GTK_BOX (hbox), listenport_w, TRUE, TRUE, 0);
  gtk_widget_show(listenport_w);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);

  hbox = gtk_hbox_new(FALSE, 1);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
  l = gtk_label_new("Automatic check for update:");
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_widget_show(l);
  GtkWidget *vbox2 = gtk_vbox_new(FALSE, 1);
  gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 0);
  gtk_widget_show(vbox2);
  autochecknever_w = gtk_radio_button_new_with_label(0, "Never");
  gtk_box_pack_start (GTK_BOX (vbox2), autochecknever_w, TRUE, TRUE, 0);
  gtk_widget_show(autochecknever_w);
  GSList *group = gtk_radio_button_group (GTK_RADIO_BUTTON (autochecknever_w));
  autocheckstart_w = gtk_radio_button_new_with_label(group, "At startup");
  gtk_box_pack_start (GTK_BOX (vbox2), autocheckstart_w, TRUE, TRUE, 0);
  gtk_widget_show(autocheckstart_w);
  group = gtk_radio_button_group (GTK_RADIO_BUTTON (autocheckstart_w));
  autocheckfirst_w = gtk_radio_button_new_with_label(group, "After first successfull request");
  gtk_box_pack_start (GTK_BOX (vbox2), autocheckfirst_w, TRUE, TRUE, 0);
  gtk_widget_show(autocheckfirst_w);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);  
  
  stealth_mode_w = gtk_check_button_new_with_label("Stealth mode");
  gtk_box_pack_start (GTK_BOX (vbox), stealth_mode_w, TRUE, TRUE, 0);
  gtk_widget_show(stealth_mode_w);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);  

  hbox = gtk_hbox_new(FALSE, 1);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
  l = gtk_label_new("Max. connection tries:");
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_widget_show(l);  
  GtkObject *adj1 = gtk_adjustment_new (max_connection_tries, 1.0, 101.0, 1.0, 1.0, 1.0);
  max_connection_tries_w = gtk_hscale_new(GTK_ADJUSTMENT(adj1));
  gtk_box_pack_start (GTK_BOX (hbox), max_connection_tries_w, TRUE, TRUE, 0);
  gtk_scale_set_digits(GTK_SCALE(max_connection_tries_w), 0);
  gtk_widget_show(max_connection_tries_w);
  
  GtkWidget *  button = gtk_button_new_with_label("OK");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG (d)->action_area), button,
		      TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button),
		      "clicked", (GtkSignalFunc) confdlg_ok,
		      0); 
  gtk_widget_show (button);  
  button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG (d)->action_area), button,
		      TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (d));  
  gtk_widget_show (button);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(useproxy_w), use_proxy);
  gtk_entry_set_text(GTK_ENTRY(hostname_w), proxy_hostname);
  char pp[100];
  g_snprintf(pp, sizeof(pp), "%d", proxy_port);
  gtk_entry_set_text(GTK_ENTRY(proxyport_w), pp);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(allownonlocal_w), allow_nonlocal);
  GtkWidget *b = (auto_update ? (auto_update == 1 ? autocheckstart_w : autocheckfirst_w) : autochecknever_w);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b), TRUE);
  g_snprintf(pp, sizeof(pp), "%d", listen_port);
  gtk_entry_set_text(GTK_ENTRY(listenport_w), pp);
  /* !!! FIXME !!! - stealth mode */
  gtk_widget_show(d);
  gtk_grab_add(d);  
}

