VERSION 5.00
Begin VB.UserControl SelFolder 
   ClientHeight    =   315
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4635
   ScaleHeight     =   315
   ScaleWidth      =   4635
   ToolboxBitmap   =   "SelFolder.ctx":0000
   Begin VB.TextBox txtPath 
      Height          =   315
      Left            =   540
      TabIndex        =   1
      Text            =   "D:\My Apps"
      Top             =   0
      Width           =   3615
   End
   Begin VB.CommandButton cmdSelFolder 
      Caption         =   "..."
      Height          =   315
      Left            =   4260
      TabIndex        =   2
      Top             =   0
      Width           =   315
   End
   Begin VB.Label lblCaption 
      AutoSize        =   -1  'True
      Caption         =   "Folder:"
      Height          =   195
      Left            =   0
      TabIndex        =   0
      Top             =   60
      Width           =   480
   End
End
Attribute VB_Name = "SelFolder"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const CTRL_ID = "{C596C4F0-DBFC-4C33-9B6C-4DF0BBCE9FC1}"

Private Const DEFAULT_CAPTION = "Folder:"
Private Const DEFAULT_PATH = "C:\My Documents"

Private m_lCtrlPadding As Long

Private m_bUserMode As Boolean

Private p_sSavingApp As String
Private p_sSavingKey As String

Private Sub cmdSelFolder_Click()
   Dim bff As New CBrowseForFolder
   Dim sFldr As String
   
   With bff
      .InitialDir = txtPath
      .UseNewUI = True
      .NoNewFolderButton = True
   End With
   
   sFldr = bff.BrowseForFolder
   
   If Len(sFldr) > 0 Then
      txtPath = sFldr
   End If
End Sub

Private Sub txtPath_Validate(Cancel As Boolean)
   txtPath = Trim$(txtPath)
End Sub

Private Sub UserControl_Initialize()
   m_lCtrlPadding = 4 * Screen.TwipsPerPixelX
End Sub

Private Sub UserControl_InitProperties()
   Caption = DEFAULT_CAPTION
   Path = DEFAULT_PATH
   SavingApp = vbNullString
   SavingKey = vbNullString
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
   m_bUserMode = UserControl.Ambient.UserMode

   Caption = PropBag.ReadProperty("Caption", DEFAULT_CAPTION)
   SavingApp = PropBag.ReadProperty("SavingApp", vbNullString)
   SavingKey = PropBag.ReadProperty("SavingKey", vbNullString)
   
   If m_bUserMode And Len(p_sSavingApp) > 0 And Len(p_sSavingKey) > 0 Then
      Path = GetSetting(CTRL_ID, p_sSavingApp, p_sSavingKey, PropBag.ReadProperty("Path", DEFAULT_PATH))
   Else
      Path = PropBag.ReadProperty("Path", DEFAULT_PATH)
   End If
End Sub

Private Sub UserControl_Terminate()
   If m_bUserMode And Len(p_sSavingApp) > 0 And Len(p_sSavingKey) > 0 Then
      SaveSetting CTRL_ID, p_sSavingApp, p_sSavingKey, txtPath
   End If
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
   PropBag.WriteProperty "Caption", lblCaption.Caption, DEFAULT_CAPTION
   PropBag.WriteProperty "Path", txtPath.Text, DEFAULT_PATH
   PropBag.WriteProperty "SavingApp", p_sSavingApp, vbNullString
   PropBag.WriteProperty "SavingKey", p_sSavingKey, vbNullString
End Sub

Private Sub UserControl_Resize()
   Dim X As Long
   On Error Resume Next
   cmdSelFolder.Left = UserControl.ScaleWidth - cmdSelFolder.Width
   X = lblCaption.Left + lblCaption.Width + m_lCtrlPadding
   txtPath.Move X, txtPath.Top, cmdSelFolder.Left - X - m_lCtrlPadding
End Sub

Public Property Get Caption() As String
   Caption = lblCaption
End Property

Public Property Let Caption(ByVal sNewValue As String)
   lblCaption = sNewValue
   UserControl_Resize
   PropertyChanged "Caption"
End Property

Public Property Get Path() As String
   Path = txtPath
End Property

Public Property Let Path(ByVal sNewValue As String)
   txtPath = sNewValue
   PropertyChanged "Path"
End Property

Public Property Get SavingApp() As String
   SavingApp = p_sSavingApp
End Property

Public Property Let SavingApp(ByVal sNewValue As String)
   p_sSavingApp = sNewValue
   PropertyChanged "SavingApp"
End Property

Public Property Get SavingKey() As String
   SavingKey = p_sSavingKey
End Property

Public Property Let SavingKey(ByVal sNewValue As String)
   p_sSavingKey = sNewValue
   PropertyChanged "SavingKey"
End Property

