VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.UserControl FireCraxor 
   BackColor       =   &H00000000&
   BorderStyle     =   1  'Fixed Single
   CanGetFocus     =   0   'False
   ClientHeight    =   525
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   525
   InvisibleAtRuntime=   -1  'True
   Picture         =   "FireCraxor.ctx":0000
   ScaleHeight     =   525
   ScaleWidth      =   525
   Begin MSCommLib.MSComm MSComm1 
      Left            =   1200
      Top             =   720
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   327680
   End
End
Attribute VB_Name = "FireCraxor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Private Header As String
Private Footer As String
Private m_CommPort As Integer
Private Initialized As Boolean
Private Commandbuffer As String

Public Sub SendCommand(HouseID As String, AppId As Integer, Command As String)
'What this does:
' It loads the header, command, and footer into CommandBuffer
' It then calls DoAllOfCommandBuffer, which sends the data, bit by bit,
'to the FireCracker on the comm port specified

Commandbuffer = Header & GetHouseCode(HouseID) & GetCommand(AppId, Command) & Footer

DoAllOfCommandBuffer

End Sub



Private Sub UserControl_Initialize()
'What this does:
' It sets the Header and the Footer to the default values used with the
'FireCracker control

Header = "1101010110101010"
Footer = "10101101"

Initialized = False

End Sub

Private Sub DoAllOfCommandBuffer()
'What this does:
' If this has never been called before (initialized = false) then set the
'Comm port and open it.

On Error GoTo NoWerk

If Not Initialized Then
    MSComm1.CommPort = m_CommPort
    MSComm1.PortOpen = True
    MSComm1.RTSEnable = True
    MSComm1.DTREnable = False
    Initialized = True
End If


'What this does:
'  Read the first bit in the commandbuffer, if it's 1 set RTS to low and
' DTR to high. If it's 0 set RTS to high and DTR to low. Chomp the first
' bit off of the commandbuffer. Set both DTR and RTS to high so that the
' firecracker connection doesn't die
'  This is the way that you communicate with the FireCracker plug. To send
' a 1, RTS = High, DTR = Low, and vice versa for a 0. You send one bit
' this way, set both RTS and DTR to high, and then repeat for every bit
' you want to send.

'  Keep going until an error (ie: you've run out of bits in the commandbuffer)
' occurs.

Do
    On Error GoTo Exit0
    
    If Val(Left(Commandbuffer, 1)) = 0 Then
        MSComm1.RTSEnable = False
        MSComm1.DTREnable = True
    Else
        MSComm1.RTSEnable = True
        MSComm1.DTREnable = False
    End If
    Commandbuffer = Right(Commandbuffer, Len(Commandbuffer) - 1)
    
    MSComm1.RTSEnable = True
    MSComm1.DTREnable = True
    DoEvents
Loop

MSComm1.PortOpen = False
NoWerk:
    MsgBox "There was an error in the FireCraxor control communicating with the FireCracker serial port control."
    Exit Sub
Exit0:
End Sub

Private Function GetHouseCode(Letter As String) As String
' All of this data was gleaned off of
'http://www.x10.com/manuals/cm17a_proto.txt

Select Case Letter
    Case "A":
        GetHouseCode = "0110"
    Case "B":
        GetHouseCode = "0111"
    Case "C":
        GetHouseCode = "0100"
    Case "D":
        GetHouseCode = "0101"
    Case "E":
        GetHouseCode = "1000"
    Case "F":
        GetHouseCode = "1001"
    Case "G":
        GetHouseCode = "1010"
    Case "H":
        GetHouseCode = "1011"
    Case "I":
        GetHouseCode = "1110"
    Case "J":
        GetHouseCode = "1111"
    Case "K":
        GetHouseCode = "1100"
    Case "L":
        GetHouseCode = "1101"
    Case "M":
        GetHouseCode = "0000"
    Case "N":
        GetHouseCode = "0001"
    Case "O":
        GetHouseCode = "0010"
    Case "P":
        GetHouseCode = "0011"
End Select

End Function

Private Function GetCommand(AppId As Integer, Command As String) As String
' All of this data was gleaned off of
'http://www.x10.com/manuals/cm17a_proto.txt

If AppId < 9 Then
    GetCommand = "0000"
Else
    GetCommand = "0100"
    AppId = AppId - 8
End If
Select Case AppId & Command
    Case "1ON":
        GetCommand = GetCommand & "00000000"
    Case "1OFF":
        GetCommand = GetCommand & "00100000"
    Case "2ON":
        GetCommand = GetCommand & "00010000"
    Case "2OFF":
        GetCommand = GetCommand & "00110000"
    Case "3ON":
        GetCommand = GetCommand & "00001000"
    Case "3OFF":
        GetCommand = GetCommand & "00101000"
    Case "4ON":
        GetCommand = GetCommand & "00011000"
    Case "4OFF":
        GetCommand = GetCommand & "00111000"
    Case "5ON":
        GetCommand = GetCommand & "01000000"
    Case "5OFF":
        GetCommand = GetCommand & "01100000"
    Case "6ON":
        GetCommand = GetCommand & "01010000"
    Case "6OFF":
        GetCommand = GetCommand & "01110000"
    Case "7ON":
        GetCommand = GetCommand & "01001000"
    Case "7OFF":
        GetCommand = GetCommand & "01101000"
    Case "8ON":
        GetCommand = GetCommand & "01011000"
    Case "8OFF":
        GetCommand = GetCommand & "01111000"
End Select

If Command = "BRT" Then
    GetCommand = GetCommand & "10001000"
ElseIf Command = "DIM" Then
    GetCommand = GetCommand & "10011000"
End If

End Function

'Nothing but your average run of the mill UserControl variables, get/let
' crap down here.

Public Property Get CommPort() As Integer
CommPort = m_CommPort
End Property

Public Property Let CommPort(ByVal New_CommPort As Integer)
m_CommPort = New_CommPort

End Property

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
m_CommPort = PropBag.ReadProperty("CommPort", 1)
End Sub

Private Sub UserControl_Resize()
UserControl.Height = 520
UserControl.Width = 520

End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
PropBag.WriteProperty "CommPort", m_CommPort

End Sub
