Attribute VB_Name = "VarGlobals"
'**
' Contains methods shared by the entire VarSpace Stack Library
'
' @describe
'   This module contains methods needed by the one or more classes
'   within the VarSpace library.  Function or subroutines
'   needed by more than one class will usually be found within this module.
'
' @author       Andrew F. Friedl
' @copyright    1999 BlackBox Software & Consulting
' @revised      2000.04.01 Modified comments to be DocuPro compatible.
'*
Option Explicit

'**
' Simplifies the handling of optional boolean parameters.
'
' @describe
'   This function simplifies the handling of optional method parameters
'   by returning either a default value, or a boolean value of the
'   parameter that is optional.  If the parameter is "missing" when
'   passed to this function, a default value will be returned, otherwise,
'   the boolen value of the parameter will be returned.
'
' @param    Default The default value to be returned when the optional parameter
'           is missing.
' @param    Value   The Optional parameter.
'
' @returns  A boolean value that is either CBool(Value) or Default
'*
Public Function OptParmBool(Default As Boolean, Optional Value) As Boolean
    If IsMissing(Value) Then
        OptParmBool = Default
    Else
        OptParmBool = CBool(Value)
    End If
End Function
