VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ListScanner"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'----------------------------------------------------------------------
' ListScanner.cls
'
' Author : Andrew Friedl @ Blackbox Software
' Created: 1999.12.08
' Revised:
' Purpose: an example of how to build a scanner using PatternPro RXT
' Related:
' History:
'
' Copyright 1999, BlackBox Software & Consulting
'----------------------------------------------------------------------
Option Explicit

'
' Declare your constants where they are globally accessible,
' see constants.bas for more details
'

'
' Declare an instance of the 'Base Class' rxScanner
'
Private mScan As rxScanner

Private Sub Class_Initialize()
    
    '
    ' Create a new ListScanner
    '
    Set mScan = New rxScanner
    
    '
    ' Add list tokens to the default state
    '
    AddPattern PAT_IGNORE, TOK_IGNORE
    AddPattern "\{", TOK_CBRACEL

    '
    ' add the list state to the base scanner
    '
    AddState "list", STATE_LIST
    AddPattern PAT_IGNORE, TOK_IGNORE, "list"
    AddPattern PAT_NAME, TOK_NAME, "list"
    AddPattern "=", TOK_EQUAL, "list"
    AddPattern ",", TOK_COMMA, "list"
    AddPattern "\}", TOK_CBRACER, "list"

    AddState "value", STATE_VALUE
    AddPattern PAT_IGNORE, TOK_IGNORE, "value"
    AddPattern PAT_NUMBER, TOK_NUMBER, "value"
    AddPattern PAT_DQUOTED, TOK_STRING, "value"
    AddPattern PAT_SQUOTED, TOK_STRING, "value"
    
    AddPattern PAT_DATE, TOK_DATE, "value"
    AddPattern "\{", TOK_CBRACEL, "value"

End Sub

Public Sub AddState(StateName As String, ID As Integer)
    mScan.AddState StateName, ID
End Sub

Public Sub AddPattern(Pattern As String, ID As Integer, Optional StateName As Variant)
    If IsMissing(StateName) Then
        mScan.AddPattern Pattern, ID
    Else
        mScan.AddPattern Pattern, ID, StateName
    End If
End Sub

Public Sub PushState(StateName As String)
    mScan.PushState StateName
End Sub

Public Sub PopState()
    mScan.PopState
End Sub

Public Function CurrentState() As String
    CurrentState = mScan.CurrentState
End Function

Public Function GetToken(TokenType As Integer, TokenValue As Variant) As Boolean
    Dim sTemp As String
    Dim More As Boolean
    
    TokenValue = ""
    
    Do While True
        If mScan.GetToken(TokenType, TokenValue) Then
            Select Case TokenType
            Case TOK_IGNORE
                TokenValue = ""
            Case TOK_NAME, TOK_EQUAL, TOK_CBRACEL, TOK_CBRACER, TOK_COMMA
                GetToken = True
                Exit Function
            Case TOK_STRING
                sTemp = CStr(TokenValue)
                TokenValue = Mid(sTemp, 2, Len(sTemp) - 2)
                GetToken = True
                Exit Function
            Case TOK_DATE
                sTemp = CStr(TokenValue)
                TokenValue = CDate(Mid(sTemp, 2, Len(sTemp) - 2))
                GetToken = True
                Exit Function
            Case TOK_NUMBER
                TokenValue = CDbl(TokenValue)
                GetToken = True
                Exit Function
            Case Else
                Err.Raise vbObjectError + 1, "ListScanner", "unknown token"
            End Select
        Else
            GetToken = False
            Exit Do
        End If
    Loop
End Function

Public Sub UnGetToken(Token As String)
    Call mScan.UnGetToken(Token)
End Sub

Public Property Let ScanInput(S As String)
    mScan.ScanInput = S
End Property

Public Property Get ScanInput() As String
    ScanInput = mScan.ScanInput
End Property
