/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class ColumnLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    private int verticalAlignment;
    private int hgap;
    private int vgap;
    private boolean fillWidth;
    private boolean fillHeight;
    private int horizontalAlignment;
    private Dimension targetSize = new Dimension();

    public ColumnLayout() {
        this(0, 5, 5, false, false);
    }

    public ColumnLayout(int verticalAlignment, int hgap, int vgap, boolean fillWidth, boolean fillHeight) {
        this.verticalAlignment = verticalAlignment;
        this.hgap = hgap;
        this.vgap = vgap;
        this.fillWidth = fillWidth;
        this.fillHeight = fillHeight;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setVerticalFill(boolean fillHeight) {
        this.fillHeight = fillHeight;
    }

    public boolean getVerticalFill() {
        return this.fillHeight;
    }

    public void setHorizontalFill(boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public boolean getHorizontalFill() {
        return this.fillWidth;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        this.targetSize.width = 0;
        this.targetSize.height = 0;
        for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getPreferredSize();
            this.targetSize.width = Math.max(this.targetSize.width, d2.width);
            if (i2 > 0) {
                this.targetSize.height += this.vgap;
            }
            this.targetSize.height += d2.height;
        }
        Insets insets = target.getInsets();
        this.targetSize.width += insets.left + insets.right + this.hgap * 2;
        this.targetSize.height += insets.top + insets.bottom + this.vgap * 2;
        return this.targetSize;
    }

    public Dimension minimumLayoutSize(Container target) {
        this.targetSize.width = 0;
        this.targetSize.height = 0;
        for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getMinimumSize();
            this.targetSize.width = Math.max(this.targetSize.width, d2.width);
            if (i2 > 0) {
                this.targetSize.height += this.vgap;
            }
            this.targetSize.height += d2.height;
        }
        Insets insets = target.getInsets();
        this.targetSize.width += insets.left + insets.right + this.hgap * 2;
        this.targetSize.height += insets.top + insets.bottom + this.vgap * 2;
        return this.targetSize;
    }

    private void layoutComponents(Container target, int x2, int y2, int width, int height, int first, int last) {
        Insets insets = target.getInsets();
        if (this.verticalAlignment == 1) {
            y2 += height / 2;
        }
        if (this.verticalAlignment == 2) {
            y2 += height;
        }
        for (int i2 = first; i2 < last; ++i2) {
            Component m2 = target.getComponent(i2);
            Dimension md = m2.getSize();
            if (!m2.isVisible()) continue;
            int px = this.horizontalAlignment == 0 ? x2 : (this.horizontalAlignment == 2 ? width - md.width : x2 + (width - md.width) / 2);
            m2.setLocation(px, y2);
            y2 += this.vgap + md.height;
        }
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int numcomp = target.getComponentCount();
        int x2 = insets.left + this.hgap;
        int y2 = 0;
        int colw = 0;
        int start = 0;
        for (int i2 = 0; i2 < numcomp; ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getPreferredSize();
            if (this.fillHeight && i2 == numcomp - 1) {
                d2.height = Math.max(maxheight - y2, m2.getPreferredSize().height);
            }
            if (this.fillWidth) {
                m2.setSize(maxwidth, d2.height);
                d2.width = maxwidth;
            } else {
                m2.setSize(d2.width, d2.height);
            }
            if (y2 + d2.height > maxheight) {
                return;
            }
            if (y2 > 0) {
                y2 += this.vgap;
            }
            y2 += d2.height;
            colw = Math.max(colw, d2.width);
        }
        this.layoutComponents(target, x2, insets.top + this.vgap, colw, maxheight - y2, start, numcomp);
    }
}

