// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : unfeed.c
// Description  : This program is an  "un-filter feed" program.
//                That is to say that it recreates the individual
//                files from a redirected file containing the
//                "lumped" output from the ffeed program.
//
//                The filename is stored after an ascii character 12
//                (the printer formfeed caharacter) in column 0 as
//                a separator between files in "lumped" files.
//                A lumped file is non-compressed plain ascii text
//                with filename separators in between file sections
//                as noted above.
//
//                Originally written to "dearc aztec arcs"...
//                That is to say, to "un-lump" the source files
//                that were stored in the same lumped text format
//                by Manx Software in the distribution of their C
//                compiler source. These had the extension.arc.
//
//                Handles long filenames under Win9x/NT.
// Written by   : Bill Buckels
// Date Written : 1990
// Revision     : 2.0 Second Release
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

unsigned char filename[_MAX_PATH];

int nocr(char *ptr)
{
  int i;
  
  i = 0;
  for(;;)
  {
    if(ptr[i] == 10 || ptr[i] == 13 || ptr[i] == '\x1a')ptr[i] = 0;
    if(ptr[i] == 0)break;
    i++;
  }
  
  return i;
  
}


#define _MAX_BUFFER_SIZE  2048
#define _MAX_BUFFER_LEN   (_MAX_BUFFER_SIZE - 1)

char buffer[_MAX_BUFFER_SIZE];

void main(int argc,char **argv)
{
   FILE *fp, *fp2;

   int DONE=0, STARTED=0;

   if(argc < 2 || (fp=fopen(argv[1],"r"))==NULL)
   {
      perror(argv[1]);
      exit(0);
    }

    while(!(STARTED))
    {
      if(fgets(buffer,_MAX_BUFFER_LEN,fp)==NULL)
      {
        DONE++;
        STARTED++;
        break;
      }

      if(buffer[0]==0x0c)
      {
        STARTED++;
        nocr(buffer);
        if((fp2=fopen(&buffer[1],"w"))==NULL) {
          perror(&buffer[1]);
        }
      }
    }

    if(!(DONE))
    {
      while(fgets(buffer,_MAX_BUFFER_LEN,fp)!=NULL)
      {
        if(buffer[0]==0x0c)
        {
          if (fp2 != NULL)
            fclose(fp2);
          nocr(buffer);
          if((fp2=fopen(&buffer[1],"w"))==NULL)perror(&buffer[1]);
        }
        else  {
          if (fp2 != NULL)
            fputs(buffer,fp2);
        }
      }
    }

    fclose(fp);
    if(fp2 != NULL)fclose(fp2);
    exit(0);
}
