
'       FILE: dxxxlib.bas
'
'Macros to get at the class and model parts of a device ID
 
'Global Const dl_devclass(i)  ((i) & &HFF00)
'Global Const dl_devmodel(i)  ((i) & &H00FF)

Global Const DEV_CLASS_VOICE = "Voice"

'
'Maximum terminator values.
 
Global Const MAX_TC_TIMER = 6000  ' Max time units for term. conditions

'
'Values for setting hook state
 
Global Const DL_ONHOOK = 0
Global Const DL_OFFHOOK = 1
Global Const DX_ONHOOK = 0
Global Const DX_OFFHOOK = 1

'
'       Define Event Types

Global Const TDX_PLAY = &H81           ' Play Completed
Global Const TDX_RECORD = &H82         ' Record Completed
Global Const TDX_GETDIG = &H83         ' Get Digits Completed
Global Const TDX_DIAL = &H84           ' Dial Completed
Global Const TDX_CALLP = &H85          ' Call Progress Completed
Global Const TDX_CST = &H86            ' CST Event Received
Global Const TDX_SETHOOK = &H87        ' SetHook Completed
Global Const TDX_WINK = &H88           ' Wink Completed
Global Const TDX_PLAYTONE = &H8A       ' Play Tone Completed
Global Const TDX_GETR2MF = &H8B        ' Get R2MF completed

Global Const TDX_ERROR = &H89          ' Error Event
Global Const DX_ATOMIC_ERR = &HEE      ' Error event for Atomic Funcs

'
'qDefine sendevt flag values

Global Const EVFL_SENDSELF = &H1       ' Send event to self process
Global Const EVFL_SENDOTHERS = &H2     ' Send event to other processes
Global Const EVFL_SENDALL = &H3        ' Send event to all processes

'
'Error codes returned by ATDV_LASTERR()
 
Global Const EDX_NOERROR = 0        ' No Errors
Global Const EDX_SYSTEM = 1         ' System Error
Global Const EDX_FWERROR = 2        ' Firmware Error
Global Const EDX_TIMEOUT = 3        ' Function Timed Out
Global Const EDX_BADIOTT = 4        ' Invalid Entry in the DX_IOTT
Global Const EDX_BADTPT = 5         ' Invalid Entry in the DX_TPT
Global Const EDX_BADPARM = 6        ' Invalid Parameter in Function Call
Global Const EDX_BADDEV = 7         ' Invalid Device Descriptor
Global Const EDX_BADPROD = 8        ' Func. Not Supported on this Board
Global Const EDX_BUSY = 9           ' Device is Already Busy
Global Const EDX_IDLE = 10          ' Device is Idle
Global Const EDX_STOPRINGS = 11     ' Stop waitrings (MT only)
Global Const EDX_BADWAVEFILE = 12   ' Bad/Unsupported WAV file
Global Const EDX_XPBPARM = 13       ' Bad XPB structure
Global Const EDX_NOSUPPORT = 14     ' Data format not supported
Global Const EDX_NOTIMP = 15        ' Function not implemented

'
'GTD Error Codes
 
Global Const EDX_TONEID = &H41      ' Bad Tone Template ID
Global Const EDX_MAXTMPLT = &H42    ' Max number of Templates Exists
Global Const EDX_INVSUBCMD = &H43   ' Invalid Sub Command Number
Global Const EDX_CHANNUM = &H44     ' Invalid Channel Number Specified
Global Const EDX_FREQDET = &H45     ' Invalid Freq Component Values
                                    ' in Tone Template Description
Global Const EDX_CADENCE = &H46     ' Invalid Cadence Component Values
                                    ' in Tone Template Description
Global Const EDX_ASCII = &H47       ' Invalid Ascii Value
                                    ' in Tone Template Description
Global Const EDX_DIGTYPE = &H48     ' Invalid Dig_Type Value
                                    ' in Tone Template Description
Global Const EDX_MSGSTATUS = &H49   ' Invalid Message Status Setting

'
'Speed and Volume Control Error Codes
 
Global Const EDX_SVADJBLKS = &H4A   ' Invalid Number of Speed/Volume
                                    ' Adjustment Blocks
Global Const EDX_SPDVOL = &H4B      ' Must Specify either SV_SPEEDTBL or
                                    ' SV_VOLUMETBL
Global Const EDX_SVMTSIZE = &H4C    ' Invalid Table Size Specified
Global Const EDX_SVMTRANGE = &H4D   ' An out of Range entry in DX_SVMT
Global Const EDX_NONZEROSIZE = &H4E ' Reset to Default was Requested but
                                    ' size was non-zero
'
'GTG Error Codes
 
Global Const EDX_FLAGGEN = &H4F     ' Invalid tg_dflag field in
                                    ' Tone Generation Template
Global Const EDX_FREQGEN = &H50     ' Invalid Frequency Component in
                                    ' Tone Generation Template
Global Const EDX_AMPLGEN = &H51     ' Invalid Amplitude Value in
                                    ' Tone Generation Template
'
'Switch Handler / SCSA  Error Codes
 
Global Const EDX_SH_CMDBLOCK = &H59   ' Blocking Command is in progress
Global Const EDX_SH_BADCMD = &H60     ' Command not supported
Global Const EDX_SH_LIBBSY = &H61     ' Switching Handler Lib is busy
Global Const EDX_SH_BADINDX = &H62    ' Invalid Switching Handler indx #
Global Const EDX_SH_LIBNOTINIT = &H63 ' Switching Handler Library has not been initialized
Global Const EDX_SH_NOCLK = &H64      ' Switching Handler Clock fallback failed
Global Const EDX_SH_MISSING = &H66    ' Switching Handler is not Present
Global Const EDX_SH_BADMODE = &H6A    ' Invalid Switching Handler Bus Mode
Global Const EDX_SH_BADLCLTS = &H6F   ' Invalid local timeslot (Channel)
Global Const EDX_SH_BADTYPE = &H70    ' Invalid local timeslot type
Global Const EDX_SH_BADEXTTS = &H71   ' External timeslot not supported at current clock rate
Global Const EDX_SH_LCLTSCNCT = &H72  ' Channel is already connected to SCbus
Global Const EDX_SH_LCLDSCNCT = &H73  ' Channel is already disconnected from SCbus

'
'Error Codes Specific to caller ID
 
Global Const EDX_CLIDINFO = &H80    ' caller ID info/sub-msg not available
Global Const EDX_CLIDBLK = &H81     ' caller ID private ('P') or blocked
Global Const EDX_CLIDOOA = &H82     ' caller ID out of area ('O')

'
'Error Codes Specific to PBXpert TSF loading
 
Global Const EDX_BADREGVALUE = &H90   ' Unable to locate value in registry
Global Const EDX_BADTSFFILE = &H91    ' Filename doesn't exist or not valid TSF
Global Const EDX_BADTSFDATA = &H92    ' TSF Data not consolidated
Global Const EDX_FEATUREDISABLED = &H93     ' TSF File Support Disabled
'
'Equates for generic caller ID message type IDs
 
Global Const CLIDINFO_CMPLT = &H100          ' complete caller ID message
Global Const CLIDINFO_GENERAL = &H101        ' date,time,phone #,name
Global Const CLIDINFO_CALLID = &H102         ' caller ID
Global Const CLIDINFO_FRAMETYPE = &H103      ' see frame type equates

'
'Equates for CLASS
 
Global Const CLASSFRAME_SDM = &H4        ' Single Data Message caller ID frame
Global Const CLASSFRAME_MDM = &H80       ' Multiple Data Message caller ID frame
' CLASS MDM message IDs
Global Const MCLASS_DATETIME = &H1       ' date and time w/o '/" & ':'
Global Const MCLASS_DN = &H2             ' calling line directory number
Global Const MCLASS_DDN = &H3            ' dialed number
Global Const MCLASS_ABSENCE1 = &H4       ' caller ID absence: 'O' or 'P'
Global Const MCLASS_REDIRECT = &H5       ' call frwd-universal,busy,or unanswered
Global Const MCLASS_QUALIFIER = &H6      ' 'L' for long distance
Global Const MCLASS_NAME = &H7           ' caller name
Global Const MCLASS_ABSENCE2 = &H8       ' name absence- 'O' or 'P'

'
'Equates for CLIP
 
Global Const CLIPFRAME_MDM = &H80        ' Multiple Data Message caller ID frame
' CLIP message IDs
Global Const CLIP_DATETIME = &H1         ' date and time (w/o '/" & ':')
Global Const CLIP_DN = &H2               ' calling line directory number
Global Const CLIP_DDN = &H3              ' dialed number
Global Const CLIP_ABSENCE1 = &H4         ' caller ID absence: 'O' or 'P'
Global Const CLIP_NAME = &H7             ' caller name
Global Const CLIP_ABSENCE2 = &H8         ' name absence- 'O' or 'P'
Global Const CLIP_CALLTYPE = &H11        ' voice call,rng-bck-when-free call or msg waiting call
Global Const CLIP_NETMSG = &H13          ' no. of message waiting

'
'Equates for A-CLIP
 
Global Const ACLIPFRAME_SDM = &H4        ' Single Data Message caller ID frame
Global Const ACLIPFRAME_MDM = &H80       ' Multiple Data Message caller ID frame
' A-CLIP MDM message IDs
Global Const MACLIP_DATETIME = &H1       ' date and time (w/o '/" & ':'
Global Const MACLIP_DN = &H2             ' calling line directory number
Global Const MACLIP_DDN = &H3            ' dialed number
Global Const MACLIP_ABSENCE1 = &H4       ' caller ID absence: 'O' or 'P'
Global Const MACLIP_REDIRECT = &H5       ' call frwd-universal,busy,or unanswered
Global Const MACLIP_QUALIFIER = &H6      ' 'L' for long distance
Global Const MACLIP_NAME = &H7           ' caller name
Global Const MACLIP_ABSENCE2 = &H8       ' name absence- 'O' or 'P'

'
'Defines for for channel state values
 
Global Const CS_IDLE = 1         ' Channel is idle
Global Const CS_PLAY = 2         ' Channel is playing back
Global Const CS_RECD = 3         ' Channel is recording
Global Const CS_DIAL = 4         ' Channel is dialing
Global Const CS_GTDIG = 5        ' Channel is getting digits
Global Const CS_TONE = 6         ' Channel is generating a tone
Global Const CS_STOPD = 7        ' Operation has terminated
Global Const CS_SENDFAX = 8      ' Channel is sending a fax
Global Const CS_RECVFAX = 9      ' Channel is receiving a fax
Global Const CS_CALL = 13        ' Channel is Call Progress Mode
Global Const CS_GETR2MF = 14     ' Channel is Getting R2MF

'
'This is a complex state composed of one of the
'above states and faxmode.
 
Global Const CS_FAXIO = 10       ' Channel is between fax pages

'
'Define a channel state for the remaining blocking commands
 
Global Const CS_HOOK = 11        ' A change in hookstate is in progress
Global Const CS_WINK = 12        ' A wink operation is in progress
Global Const CS_RINGS = 15       ' Call status Rings state

'
'D/4X Events and masks
 
Global Const DE_RINGS = 1        ' Rings received
Global Const DE_SILON = 2        ' Silence on
Global Const DE_SILOF = 3        ' Silenec off
Global Const DE_LCON = 4         ' Loop current on
Global Const DE_LCOF = 5         ' Loop current off
Global Const DE_WINK = 6         ' Wink received
Global Const DE_RNGOFF = 7       ' Ring off event
Global Const DE_DIGITS = 8       ' Digit Received
Global Const DE_DIGOFF = 9       ' Digit tone off event
Global Const DE_LCREV = 13       ' Loop current reversal
Global Const DE_TONEON = 17      ' Tone ON  Event Received
Global Const DE_TONEOFF = 18     ' Tone OFF Event Received
Global Const DE_STOPRINGS = 19   ' Stop ring detect state

' Alt. defines for DM_SILOF, DM_LCOF are DM_SILOFF and DM_LCOFF
'
'Event mask values
 
Global Const DM_RINGS = 1      ' ( 1 << (DE_RINGS - 1) )
Global Const DM_SILON = 2      ' ( 1 << (DE_SILON - 1) )
Global Const DM_SILOF = 4      ' ( 1 << (DE_SILOF - 1) )
Global Const DM_LCON = 8       ' ( 1 << (DE_LCON - 1) )
Global Const DM_LCOF = 16      ' ( 1 << (DE_LCOF - 1) )
Global Const DM_LCREV = 4096   ' ( 1 << (DE_LCREV - 1) )
Global Const DM_WINK = 32      ' ( 1 << (DE_WINK - 1) )
Global Const DM_RNGOFF = 64    ' ( 1 << (DE_RNGOFF - 1) )
Global Const DM_DIGITS = 128   ' ( 1 << (DE_DIGITS - 1) )
Global Const DM_DIGOFF = 256   ' ( 1 << (DE_DIGOFF - 1) )

'
'Termination reasons
 
Global Const T_NORML = 0         ' Normal termination
Global Const T_MXDIG = 1         ' Max. digits received
Global Const T_MXSIL = 2         ' Max. silence exceeded
Global Const T_MXNSIL = 3        ' Max. non-silence exceeded
Global Const T_LOOP = 4          ' Loop current drop
Global Const T_IDIG = 5          ' Max. inter-digit delay exceeded
Global Const T_MXSEC = 6         ' Max. time elapsed
Global Const T_TDIG = 7          ' Terminating digit received
Global Const T_PATRN = 8         ' Pattern match detected
Global Const T_STOP = 9          ' Stopped by user
Global Const T_EOD = 10          ' End of data on playback
Global Const T_ERR = 13          ' I/O device error

'
'Masked DTMF termination/initiation equates
 
Global Const DM_D = &H1              ' Mask for DTMF d.
Global Const DM_1 = &H2              ' Mask for DTMF 1.
Global Const DM_2 = &H4              ' Mask for DTMF 2.
Global Const DM_3 = &H8              ' Mask for DTMF 3.
Global Const DM_4 = &H10             ' Mask for DTMF 4.
Global Const DM_5 = &H20             ' Mask for DTMF 5.
Global Const DM_6 = &H40             ' Mask for DTMF 6.
Global Const DM_7 = &H80             ' Mask for DTMF 7.
Global Const DM_8 = &H100            ' Mask for DTMF 8.
Global Const DM_9 = &H200            ' Mask for DTMF 9.
Global Const DM_0 = &H400            ' Mask for DTMF 0.
Global Const DM_S = &H800            ' Mask for DTMF *.
Global Const DM_P = &H1000           ' Mask for DTMF #.
Global Const DM_A = &H2000           ' Mask for DTMF a.
Global Const DM_B = &H4000           ' Mask for DTMF b.
Global Const DM_C = &H8000           ' Mask for DTMF c.

'
'Macros to get the parts out of a parameter ID
 
'Global Const parmtype(id) (((id) >> 8) & &HF)   ' High byte, lo nibble
'Global Const parmnumb(id) (((id) & &HFF) - 1)   ' Low byte

'
'D/4x Parameter Type Equates
 
Global Const PT_BD = 0            ' Board parameter
Global Const PT_CH = 1            ' Channel parameter

'
'Defines used by the parameter functions
 
Global Const PM_BD = &H800000           ' Board Level Parameter
Global Const PM_CH = &H0                ' Channel Level Parameter

Global Const PM_DXXX = &H0              ' D/xxx Parameter
Global Const PM_D12X = &H1000000        ' D/12x Parameter
Global Const PM_MF40 = &H2000000        ' MF/40 Parameter
Global Const PM_D12XDEV = &H4000000

Global Const PM_FW = &H0                ' Firmware Parameter
Global Const PM_DRV = &H8000000         ' Driver Parameter
Global Const PM_LIB = &H10000000        ' Library Parameter

Global Const PRM_DEST = &H18000000
Global Const PRM_DEVTYP = &H7000000
Global Const PRM_DATTYP = &HE0000000
Global Const PRM_NUM = &HFFFF
Global Const PRM_TERM = &H7F0000

Global Const PM_BYTE = &H0              ' Byte
Global Const PM_SHORT = &H20000000      ' Short
Global Const PM_INT = &H40000000        ' Int
Global Const PM_LONG = &H60000000       ' Long
Global Const PM_VLSTR = &H80000000      ' Variable Length String
Global Const PM_FLSTR = &HA0000000      ' Fixed Length String

Global Const PM_VLSTR_MAXLEN = 128 ' Max Length for Variable Length Parms

'
'CHANNEL PARAMETERS
 
' DTMF anti-talkoff during playback
Global Const DXCH_DTMFTLK = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H101)

' DTMF debounce time
Global Const DXCH_DTMFDEB = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H201)

' DTMF initiation bitmap
Global Const DXCH_DTINITSET = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H203)

' Delay after ring recvd before winking
Global Const DXCH_WINKDLY = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H204)

' Duration of wink (off-hook state)
Global Const DXCH_WINKLEN = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H205)

' Min LC on to be recognized as wink
Global Const DXCH_MINRWINK = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H206)

' Max LC on to be recognized as wink
Global Const DXCH_MAXRWINK = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H207)

' Length of DTMF digit for dialing
Global Const DXCH_TTDATA = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H208)

' Length of TT inter digit delay
Global Const DXCH_T_IDD = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H209)

' MF detection mask
Global Const DXCH_MFMODE = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H201)

' Diagnostic mask
Global Const DXCH_MFDIAG = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H202)

' Per channel dig rate: play (D/xxx only)
Global Const DXCH_PLAYDRATE = ((PM_SHORT Or PM_FW Or PM_D12X Or PM_CH) Or &HE01)

' Per channel dig rate: rec (D/xxx only)
Global Const DXCH_RECRDRATE = ((PM_SHORT Or PM_FW Or PM_D12X Or PM_CH) Or &HE02)

' DTMF detection edge select
Global Const DXCH_DFLAGS = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &H801)

' Per channel ring count
Global Const DXCH_RINGCNT = ((PM_SHORT Or PM_DRV Or PM_DXXX Or PM_CH) Or &H1)

' Enable/disable Caller ID
Global Const DXCH_CALLID = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &HE04)

' Enable/disable Caller ID values
Global Const DX_CALLIDDISABLE = &H0       ' Disable Caller ID
Global Const DX_CALLIDENABLE = &H1        ' Enable Caller ID

' Enable/disable Audio line-in
Global Const DXCH_AUDIOLINEIN = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_CH) Or &HE05)

' Enable/disable Audio line-in values
Global Const DX_LINEINDISABLE = &H0       ' Disable audio line-in connection
Global Const DX_LINEINENABLE = &H1        ' Enable audio line-in connection

' DTMF Digit buffering mode
Global Const DXCH_DIGBUFMODE = ((PM_SHORT Or PM_LIB Or PM_DXXX Or PM_CH) Or &H2)

' DTMF Digit buffering modes
Global Const DX_DIGCYCLIC = 1      ' Cyclic shift digits once buffer is full
Global Const DX_DIGTRUNC = 2       ' Truncate digits once buffer is full

'
'Board Parameters
 
' Flash character in dial string
Global Const DXBD_FLASHCHR = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H301)

' Init delay time
Global Const DXBD_INITDLY = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H302)

' Min time of LC on for LPD
Global Const DXBD_MINPDON = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H303)

' Min time of LC off for LPD
Global Const DXBD_MINPDOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H304)

' Length of DTMF digit for dialing
Global Const DXBD_TTDATA = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H305)

' Min time of silence on for APD
Global Const DXBD_MINSLON = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H306)

' Min time for silence off for APD
Global Const DXBD_MINSLOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H307)

' Min time for dti signal on
Global Const DXBD_MINTION = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H308)

' Min time for dti signal off
Global Const DXBD_MINTIOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H309)

' Edge of ring detection
Global Const DXBD_R_EDGE = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H30A)

' Flash time during dialing
Global Const DXBD_FLASHTM = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H401)

' Pause time during dialing
Global Const DXBD_PAUSETM = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H402)

' Minimum off-hook time
Global Const DXBD_MINOFFHKTM = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H403)

' Length of pulse dialing make
Global Const DXBD_P_MK = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H404)

' Length of pulse dialing break
Global Const DXBD_P_BK = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H405)

' Length of pulse inter digit delay
Global Const DXBD_P_IDD = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H406)

' Length of TT inter digit delay
Global Const DXBD_T_IDD = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H407)

' Delay before offhook finished
Global Const DXBD_OFFHDLY = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H408)

' Min time for ring detection
Global Const DXBD_R_ON = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H409)

' Min time for for the end of a ring
Global Const DXBD_R_OFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40A)

' Max wait between rings
Global Const DXBD_R_IRD = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40B)

' Silence on and off debounce time
Global Const DXBD_S_BNC = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40C)

' Min interpulse digit time for LPD
Global Const DXBD_MINIPD = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40D)

' Min time of lc off before message
Global Const DXBD_MINLCOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40E)

' Max time for lc off for LPD
Global Const DXBD_MAXPDOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H40F)

' Min time for silence on for APD
Global Const DXBD_MINISL = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H410)

' Max time for silence off for  APD
Global Const DXBD_MAXSLOFF = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H411)

' Either a D/40 or D/41
Global Const DXBD_HWTYPE = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H601)

' Number of channels on board
Global Const DXBD_CHNUM = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H602)

' System configuration
Global Const DXBD_SYSCFG = ((PM_SHORT Or PM_FW Or PM_DXXX Or PM_BD) Or &H604)

'
'NOTE: Must use PM_CH instead of PM_BD on MF40 paramters.
 
' Min time for MF detection
Global Const DXBD_MFMINON = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H101)

' Duration of MF tone during dial
Global Const DXBD_MFTONE = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H102)

' Inter-digit delay during MF dialing
Global Const DXBD_MFDELAY = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H103)

' Duration of LKP tone during MF dialing
Global Const DXBD_MFLKPTONE = ((PM_SHORT Or PM_FW Or PM_MF40 Or PM_CH) Or &H104)

'
'Board Parameter values
 
'
'When a rings received message is sent (BD_R_EDGE)
 
Global Const ET_RON = 1        ' At the beginning of the ring
Global Const ET_ROFF = 2       ' At the end of the ring

'
'Channel Mode values
 
Global Const MD_ADPCM = &H0          ' ADPCM data (the default)
Global Const MD_PCM = &H100          ' Mu-Law PCM data
Global Const MD_GAIN = &H0           ' AGC on
Global Const MD_NOGAIN = &H1000      ' AGC off
Global Const PM_TONE = &H1           ' Tone initiated play/record
Global Const RM_TONE = PM_TONE
Global Const PM_SR6 = &H2000         ' 6KHz sampling rate (digitization)
Global Const PM_SR8 = &H4000         ' 8KHz sampling rate (digitization)
Global Const RM_SR6 = PM_SR6
Global Const RM_SR8 = PM_SR8
Global Const PM_ALAW = &H20          ' Play A-Law data
Global Const RM_ALAW = PM_ALAW       ' Record data using A-Law
Global Const PM_DTINIT = &H2         ' Play with DTMF init
Global Const RM_DTINIT = PM_DTINIT ' Record with DTMF init
Global Const PM_DTINITSET = &H10 Or PM_DTINIT    ' Play with DTMF init set
Global Const RM_DTINITSET = PM_DTINITSET  ' Record with DTMF init set
Global Const R2_COMPELDIG = &H400    ' R2MF Compelled signalling

'
'Channel modes for ADSI support
 
Global Const PM_RAW = &H200          ' Raw playback mode
Global Const PM_ADSI = &H80          ' ADSI playback mode
Global Const PM_ADSIALERT = PM_ADSI Or PM_DTINITSET Or PM_TONE

'
'Alternate defines for DE_SILOF, DM_SILOF, DE_LCOF, DM_LCOF
 
Global Const DE_SILOFF = DE_SILOF
Global Const DE_LCOFF = DE_LCOF
Global Const DM_SILOFF = DM_SILOF
Global Const DM_LCOFF = DM_LCOF

'
'Define's for Mode Checking
 
Global Const MD_SELECT = (MD_PCM)

Global Const EV_ASYNC = &H8000
Global Const EV_SYNC = &H0

'
'Raw Line Status Defines
 
Global Const RLS_SILENCE = &H80  ' Sil Bit in Raw Line Status
Global Const RLS_DTMF = &H40     ' DTMF Signal Bit in Raw Line Status
Global Const RLS_LCSENSE = &H20  ' Loop Current Sense Bit in Raw Line Status
Global Const RLS_RING = &H10     ' Ring Detect Bit in Raw Line Status
Global Const RLS_HOOK = &H8      ' Hook Switch Status Bit in Raw Line Status
Global Const RLS_RINGBK = &H4    ' Audible Ringback Detect Bit in Raw Line Status

'
'GTD Defines
 
Global Const DM_TONEON = &H1     ' Tone ON Mask
Global Const DM_TONEOFF = &H2    ' Tone OFF Mask

Global Const TONEALL = &HFFFF           ' Enable/Disable All Tone ID's

Global Const TN_SINGLE = 0       ' Single Tone
Global Const TN_DUAL = 1         ' Dual Tone

'
'Template Modes and Frequency for GTD
 
Global Const TN_FREQDEV = 5      ' Frequency Deviation

Global Const TN_CADENCE = &H1   ' Cadence Detection
Global Const TN_LEADING = &H2    ' Leading Edge Detection
Global Const TN_TRAILING = &H4   ' Trailing Edge Detection

'
'Digit Type Values for User-Defined Tone Templates for GTD
 
Global Const DG_USER1 = 5        ' User Defined Tone
Global Const DG_USER2 = 6        ' User Defined Tone
Global Const DG_USER3 = 7        ' User Defined Tone
Global Const DG_USER4 = 8        ' User Defined Tone
Global Const DG_USER5 = 9        ' User Defined Tone

'
'Ascii digit type returned in DV_DIGIT structure.
 
Global Const DG_DTMF_ASCII = &H30      ' DTMF Digit
Global Const DG_LPD_ASCII = &H31       ' Loop Pulse Digit
Global Const DG_APD_ASCII = &H32       ' Audio Pulse Digit
Global Const DG_DPD_ASCII = &H32       ' Dial Pulse Digit
Global Const DG_MF_ASCII = &H33        ' MF Digit

'
'Speed and Volume Control Defines

Global Const SV_SPEEDTBL = &H1         ' Modify Speed
Global Const SV_VOLUMETBL = &H2        ' Modify Volume

Global Const SV_ABSPOS = &H0           ' Absolute Position
Global Const SV_RELCURPOS = &H10       ' Relative to Current Position
Global Const SV_TOGGLE = &H20          ' Toggle

Global Const SV_WRAPMOD = &H10
Global Const SV_SETDEFAULT = &H20
Global Const SV_LEVEL = &H100
Global Const SV_BEGINPLAY = &H200

'
'Toggle Modes for Play Adjustment Conditions
 
Global Const SV_TOGORIGIN = &H0     ' Toggle Between Origin and Last
                                                                        ' Modified Position
Global Const SV_CURORIGIN = &H1     ' Reset Current Position to Origin
Global Const SV_CURLASTMOD = &H2    ' Reset Current Position to Last
                                                                        ' Modified Position
Global Const SV_RESETORIG = &H3     ' Reset Current Position and Last
                                                                        ' Modified State to Origin
'
'Defines for dx_addspddig()
 
Global Const SV_ADD10PCT = 1     ' Speed up Play-Back 10 Percent
Global Const SV_ADD20PCT = 2     ' Speed up Play-Back 20 Percent
Global Const SV_ADD30PCT = 3     ' Speed up Play-Back 30 Percent
Global Const SV_ADD40PCT = 4     ' Speed up Play-Back 40 Percent
Global Const SV_ADD50PCT = 5     ' Speed up Play-Back 50 Percent
Global Const SV_SUB10PCT = -1    ' Slow Down Play-Back 10 Percent
Global Const SV_SUB20PCT = -2    ' Slow Down Play-Back 20 Percent
Global Const SV_SUB30PCT = -3    ' Slow Down Play-Back 30 Percent
Global Const SV_SUB40PCT = -4    ' Slow Down Play-Back 40 Percent

Global Const SV_NORMAL = &HFF    ' Set Play-Back to Normal Speed/Volume

'
'Defines for dx_addvoldig()
 
Global Const SV_ADD2DB = 1       ' Increase Play-Back Volume by 2db
Global Const SV_ADD4DB = 2       ' Increase Play-Back Volume by 4db
Global Const SV_ADD6DB = 3       ' Increase Play-Back Volume by 6db
Global Const SV_ADD8DB = 4       ' Increase Play-Back Volume by 8db
Global Const SV_SUB2DB = -1      ' Decrease Play-Back Volume by 2db
Global Const SV_SUB4DB = -2      ' Decrease Play-Back Volume by 4db
Global Const SV_SUB6DB = -3      ' Decrease Play-Back Volume by 6db
Global Const SV_SUB8DB = -4      ' Decrease Play-Back Volume by 8db

Global Const IGNORESTATE = 1

'
'Wave file support defines
 
'
'File formats
 
Global Const FILE_FORMAT_VOX = 1       ' Dialogic VOX format
Global Const FILE_FORMAT_WAVE = 2      ' Microsoft Wave format

'
'Sampling rate
 
Global Const DRT_6KHZ = &H30           ' 6KHz
Global Const DRT_8KHZ = &H40           ' 8KHz
Global Const DRT_11KHZ = &H58          ' 11KHz

'
'Data format
 
Global Const DATA_FORMAT_DIALOGIC_ADPCM = &H1   ' OKI ADPCM
Global Const DATA_FORMAT_ALAW = &H3             ' alaw PCM
Global Const DATA_FORMAT_MULAW = &H7            ' mulaw PCM
Global Const DATA_FORMAT_PCM = &H8              ' PCM

'
'dx_gtsernum() subfunctions
 
Global Const GS_SN = &H0         ' return board serial number, 8 bytes ASCIIZ string
Global Const GS_SSN = &H1        ' return board silicon serial number, 8 bytes

'
'Value defines
 
' device family
Global Const CT_DFD41E = &H2
Global Const CT_DFSPAN = &H3
Global Const CT_DFMSI = &H4

' device mode
Global Const CT_DMNETWORK = &H0
Global Const CT_DMRESOURCE = &H1

' network type
Global Const CT_NTNONE = &H0
Global Const CT_NTT1 = &H1
Global Const CT_NTE1 = &H2
Global Const CT_NTANALOG = &H3
Global Const CT_NTMSI = &H4

' bus mode
Global Const CT_BMPEB = &H0
Global Const CT_BMSCBUS = &H1

' bus encoding
Global Const CT_BEULAW = &H0
Global Const CT_BEALAW = &H1

