{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}


{Special thanks to Vadim Yegorov <zg@matrica.apollo.lv>}

unit pFIBStoredProc;

interface

{$I FIBPlus.inc}
uses
  pFIBQuery, FIBQuery,Classes;
type
  TpFIBStoredProc = class(TpFIBQuery)
  private
    FStoredProc: string;
    procedure SetStoredProc(const Value: string);
  protected
  public
    constructor Create(AOwner: TComponent); override;
  published
    property StoredProcName: string read FStoredProc write SetStoredProc;
  end;

implementation

uses
   pFIBDatabase, StrUtil, SysUtils,pFIBDataInfo;

procedure TpFIBStoredProc.SetStoredProc(const Value: string);
var ProcName:string; 
begin
  if (Value <> FStoredProc) then
  begin
   FStoredProc := Value;
   if not (csReading in ComponentState) then begin
     FBase.CheckDatabase;
     if  IsBlank(Value) then
      SQL.Clear
     else begin
      ProcName:=EasyFormatIdentifier(Database.SQLDialect, FStoredProc,
       Database.EasyFormatsStr
      );  
      SQL.Text :=
       ListSPInfo.GetExecProcTxt(Database,
        ProcName
        ,csDesigning in ComponentState
       ); 
     end;
   end;
  end;
end;

constructor TpFIBStoredProc.Create(AOwner: TComponent);
begin
  inherited;
  FStoredProc := '';
end;


end.

